/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;

public class MoePrinter {
    static final String CONTINUED_LABEL = Config.getString((String)"editor.printer.continued");
    private final int HEADER_SPACE = 30;
    private final int FOOTER_SPACE = 20;
    private final int PADDING = 5;
    private final char TAB_CHAR = (char)9;
    private Book pages = new Book();
    private static int titleFontSize = Config.getPropInteger((String)"bluej.fontsize.printTitle", (int)14);
    private static int footerFontSize = Config.getPropInteger((String)"bluej.fontsize.printInfo", (int)10);
    private static Font titleFont = new Font("SansSerif", 1, titleFontSize);
    private static Font smallTitleFont = new Font("SansSerif", 1, 10);
    private static Font footerFont = new Font("SansSerif", 2, 9);
    private String className;
    private int tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean printDocument(PrinterJob printJob, PlainDocument document, String className, Font font, PageFormat format) {
        ArrayList<String> lines = new ArrayList<String>();
        this.className = className;
        Integer tabSizeAsInteger = (Integer)document.getProperty("tabSize");
        if (tabSizeAsInteger != null) {
            this.tabSize = tabSizeAsInteger;
        }
        try {
            document.readLock();
            Element root = document.getDefaultRootElement();
            int count = root.getElementCount();
            Segment segment = new Segment();
            for (int i = 0; i < count; ++i) {
                Element lineElement = root.getElement(i);
                try {
                    document.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset(), segment);
                    lines.add(this.removeNewLines(segment.toString()));
                    continue;
                }
                catch (BadLocationException ble) {
                    Debug.reportError((String)("Exception thrown accessing document text: " + ble));
                }
            }
        }
        finally {
            document.readUnlock();
        }
        return this.printText(printJob, lines, font, format);
    }

    private String removeNewLines(String line) {
        int lastChar;
        int length = line.length();
        int n = lastChar = length > 0 ? (int)line.charAt(line.length() - 1) : 32;
        while (lastChar == 10 || lastChar == 13) {
            length = (line = line.substring(0, line.length() - 1)).length();
            lastChar = length > 0 ? (int)line.charAt(line.length() - 1) : 32;
        }
        return line;
    }

    private synchronized boolean printText(PrinterJob job, List text, Font font, PageFormat format) {
        try {
            this.pages = this.paginateText(text, format, font);
            job.setPageable(this.pages);
            job.print();
            return true;
        }
        catch (Exception e) {
            Debug.reportError((String)("Exception thrown during printing: " + e));
            e.printStackTrace();
            return false;
        }
    }

    private Book paginateText(List text, PageFormat pageFormat, Font font) {
        Book book = new Book();
        int currentLine = 0;
        int height = (int)pageFormat.getImageableHeight() - 50;
        int linesPerPage = height / (font.getSize() + 2);
        this.wrapLines(text, pageFormat, font);
        int numberOfPages = text.size() / linesPerPage + 1;
        ListIterator li = text.listIterator();
        for (int pageNum = 1; pageNum <= numberOfPages; ++pageNum) {
            ArrayList pageText = new ArrayList();
            for (int lineCount = 0; li.hasNext() && lineCount < linesPerPage; ++lineCount) {
                pageText.add(li.next());
                ++currentLine;
            }
            book.append(new MoePage(pageText, font), pageFormat);
        }
        return book;
    }

    private void wrapLines(List text, PageFormat format, Font font) {
        StyleContext context = new StyleContext();
        FontMetrics fontMetrics = context.getFontMetrics(font);
        int maxWidth = (int)format.getImageableWidth() - 10;
        int fontWidth = fontMetrics.charWidth('m');
        int chars = maxWidth / fontWidth;
        ListIterator<String> li = text.listIterator();
        while (li.hasNext()) {
            String currentLine = Utility.convertTabsToSpaces((String)((String)li.next()), (int)this.tabSize);
            li.set(currentLine);
            int currentLineLength = currentLine.length();
            int width = fontMetrics.stringWidth(currentLine);
            if (width <= maxWidth) continue;
            int indexOfLine = li.previousIndex();
            li.remove();
            double iterations = currentLineLength / chars + 1;
            int begin = 0;
            int end = 0;
            while (iterations > 0.0) {
                end = begin + chars < currentLineLength ? begin + chars : currentLineLength;
                String newSubString = currentLine.substring(begin, end);
                if (newSubString.length() != 0) {
                    li.add(newSubString);
                }
                iterations -= 1.0;
                begin += chars;
            }
        }
    }

    class MoePage
    implements Printable {
        private List text;
        private Font font;

        MoePage(List text, Font font) {
            this.text = text;
            this.font = font;
        }

        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            g.setFont(this.font);
            g.setColor(Color.black);
            int xPosition = (int)pageFormat.getImageableX();
            int yPosition = (int)pageFormat.getImageableY();
            int width = (int)pageFormat.getImageableWidth();
            int height = (int)pageFormat.getImageableHeight();
            this.printHeader(g, pageIndex, xPosition, yPosition, width, 30);
            int textYPosition = yPosition + 30;
            int textXPosition = xPosition + 5;
            g.drawRect(xPosition, textYPosition, width, height - 50);
            ListIterator li = this.text.listIterator();
            while (li.hasNext()) {
                int position = textYPosition + (this.font.getSize() + 2) * (li.nextIndex() + 1);
                String line = (String)li.next();
                if (line.length() == 0) {
                    line = " ";
                }
                g.drawString(line, textXPosition, position);
            }
            int footerYPosition = yPosition + height - 20;
            this.printFooter(g, xPosition, footerYPosition, width, 20);
            return 0;
        }

        private void printHeader(Graphics g, int pageIndex, int xPos, int yPos, int width, int height) {
            g.setColor(Color.lightGray);
            g.fillRect(xPos, yPos, width, height);
            g.setColor(Color.black);
            g.drawRect(xPos, yPos, width, height);
            int titleYPos = yPos + 30 - this.font.getSize() + 2;
            Object currentFont = null;
            String title = "Class " + MoePrinter.this.className;
            if (pageIndex == 0) {
                g.setFont(titleFont);
            } else {
                if (!"".equals(CONTINUED_LABEL) && !"editor.printer.continued".equals(CONTINUED_LABEL)) {
                    title = title + " (" + CONTINUED_LABEL + ")";
                }
                g.setFont(smallTitleFont);
            }
            g.drawString(title, xPos + 5, titleYPos);
            g.setFont(smallTitleFont);
            FontMetrics pfm = g.getFontMetrics(smallTitleFont);
            String pageInfo = pageIndex + 1 + "/" + MoePrinter.this.pages.getNumberOfPages();
            int pageInfoX = xPos + width - 5 - pfm.stringWidth(pageInfo);
            g.drawString(pageInfo, pageInfoX, titleYPos);
            g.setFont(this.font);
        }

        private void printFooter(Graphics g, int xPos, int yPos, int width, int height) {
            g.setFont(footerFont);
            FontMetrics pfm = g.getFontMetrics(footerFont);
            int footerTextYPos = yPos + 20 - this.font.getSize() + 2;
            Date today = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            String date = dateFormat.format(today);
            int pageInfoX = xPos + width - 5 - pfm.stringWidth(date);
            g.drawString(date, pageInfoX, footerTextYPos);
            g.setFont(this.font);
        }
    }
}

