/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorWatcher;
import bluej.editor.LineColumn;
import bluej.editor.moe.Finder;
import bluej.editor.moe.GoToLineDialog;
import bluej.editor.moe.Info;
import bluej.editor.moe.MoeActions;
import bluej.editor.moe.MoeCaret;
import bluej.editor.moe.MoeEditorManager;
import bluej.editor.moe.MoeEditorPane;
import bluej.editor.moe.MoePrinter;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.MoeSyntaxEditorKit;
import bluej.editor.moe.MoeUndoManager;
import bluej.editor.moe.StatusLabel;
import bluej.editor.moe.TextUtilities;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;

public final class MoeEditor
extends JFrame
implements Editor,
BlueJEventListener,
HyperlinkListener,
DocumentListener {
    static final int version = 200;
    static final String versionString = "2.0";
    static final Color cursorColor = new Color(255, 0, 100);
    static final Color frameBgColor = new Color(175, 175, 175);
    static final Color infoColor = new Color(240, 240, 240);
    static final Color lightGrey = new Color(224, 224, 224);
    static final Color selectionColour = Config.getSelectionColour();
    static final Color titleCol = Config.getItemColour((String)"colour.text.fg");
    static final Color envOpColour = Config.getItemColour((String)"colour.menu.environOp");
    static final Image iconImage = Config.getImageAsIcon((String)"image.icon.editor").getImage();
    public static int printFontSize = Config.getPropInteger((String)"bluej.fontsize.printText", (int)10);
    public static Font printFont = new Font("Monospaced", 0, printFontSize);
    String implementationString = Config.getString((String)"editor.implementationLabel");
    String interfaceString = Config.getString((String)"editor.interfaceLabel");
    static final String LabelSuffix = "Label";
    static final String ActionSuffix = "Action";
    static final String TooltipSuffix = "Tooltip";
    static final String AcceleratorSuffix = "Accelerator";
    static final String CRASHFILE_SUFFIX = "#";
    static final String BACKUP_SUFFIX = "~";
    static final String spaces = "    ";
    static final String COMPILED = "compiled";
    private static boolean matchBrackets = false;
    private EditorWatcher watcher;
    private Properties resources;
    private AbstractDocument document;
    private MoeSyntaxDocument sourceDocument;
    private HTMLDocument htmlDocument;
    private MoeActions actions;
    public MoeUndoManager undoManager;
    JEditorPane currentTextPane;
    private JEditorPane sourcePane;
    private JEditorPane htmlPane;
    private MoeCaret moeCaret;
    private Info info;
    private JPanel statusArea;
    private StatusLabel saveState;
    private JComboBox interfaceToggle;
    private GoToLineDialog goToLineDialog;
    private JScrollPane scrollPane;
    private JComponent toolbar;
    private String filename;
    private long lastModified;
    private String windowTitle;
    private String docFilename;
    private boolean sourceIsCode;
    private boolean viewingHTML;
    private int currentStepPos;
    private boolean mayHaveBreakpoints;
    private boolean ignoreChanges = false;
    private boolean tabsAreExpanded = false;
    private MoePrinter printer;
    private TextInsertNotifier doTextInsert = new TextInsertNotifier();
    private HashMap<String, Object> propertyMap = new HashMap();

    public MoeEditor(String title, boolean isCode, EditorWatcher watcher, boolean showToolbar, boolean showLineNum, Properties resources) {
        super("Moe");
        this.watcher = watcher;
        this.resources = resources;
        this.filename = null;
        this.windowTitle = title;
        this.sourceIsCode = isCode;
        this.viewingHTML = false;
        this.currentStepPos = -1;
        this.mayHaveBreakpoints = false;
        matchBrackets = PrefMgr.getFlag((String)"bluej.editor.matchBrackets");
        this.undoManager = new MoeUndoManager(this);
        this.initWindow();
    }

    public void updateUndoControls() {
        this.actions.setUndoEnabled(this.undoManager.canUndo());
    }

    public void updateRedoControls() {
        this.actions.setRedoEnabled(this.undoManager.canRedo());
    }

    public boolean showFile(String filename, boolean compiled, String docFilename, Rectangle bounds) {
        this.filename = filename;
        this.docFilename = docFilename;
        if (bounds != null) {
            this.setBounds(bounds);
        }
        boolean loaded = false;
        boolean readError = false;
        if (filename != null) {
            try {
                String crashFilename = filename + CRASHFILE_SUFFIX;
                String backupFilename = crashFilename + "backup";
                File crashFile = new File(crashFilename);
                if (crashFile.exists()) {
                    File backupFile = new File(backupFilename);
                    backupFile.delete();
                    crashFile.renameTo(backupFile);
                    DialogManager.showMessage((Component)this, (String)"editor-crashed");
                }
                FileReader reader = new FileReader(filename);
                this.sourcePane.read(reader, null);
                reader.close();
                File file = new File(filename);
                this.lastModified = file.lastModified();
                this.sourceDocument = (MoeSyntaxDocument)this.sourcePane.getDocument();
                this.checkSyntaxStatus();
                this.sourceDocument.addDocumentListener(this);
                this.sourceDocument.addUndoableEditListener(this.undoManager);
                this.document = this.sourceDocument;
                loaded = true;
            }
            catch (FileNotFoundException ex) {
                this.clear();
            }
            catch (IOException ex) {
                readError = true;
            }
        } else if (docFilename != null && new File(docFilename).exists()) {
            this.showInterface(true);
            loaded = true;
            this.interfaceToggle.setEnabled(false);
        }
        if (!loaded) {
            return false;
        }
        if (loaded) {
            this.info.message(Config.getString((String)"editor.info.version") + " " + versionString);
        } else if (readError) {
            this.info.warning(Config.getString((String)"editor.info.readingProblem"), Config.getString((String)"editor.info.regularFile"));
        } else {
            this.info.message(Config.getString((String)"editor.info.version2.0"), Config.getString((String)"editor.info.newFile"));
        }
        this.setWindowTitle();
        this.sourcePane.setFont(PrefMgr.getStandardEditorFont());
        this.sourcePane.setSelectionColor(selectionColour);
        this.setCompileStatus(compiled);
        return true;
    }

    public void reloadFile() {
        this.doReload();
    }

    public void clear() {
        this.ignoreChanges = true;
        this.sourcePane.setText("");
        this.ignoreChanges = false;
    }

    public void insertText(String text, boolean caretBack) {
        this.sourcePane.replaceSelection(text);
        if (caretBack) {
            this.sourcePane.setCaretPosition(this.sourcePane.getCaretPosition() - text.length());
        }
    }

    public void setVisible(boolean vis) {
        if (vis) {
            this.sourcePane.setFont(PrefMgr.getStandardEditorFont());
            this.checkSyntaxStatus();
            this.checkBracketStatus();
        }
        super.setVisible(vis);
        if (vis) {
            this.setState(0);
            this.toFront();
            Utility.bringToFront((Window)this);
        }
    }

    public void refresh() {
        this.sourcePane.setFont(PrefMgr.getStandardEditorFont());
        this.checkBracketStatus();
        this.checkSyntaxStatus();
        this.currentTextPane.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        IOException failureException = null;
        if (this.saveState.isChanged()) {
            BufferedWriter writer = null;
            try {
                String crashFilename = this.filename + CRASHFILE_SUFFIX;
                String backupFilename = this.filename + BACKUP_SUFFIX;
                FileUtility.copyFile((String)this.filename, (String)crashFilename);
                writer = new BufferedWriter(new FileWriter(this.filename));
                this.sourcePane.write(writer);
                writer.close();
                this.setSaved();
                File file = new File(this.filename);
                this.lastModified = file.lastModified();
                if (PrefMgr.getFlag((String)"bluej.editor.makeBackup")) {
                    File crashFile = new File(crashFilename);
                    File backupFile = new File(backupFilename);
                    backupFile.delete();
                    crashFile.renameTo(backupFile);
                } else {
                    File crashFile = new File(crashFilename);
                    crashFile.delete();
                }
            }
            catch (IOException ex) {
                failureException = ex;
                this.info.warning(Config.getString((String)"editor.info.errorSaving") + " - " + ex.getLocalizedMessage());
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ex) {
                    failureException = ex;
                }
            }
        }
        if (failureException != null) {
            this.info.warning(Config.getString((String)"editor.info.errorSaving") + " - " + failureException.getLocalizedMessage());
            throw failureException;
        }
    }

    public void close() {
        try {
            this.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.doClose();
    }

    public void displayMessage(String message, int lineNumber, int column, boolean beep, boolean setStepMark, String help) {
        this.switchToSourceView();
        Element line = this.getLine(lineNumber);
        int pos = line.getStartOffset();
        if (setStepMark) {
            this.setStepMark(pos);
        }
        this.sourcePane.setCaretPosition(pos);
        this.sourcePane.moveCaretPosition(line.getEndOffset() - 1);
        this.moeCaret.setPersistentHighlight();
        if (beep) {
            this.info.warning(message);
        } else {
            this.info.message(message);
        }
        if (help != null) {
            this.info.setHelp(help);
        }
    }

    public void setSelection(int lineNumber, int columnNumber, int len) {
        Element line = this.getLine(lineNumber);
        this.sourcePane.select(line.getStartOffset() + columnNumber - 1, line.getStartOffset() + columnNumber + len - 1);
    }

    public void setSelection(int lineNumber1, int columnNumber1, int lineNumber2, int columnNumber2) {
        Element line1 = this.getLine(lineNumber1);
        Element line2 = this.getLine(lineNumber2);
        this.sourcePane.select(line1.getStartOffset() + columnNumber1 - 1, line2.getStartOffset() + columnNumber2 - 1);
    }

    public String getSelectedText() {
        return this.sourcePane.getSelectedText();
    }

    public void removeStepMark() {
        if (this.currentStepPos != -1) {
            SimpleAttributeSet a = new SimpleAttributeSet();
            a.addAttribute("step", Boolean.FALSE);
            this.sourceDocument.setParagraphAttributes(this.currentStepPos, a);
            this.currentStepPos = -1;
            this.sourcePane.setCaretPosition(this.sourcePane.getCaretPosition());
            this.repaint();
        }
    }

    public void changeName(String title, String filename, String docFilename) {
        this.filename = filename;
        this.docFilename = docFilename;
        this.windowTitle = title;
        this.setWindowTitle();
    }

    public void setCompiled(boolean compiled) {
        this.setCompileStatus(compiled);
        if (compiled) {
            this.info.message(Config.getString((String)"editor.info.compiled"));
        }
    }

    public void removeBreakpoints() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MoeEditor.this.clearAllBreakpoints();
            }
        });
    }

    public void reInitBreakpoints() {
        if (this.mayHaveBreakpoints) {
            this.mayHaveBreakpoints = false;
            for (int i = 1; i <= this.numberOfLines(); ++i) {
                if (!this.lineHasBreakpoint(i)) continue;
                this.watcher.breakpointToggleEvent(this, i, true);
                this.mayHaveBreakpoints = true;
            }
        }
    }

    public boolean isModified() {
        return this.saveState.isChanged();
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.saveState.setState(0);
            this.updateUndoControls();
            this.updateRedoControls();
        }
        this.sourcePane.setEditable(!readOnly);
    }

    public boolean isReadOnly() {
        return !this.sourcePane.isEditable();
    }

    public void showInterface(boolean interfaceStatus) {
        this.interfaceToggle.setSelectedIndex(interfaceStatus ? 1 : 0);
    }

    public boolean isShowingInterface() {
        return this.viewingHTML;
    }

    private void checkForChangeOnDisk() {
        if (this.filename == null) {
            return;
        }
        File file = new File(this.filename);
        long modified = file.lastModified();
        if (modified != this.lastModified) {
            if (this.saveState.isChanged()) {
                int answer = DialogManager.askQuestion((Component)this, (String)"changed-on-disk");
                if (answer == 0) {
                    this.doReload();
                } else {
                    this.lastModified = modified;
                }
            } else {
                this.doReload();
            }
        }
    }

    public LineColumn getCaretLocation() {
        int caretOffset = this.sourcePane.getCaretPosition();
        return this.getLineColumnFromOffset(caretOffset);
    }

    public LineColumn getLineColumnFromOffset(int offset) {
        int lineNumber = this.sourceDocument.getDefaultRootElement().getElementIndex(offset);
        if (lineNumber < 0) {
            return null;
        }
        Element lineElement = this.getLineAt(offset);
        int column = offset - lineElement.getStartOffset();
        if (column < 0) {
            return null;
        }
        return new LineColumn(lineNumber, column);
    }

    public void setCaretLocation(LineColumn location) {
        this.sourcePane.setCaretPosition(this.getOffsetFromLineColumn(location));
    }

    public LineColumn getSelectionBegin() {
        Caret aCaret = this.sourcePane.getCaret();
        if (aCaret.getDot() == aCaret.getMark()) {
            return null;
        }
        int beginOffset = Math.min(aCaret.getDot(), aCaret.getMark());
        return this.getLineColumnFromOffset(beginOffset);
    }

    public LineColumn getSelectionEnd() {
        Caret aCaret = this.sourcePane.getCaret();
        if (aCaret.getDot() == aCaret.getMark()) {
            return null;
        }
        int endOffset = Math.max(aCaret.getDot(), aCaret.getMark());
        return this.getLineColumnFromOffset(endOffset);
    }

    public String getText(LineColumn begin, LineColumn end) {
        int first = this.getOffsetFromLineColumn(begin);
        int last = this.getOffsetFromLineColumn(end);
        int beginOffset = Math.min(first, last);
        int endOffset = Math.max(first, last);
        try {
            return this.sourceDocument.getText(beginOffset, endOffset - beginOffset);
        }
        catch (BadLocationException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
    }

    public void setText(LineColumn begin, LineColumn end, String newText) throws BadLocationException {
        int endOffset;
        int finish;
        int start = this.getOffsetFromLineColumn(begin);
        int beginOffset = Math.min(start, finish = this.getOffsetFromLineColumn(end));
        if (beginOffset != (endOffset = Math.max(start, finish))) {
            this.sourceDocument.remove(beginOffset, endOffset - beginOffset);
        }
        this.sourceDocument.insertString(beginOffset, newText, null);
    }

    public void setSelection(LineColumn begin, LineColumn end) {
        int start = this.getOffsetFromLineColumn(begin);
        int finish = this.getOffsetFromLineColumn(end);
        int selectionStart = Math.min(start, finish);
        int selectionEnd = Math.max(start, finish);
        this.sourcePane.setCaretPosition(selectionStart);
        this.sourcePane.moveCaretPosition(selectionEnd);
    }

    public int getOffsetFromLineColumn(LineColumn location) {
        if (location.getLine() < 0) {
            throw new IllegalArgumentException("line < 0");
        }
        Element lineElement = this.sourceDocument.getDefaultRootElement().getElement(location.getLine());
        if (lineElement == null) {
            throw new IllegalArgumentException("line=" + location.getLine() + " is out of bound");
        }
        int lineOffset = lineElement.getStartOffset();
        if (location.getColumn() < 0) {
            throw new IllegalArgumentException("column < 0 ");
        }
        int lineLen = lineElement.getEndOffset() - lineOffset;
        if (location.getColumn() >= lineLen) {
            throw new IllegalArgumentException("column=" + location.getColumn() + " greater than line len=" + lineLen);
        }
        return lineOffset + location.getColumn();
    }

    public Object getProperty(String propertyKey) {
        return this.propertyMap.get(propertyKey);
    }

    public void setProperty(String propertyKey, Object value) {
        if (propertyKey == null) {
            return;
        }
        this.propertyMap.put(propertyKey, value);
    }

    public int getLineLength(int line) {
        if (line < 0) {
            return -1;
        }
        Element lineElement = this.sourceDocument.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        int startOffset = lineElement.getStartOffset();
        return lineElement.getEndOffset() - startOffset;
    }

    public int getTextLength() {
        return this.sourceDocument.getLength();
    }

    public int numberOfLines() {
        return this.sourceDocument.getDefaultRootElement().getElementCount();
    }

    public void blueJEvent(int eventId, Object arg) {
        switch (eventId) {
            case 7: {
                BlueJEvent.removeListener((BlueJEventListener)this);
                this.refreshHtmlDisplay();
                break;
            }
            case 8: {
                BlueJEvent.removeListener((BlueJEventListener)this);
                this.info.warning(Config.getString((String)"editor.info.docAborted"));
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.saveState.isChanged()) {
            this.saveState.setState(2);
            this.setChanged();
        }
        this.actions.userAction();
        this.doTextInsert.setEvent(e, this.sourcePane);
        SwingUtilities.invokeLater(this.doTextInsert);
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.saveState.isChanged()) {
            this.saveState.setState(2);
            this.setChanged();
        }
        this.actions.userAction();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void clearMessage() {
        this.info.clear();
    }

    public void writeMessage(String msg) {
        this.info.message(msg);
    }

    public void writeWarningMessage(String msg) {
        this.info.warning(msg);
    }

    public void userSave() {
        if (this.saveState.isSaved()) {
            this.info.message(Config.getString((String)"editor.info.noChanges"));
        } else {
            try {
                this.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void reload() {
        if (this.filename == null) {
            this.info.warning(Config.getString((String)"editor.info.cannotReload"), Config.getString((String)"editor.info.reload"));
        } else if (this.saveState.isChanged()) {
            int answer = DialogManager.askQuestion((Component)this, (String)"really-reload");
            if (answer == 0) {
                this.doReload();
            }
        } else {
            this.doReload();
        }
    }

    public void print(PrinterJob printerJob) {
        PrintHandler pt = new PrintHandler(printerJob, this.getPageFormat(printerJob));
        pt.print();
    }

    public PageFormat getPageFormat(PrinterJob job) {
        return job.validatePage(PkgMgrFrame.getPageFormat());
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (job.printDialog()) {
            PrintHandler pt = new PrintHandler(job, this.getPageFormat(job));
            Thread printJobThread = new Thread(pt);
            printJobThread.setPriority(Thread.currentThread().getPriority() - 1);
            printJobThread.start();
        }
    }

    public void pageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pageFormat = job.pageDialog(PkgMgrFrame.getPageFormat());
        PkgMgrFrame.setPageFormat((PageFormat)pageFormat);
    }

    public void doClose() {
        this.setVisible(false);
        if (this.watcher != null) {
            this.watcher.closeEvent(this);
        }
    }

    public boolean checkExpandTabs() {
        if (this.tabsAreExpanded) {
            return false;
        }
        this.tabsAreExpanded = true;
        return true;
    }

    public void find() {
        Finder finder = MoeEditorManager.editorManager.getFinder();
        finder.show(this, this.currentTextPane.getSelectedText(), false);
    }

    public void replace() {
        Finder finder = MoeEditorManager.editorManager.getFinder();
        finder.show(this, this.currentTextPane.getSelectedText(), true);
    }

    public void findNext() {
        Finder finder = MoeEditorManager.editorManager.getFinder();
        String s = this.currentTextPane.getSelectedText();
        if (s == null && (s = finder.getSearchString()) == null) {
            this.info.warning(DialogManager.getMessage((String)"no-search-string"));
            return;
        }
        this.findNextString(finder, s, false);
    }

    public void findNextBackward() {
        Finder finder = MoeEditorManager.editorManager.getFinder();
        String s = this.currentTextPane.getSelectedText();
        if (s == null && (s = finder.getSearchString()) == null) {
            this.info.warning(DialogManager.getMessage((String)"no-search-string"));
            return;
        }
        this.findNextString(finder, s, true);
    }

    public void findFirstConflict() {
        this.setCaretLocation(new LineColumn(0, 0));
        this.findNextConflict();
    }

    private void findNextConflict() {
        this.findString("=======", false, false, true, false);
        this.findString("<<<<<<<", true, false, false, false);
        LineColumn startPos = this.getCaretLocation();
        this.findString(">>>>>>>", false, false, false, false);
        LineColumn endPos = this.getCaretLocation();
        this.setSelection(startPos, endPos);
    }

    private void findNextString(Finder finder, String s, boolean backward) {
        boolean found = this.findString(s, backward, finder.getIgnoreCase(), finder.getWholeWord(), !finder.getSearchFound());
        finder.setSearchString(s);
        finder.setSearchFound(found);
    }

    boolean findString(String s, boolean backward, boolean ignoreCase, boolean wholeWord, boolean wrap) {
        if (s.length() == 0) {
            this.info.warning(Config.getString((String)"editor.info.emptySearchString"));
            return false;
        }
        boolean found = backward ? this.doFindBackward(s, ignoreCase, wholeWord, wrap) : this.doFind(s, ignoreCase, wholeWord, wrap);
        StringBuffer msg = new StringBuffer(Config.getString((String)"editor.find.find.label") + " ");
        msg.append(backward ? Config.getString((String)"editor.find.backward") : Config.getString((String)"editor.find.forward"));
        if (ignoreCase || wholeWord || wrap) {
            msg.append(" (");
        }
        if (ignoreCase) {
            msg.append(Config.getString((String)"editor.find.ignoreCase").toLowerCase() + ", ");
        }
        if (wholeWord) {
            msg.append(Config.getString((String)"editor.find.wholeWord").toLowerCase() + ", ");
        }
        if (wrap) {
            msg.append(Config.getString((String)"editor.find.wrapAround").toLowerCase() + ", ");
        }
        if (ignoreCase || wholeWord || wrap) {
            msg.replace(msg.length() - 2, msg.length(), "): ");
        } else {
            msg.append(": ");
        }
        msg.append(s);
        if (found) {
            this.info.message(msg.toString());
        } else {
            this.info.warning(msg.toString(), Config.getString((String)"editor.info.notFound"));
        }
        return found;
    }

    boolean doFind(String s, boolean ignoreCase, boolean wholeWord, boolean wrap) {
        int docLength = this.document.getLength();
        int startPosition = this.currentTextPane.getCaretPosition();
        int endPos = docLength;
        boolean found = false;
        boolean finished = false;
        int start = startPosition;
        Element line = this.getLineAt(start);
        int lineEnd = Math.min(line.getEndOffset(), endPos);
        try {
            while (!found && !finished) {
                int foundPos;
                String lineText = this.document.getText(start, lineEnd - start);
                if (lineText != null && lineText.length() > 0 && (foundPos = this.findSubstring(lineText, s, ignoreCase, wholeWord, false)) != -1) {
                    this.currentTextPane.select(start + foundPos, start + foundPos + s.length());
                    found = true;
                }
                if (lineEnd >= endPos) {
                    if (wrap) {
                        endPos = startPosition;
                        line = this.document.getParagraphElement(0);
                        start = line.getStartOffset();
                        lineEnd = Math.min(line.getEndOffset(), endPos);
                        wrap = false;
                        continue;
                    }
                    finished = true;
                    continue;
                }
                line = this.document.getParagraphElement(lineEnd + 1);
                start = line.getStartOffset();
                lineEnd = Math.min(line.getEndOffset(), endPos);
            }
        }
        catch (BadLocationException ex) {
            Debug.message((String)"error in editor find operation");
        }
        return found;
    }

    boolean doFindBackward(String s, boolean ignoreCase, boolean wholeWord, boolean wrap) {
        int docLength = this.document.getLength();
        int startPosition = this.currentTextPane.getCaretPosition() - 1;
        if (startPosition < 0) {
            startPosition = docLength;
        }
        int endPos = 0;
        boolean found = false;
        boolean finished = false;
        int start = startPosition;
        Element line = this.getLineAt(start);
        int lineStart = Math.max(line.getStartOffset(), endPos);
        try {
            while (!found && !finished) {
                int foundPos;
                String lineText = this.document.getText(lineStart, start - lineStart);
                if (lineText != null && lineText.length() > 0 && (foundPos = this.findSubstring(lineText, s, ignoreCase, wholeWord, true)) != -1) {
                    this.currentTextPane.select(lineStart + foundPos, lineStart + foundPos + s.length());
                    found = true;
                }
                if (lineStart <= endPos) {
                    if (wrap) {
                        endPos = startPosition;
                        line = this.document.getParagraphElement(docLength);
                        start = line.getEndOffset();
                        lineStart = Math.max(line.getStartOffset(), endPos);
                        wrap = false;
                        continue;
                    }
                    finished = true;
                    continue;
                }
                line = this.document.getParagraphElement(lineStart - 1);
                start = line.getEndOffset();
                lineStart = Math.max(line.getStartOffset(), endPos);
            }
        }
        catch (BadLocationException ex) {
            Debug.reportError((String)"error in editor find operation");
            ex.printStackTrace();
        }
        return found;
    }

    public void goToLine() {
        if (this.goToLineDialog == null) {
            this.goToLineDialog = new GoToLineDialog(this);
        }
        DialogManager.centreDialog((JDialog)((Object)this.goToLineDialog));
        this.goToLineDialog.showDialog(this.numberOfLines());
        int newPosition = this.goToLineDialog.getLineNumber();
        if (newPosition > 0) {
            this.setSelection(newPosition, 1, 0);
        }
    }

    private int findSubstring(String text, String sub, boolean ignoreCase, boolean wholeWord, boolean backwards) {
        boolean itsOver;
        int pos;
        int strlen = text.length();
        int sublen = sub.length();
        if (sublen == 0) {
            return -1;
        }
        if (!Character.isJavaIdentifierPart(sub.charAt(0)) || !Character.isJavaIdentifierPart(sub.charAt(sublen - 1))) {
            wholeWord = false;
        }
        boolean found = false;
        int n = pos = backwards ? strlen - sublen : 0;
        boolean bl = backwards ? pos < 0 : (itsOver = pos + sublen > strlen);
        while (!found && !itsOver) {
            found = text.regionMatches(ignoreCase, pos, sub, 0, sublen);
            if (found && wholeWord) {
                boolean bl2 = found = !(pos != 0 && Character.isJavaIdentifierPart(text.charAt(pos - 1)) || pos + sublen < strlen && Character.isJavaIdentifierPart(text.charAt(pos + sublen)));
            }
            if (found) continue;
            int n2 = pos = backwards ? pos - 1 : pos + 1;
            itsOver = backwards ? pos < 0 : pos + sublen > strlen;
        }
        if (found) {
            return pos;
        }
        return -1;
    }

    public void compile() {
        if (this.watcher == null) {
            return;
        }
        if (!this.viewingCode()) {
            this.info.warning(" ");
            return;
        }
        this.info.message(Config.getString((String)"editor.info.compiling"));
        this.watcher.compile(this);
    }

    public void toggleInterfaceMenu() {
        if (!this.sourceIsCode) {
            return;
        }
        if (this.interfaceToggle.getSelectedIndex() == 0) {
            this.interfaceToggle.setSelectedIndex(1);
        } else {
            this.interfaceToggle.setSelectedIndex(0);
        }
    }

    public void toggleInterface() {
        boolean wantHTML;
        if (!this.sourceIsCode) {
            return;
        }
        boolean bl = wantHTML = this.interfaceToggle.getSelectedItem() == this.interfaceString;
        if (wantHTML && !this.viewingHTML) {
            this.switchToInterfaceView();
        } else if (!wantHTML && this.viewingHTML) {
            this.switchToSourceView();
        }
    }

    public void enablePrinting(boolean flag) {
        Action pageSetupAction;
        Action printAction = this.actions.getActionByName("print");
        if (printAction != null) {
            printAction.setEnabled(flag);
        }
        if ((pageSetupAction = this.actions.getActionByName("page-setup")) != null) {
            pageSetupAction.setEnabled(flag);
        }
    }

    private void switchToSourceView() {
        if (!this.viewingHTML) {
            return;
        }
        this.enablePrinting(true);
        this.document = this.sourceDocument;
        this.currentTextPane = this.sourcePane;
        this.viewingHTML = false;
        this.scrollPane.setViewportView(this.currentTextPane);
        this.checkSyntaxStatus();
        this.currentTextPane.requestFocus();
    }

    private void switchToInterfaceView() {
        if (this.viewingHTML) {
            return;
        }
        this.enablePrinting(false);
        try {
            this.save();
            this.displayInterface();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void refreshHtmlDisplay() {
        try {
            File urlFile = new File(this.getDocPath());
            URL myURL = urlFile.toURI().toURL();
            this.htmlPane.setPage(myURL);
            this.htmlDocument = (HTMLDocument)this.htmlPane.getDocument();
            this.htmlDocument.setBase(myURL);
            this.info.message(Config.getString((String)"editor.info.docLoaded"));
        }
        catch (Exception exc) {
            this.info.warning(Config.getString((String)"editor.info.docDisappeared"), this.getDocPath());
            Debug.reportError((String)("loading class interface failed: " + exc));
        }
    }

    private boolean docUpToDate() {
        if (this.filename == null) {
            return true;
        }
        try {
            File src = new File(this.filename);
            File doc = new File(this.docFilename);
            if (!doc.exists() || src.exists() && src.lastModified() > doc.lastModified()) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void displayInterface() {
        boolean generateDoc;
        this.info.message(Config.getString((String)"editor.info.loadingDoc"));
        boolean bl = generateDoc = !this.docUpToDate();
        if (this.htmlPane == null) {
            this.createHTMLPane();
            if (!generateDoc) {
                this.refreshHtmlDisplay();
            }
        } else if (!generateDoc) {
            this.info.message(Config.getString((String)"editor.info.docLoaded"));
        }
        if (generateDoc) {
            this.htmlDocument = new HTMLDocument();
            this.htmlPane.setDocument(this.htmlDocument);
            this.info.message(Config.getString((String)"editor.info.generatingDoc"));
            BlueJEvent.addListener((BlueJEventListener)this);
            this.watcher.generateDoc();
        }
        this.document = this.htmlDocument;
        this.currentTextPane = this.htmlPane;
        this.viewingHTML = true;
        this.scrollPane.setViewportView(this.htmlPane);
        this.currentTextPane.requestFocus();
    }

    public void createHTMLPane() {
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditorKit(new HTMLEditorKit());
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
        this.htmlPane.setInputMap(0, new InputMap(){

            public Object get(KeyStroke keyStroke) {
                Object action = super.get(keyStroke);
                if ("caret-up".equals(action) || "caret-down".equals(action)) {
                    return null;
                }
                return action;
            }
        });
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        this.info.clear();
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    pane.setPage(e.getURL());
                }
                catch (Throwable t) {
                    this.info.warning("cannot display hyperlink: " + e.getURL());
                    Debug.reportError((String)("hyperlink failed: " + t));
                }
            }
        }
    }

    public void toggleBreakpoint() {
        if (!this.viewingCode()) {
            this.info.warning(" ");
            return;
        }
        this.toggleBreakpoint(this.sourcePane.getCaretPosition());
    }

    public void toggleBreakpoint(int pos) {
        if (this.positionHasBreakpoint(pos)) {
            this.setUnsetBreakpoint(pos, false);
        } else {
            this.setUnsetBreakpoint(pos, true);
        }
    }

    private void clearAllBreakpoints() {
        if (this.mayHaveBreakpoints) {
            for (int i = 1; i <= this.numberOfLines(); ++i) {
                if (!this.lineHasBreakpoint(i)) continue;
                this.doRemoveBreakpoint(this.getPositionInLine(i));
            }
            this.mayHaveBreakpoints = false;
        }
    }

    private boolean positionHasBreakpoint(int pos) {
        Element line = this.getLineAt(pos);
        return Boolean.TRUE.equals(line.getAttributes().getAttribute("break"));
    }

    private boolean lineHasBreakpoint(int lineNo) {
        Element line = this.getLine(lineNo);
        return Boolean.TRUE.equals(line.getAttributes().getAttribute("break"));
    }

    private void setUnsetBreakpoint(int pos, boolean set) {
        if (this.watcher != null) {
            int line = this.getLineNumberAt(pos);
            String result = this.watcher.breakpointToggleEvent(this, line, set);
            if (result == null) {
                SimpleAttributeSet a = new SimpleAttributeSet();
                if (set) {
                    a.addAttribute("break", Boolean.TRUE);
                    this.mayHaveBreakpoints = true;
                } else {
                    a.addAttribute("break", Boolean.FALSE);
                }
                this.sourceDocument.setParagraphAttributes(pos, a);
            } else {
                this.info.warning(result);
            }
            this.repaint();
        } else {
            this.info.warning(Config.getString((String)"editor.info.cannotSetBreak"));
        }
    }

    private void doRemoveBreakpoint(int pos) {
        SimpleAttributeSet a = new SimpleAttributeSet();
        a.addAttribute("break", Boolean.FALSE);
        this.sourceDocument.setParagraphAttributes(pos, a);
        this.repaint();
    }

    private void setStepMark(int pos) {
        this.removeStepMark();
        SimpleAttributeSet a = new SimpleAttributeSet();
        a.addAttribute("step", Boolean.TRUE);
        this.sourceDocument.setParagraphAttributes(pos, a);
        this.currentStepPos = pos;
        this.repaint();
    }

    private boolean viewingCode() {
        return this.sourceIsCode && !this.viewingHTML;
    }

    private Element getLine(int lineNo) {
        return this.sourceDocument.getDefaultRootElement().getElement(lineNo - 1);
    }

    private Element getLineAt(int pos) {
        return this.sourceDocument.getParagraphElement(pos);
    }

    private int getPositionInLine(int lineNo) {
        return this.getLine(lineNo).getStartOffset();
    }

    private int getLineNumberAt(int pos) {
        return this.sourceDocument.getDefaultRootElement().getElementIndex(pos) + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReload() {
        FileReader reader = null;
        try {
            reader = new FileReader(this.filename);
            this.sourcePane.read(reader, null);
            reader.close();
            File file = new File(this.filename);
            this.lastModified = file.lastModified();
            this.sourceDocument = (MoeSyntaxDocument)this.sourcePane.getDocument();
            this.checkSyntaxStatus();
            this.sourceDocument.addDocumentListener(this);
            this.sourceDocument.addUndoableEditListener(this.undoManager);
            this.saveState.setState(1);
            this.setChanged();
            this.setSaved();
        }
        catch (FileNotFoundException ex) {
            this.info.warning(Config.getString((String)"editor.info.fileDisappeared"));
        }
        catch (IOException ex) {
            this.info.warning(Config.getString((String)"editor.info.fileReadError"));
            this.setChanged();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private void checkSyntaxStatus() {
        if (this.sourceDocument != null) {
            if (this.viewingCode() && PrefMgr.getFlag((String)"bluej.editor.syntaxHilighting")) {
                if (this.sourceDocument.getTokenMarker() == null) {
                    this.sourceDocument.setTokenMarker(new JavaTokenMarker());
                }
            } else {
                this.sourceDocument.setTokenMarker(null);
            }
        }
    }

    private void checkBracketStatus() {
        matchBrackets = PrefMgr.getFlag((String)"bluej.editor.matchBrackets");
        if (matchBrackets) {
            this.doBracketMatch();
        } else {
            this.moeCaret.removeBracket();
        }
    }

    public boolean matchBrackets() {
        return matchBrackets;
    }

    private void setCompileStatus(boolean compiled) {
        this.actions.getActionByName("toggle-breakpoint").setEnabled(compiled && this.viewingCode());
        if (compiled) {
            this.sourceDocument.putProperty(COMPILED, Boolean.TRUE);
        } else {
            this.sourceDocument.putProperty(COMPILED, Boolean.FALSE);
        }
        this.currentTextPane.repaint();
    }

    private void setSaved() {
        this.info.message(Config.getString((String)"editor.info.saved"));
        this.saveState.setState(1);
        if (this.watcher != null) {
            this.watcher.saveEvent(this);
        }
    }

    private void setChanged() {
        if (this.ignoreChanges) {
            return;
        }
        this.setCompileStatus(false);
        if (this.watcher != null) {
            this.watcher.modificationEvent(this);
        }
    }

    void caretMoved() {
        this.clearMessage();
        if (matchBrackets) {
            this.doBracketMatch();
        }
        this.actions.userAction();
    }

    public int getBracketMatch() {
        int pos = -1;
        try {
            int caretPos = this.sourcePane.getCaretPosition();
            if (caretPos != 0) {
                --caretPos;
            }
            pos = TextUtilities.findMatchingBracket(this.sourceDocument, caretPos);
        }
        catch (BadLocationException ble) {
            Debug.reportError((String)"Bad document location reached while trying to match brackets");
        }
        return pos;
    }

    private void doBracketMatch() {
        Caret caret = this.sourcePane.getCaret();
        if (caret instanceof MoeCaret) {
            ((MoeCaret)caret).paintMatchingBracket();
        }
    }

    private void setWindowTitle() {
        String title = this.windowTitle;
        if (title == null) {
            title = this.filename == null ? "Moe:  <no name>" : "Moe:  " + this.filename;
        }
        this.setTitle(title);
    }

    private String getDocPath() {
        return this.docFilename;
    }

    private String getResource(String name) {
        return Config.getPropString((String)name, null, (Properties)this.resources);
    }

    private void initWindow() {
        this.setIconImage(iconImage);
        JPanel contentPane = new JPanel(new BorderLayout(6, 6));
        contentPane.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setContentPane(contentPane);
        JPanel bottomArea = new JPanel();
        bottomArea.setLayout(new BorderLayout(6, 1));
        this.info = new Info();
        bottomArea.add((Component)this.info, "Center");
        this.statusArea = new JPanel();
        this.statusArea.setLayout(new GridLayout(0, 1));
        this.statusArea.setBackground(infoColor);
        this.statusArea.setBorder(BorderFactory.createLineBorder(Color.black));
        this.saveState = new StatusLabel(1);
        this.statusArea.add(this.saveState);
        bottomArea.add((Component)this.statusArea, "East");
        contentPane.add((Component)bottomArea, "South");
        this.sourceDocument = new MoeSyntaxDocument();
        this.sourceDocument.addDocumentListener(this);
        this.sourceDocument.addUndoableEditListener(this.undoManager);
        MoeSyntaxEditorKit kit = new MoeSyntaxEditorKit(false);
        this.sourcePane = new MoeEditorPane();
        this.sourcePane.setDocument(this.sourceDocument);
        this.sourcePane.setCaretPosition(0);
        this.sourcePane.setMargin(new Insets(2, 2, 2, 2));
        this.sourcePane.setOpaque(true);
        this.sourcePane.setEditorKit(kit);
        this.moeCaret = new MoeCaret(this);
        this.sourcePane.setCaret(this.moeCaret);
        this.sourcePane.setBackground(MoeSyntaxDocument.getBackgroundColor());
        this.sourcePane.setCaretColor(cursorColor);
        this.currentTextPane = this.sourcePane;
        this.scrollPane = new JScrollPane(this.currentTextPane);
        this.scrollPane.setPreferredSize(new Dimension(598, 400));
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        contentPane.add((Component)this.scrollPane, "Center");
        this.actions = MoeActions.getActions(this.sourcePane);
        this.actions.setUndoEnabled(false);
        this.actions.setRedoEnabled(false);
        this.actions.getActionByName("show-manual").setEnabled(false);
        JMenuBar menubar = this.createMenuBar();
        this.setJMenuBar(menubar);
        this.toolbar = this.createToolbar();
        contentPane.add((Component)this.toolbar, "North");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MoeEditor.this.close();
            }

            public void windowActivated(WindowEvent e) {
                MoeEditor.this.checkForChangeOnDisk();
            }
        });
        this.setFocusTraversalPolicy(new MoeFocusTraversalPolicy());
        this.setWindowTitle();
        this.pack();
    }

    private JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = null;
        String[] menuKeys = this.getResource("menubar").split(" ");
        for (int i = 0; i < menuKeys.length; ++i) {
            menu = this.createMenu(menuKeys[i]);
            if (menu == null) continue;
            menubar.add(menu);
        }
        return menubar;
    }

    private JMenu createMenu(String key) {
        JMenu menu = new JMenu(Config.getString((String)("editor." + key + LabelSuffix)));
        String itemString = this.getResource(key);
        if (itemString == null) {
            Debug.message((String)("Moe: cannot find menu definition for " + key));
            return null;
        }
        String[] itemKeys = itemString.split(" ");
        for (int i = 0; i < itemKeys.length; ++i) {
            KeyStroke[] keys;
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action action = this.actions.getActionByName(itemKeys[i]);
            if (action == null) {
                Debug.message((String)("Moe: cannot find action " + itemKeys[i]));
                continue;
            }
            JMenuItem item = menu.add(action);
            String label = Config.getString((String)("editor." + itemKeys[i] + LabelSuffix));
            if (label != null) {
                item.setText(label);
            }
            if ((keys = this.actions.getKeyStrokesForAction(action)) == null) continue;
            item.setAccelerator(this.chooseKey(keys));
        }
        return menu;
    }

    private KeyStroke chooseKey(KeyStroke[] keys) {
        if (keys.length == 1) {
            return keys[0];
        }
        KeyStroke key = keys[0];
        for (int i = 1; i < keys.length; ++i) {
            if (keys[i].getKeyCode() < 65 || keys[i].getKeyCode() > 90) continue;
            key = keys[i];
        }
        return key;
    }

    private JComponent createToolbar() {
        String[] toolGroups;
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new BoxLayout(toolbar, 0));
        for (String group : toolGroups = this.getResource("toolbar").split(" ")) {
            this.addToolbarGroup(toolbar, group);
        }
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.createInterfaceSelector());
        return toolbar;
    }

    private void addToolbarGroup(JComponent toolbar, String group) {
        String[] toolKeys = group.split(":");
        for (int i = 0; i < toolKeys.length; ++i) {
            toolbar.add(this.createToolbarButton(toolKeys[i]));
            if (Config.isMacOSLeopard()) continue;
            toolbar.add(Box.createHorizontalStrut(3));
        }
    }

    private AbstractButton createToolbarButton(String key) {
        String label = Config.getString((String)("editor." + key + LabelSuffix));
        String actionName = this.getResource(key + ActionSuffix);
        if (actionName == null) {
            actionName = key;
        }
        Action action = this.actions.getActionByName(actionName);
        ToolbarAction tbAction = new ToolbarAction(action, label);
        JButton button = new JButton(tbAction);
        if (action == null) {
            button.setEnabled(false);
            Debug.message((String)("Moe: action not found for button " + label));
        }
        button.setRequestFocusEnabled(false);
        if (!Config.isMacOS()) {
            Insets margin = button.getMargin();
            button.setMargin(new Insets(margin.top, 3, margin.bottom, 3));
        } else {
            Utility.changeToMacButton((AbstractButton)button);
        }
        button.setFont(PrefMgr.getStandardFont());
        return button;
    }

    private JComboBox createInterfaceSelector() {
        String[] choiceStrings = new String[]{this.implementationString, this.interfaceString};
        this.interfaceToggle = new JComboBox<String>(choiceStrings);
        this.interfaceToggle.setRequestFocusEnabled(false);
        this.interfaceToggle.setFont(PrefMgr.getStandardFont());
        this.interfaceToggle.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.interfaceToggle.setForeground(envOpColour);
        String actionName = "toggle-interface-view";
        Action action = this.actions.getActionByName(actionName);
        if (action != null) {
            this.interfaceToggle.setAction(action);
        } else {
            this.interfaceToggle.setEnabled(false);
            Debug.message((String)("Moe: action not found: " + actionName));
        }
        if (!this.sourceIsCode) {
            this.interfaceToggle.setEnabled(false);
        }
        return this.interfaceToggle;
    }

    class ToolbarAction
    extends AbstractAction
    implements PropertyChangeListener {
        private Action subAction;

        public ToolbarAction(Action subAction, String label) {
            super(label);
            this.subAction = subAction;
            subAction.addPropertyChangeListener(this);
            this.setEnabled(subAction.isEnabled());
        }

        public void actionPerformed(ActionEvent e) {
            this.subAction.actionPerformed(e);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object newVal;
            if (evt.getPropertyName().equals("enabled") && (newVal = evt.getNewValue()) instanceof Boolean) {
                boolean state = (Boolean)newVal;
                this.setEnabled(state);
            }
        }
    }

    class MoeFocusTraversalPolicy
    extends FocusTraversalPolicy {
        MoeFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            return MoeEditor.this.currentTextPane;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            return MoeEditor.this.currentTextPane;
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return MoeEditor.this.currentTextPane;
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return MoeEditor.this.currentTextPane;
        }

        public Component getInitialComponent(Window window) {
            return MoeEditor.this.currentTextPane;
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return MoeEditor.this.currentTextPane;
        }
    }

    class TextInsertNotifier
    implements Runnable {
        private DocumentEvent evt;
        private JEditorPane editorPane;

        TextInsertNotifier() {
        }

        public void setEvent(DocumentEvent e, JEditorPane editorPane) {
            this.evt = e;
            this.editorPane = editorPane;
        }

        public void run() {
            MoeEditor.this.actions.textInsertAction(this.evt, this.editorPane);
        }
    }

    class PrintHandler
    implements Runnable {
        PrinterJob printJob;
        PageFormat pageFormat;

        public PrintHandler(PrinterJob pj, PageFormat format) {
            this.printJob = pj;
            this.pageFormat = format;
        }

        public void run() {
            this.print();
        }

        public void print() {
            if (MoeEditor.this.printer == null) {
                MoeEditor.this.printer = new MoePrinter();
            }
            MoeEditor.this.info.message(Config.getString((String)"editor.info.printing"));
            if (MoeEditor.this.printer.printDocument(this.printJob, MoeEditor.this.sourceDocument, MoeEditor.this.windowTitle, printFont, this.pageFormat)) {
                MoeEditor.this.info.message(Config.getString((String)"editor.info.printed"));
            } else {
                MoeEditor.this.info.message(Config.getString((String)"editor.info.cancelled"));
            }
        }
    }
}

