/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.BracketMatchPainter;
import bluej.editor.moe.MoeEditor;
import bluej.utility.Debug;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;

public class MoeCaret
extends DefaultCaret {
    private static final Color bracketHighlightColour = new Color(196, 196, 196);
    private static final LayeredHighlighter.LayerPainter bracketPainter = new BracketMatchPainter(bracketHighlightColour);
    private MoeEditor editor;
    private boolean persistentHighlight = false;
    private Object matchingBracketHighlight;

    public MoeCaret(MoeEditor editor) {
        this.editor = editor;
        this.setBlinkRate(0);
    }

    protected void positionCaret(MouseEvent e) {
        this.editor.caretMoved();
        Point pt = new Point(e.getX(), e.getY());
        Position.Bias[] biasRet = new Position.Bias[1];
        int pos = this.getComponent().getUI().viewToModel(this.getComponent(), pt, biasRet);
        if (e.getX() > 14) {
            if (biasRet[0] == null) {
                biasRet[0] = Position.Bias.Forward;
            }
            if (pos >= 0) {
                this.setDot(pos);
            }
        } else {
            this.editor.toggleBreakpoint(pos);
        }
    }

    protected void moveCaret(MouseEvent e) {
        if (e.getX() > 14) {
            super.moveCaret(e);
        }
    }

    public void setDot(int pos) {
        this.persistentHighlight = false;
        super.setDot(pos);
    }

    public void moveDot(int pos) {
        this.persistentHighlight = false;
        super.moveDot(pos);
    }

    protected void fireStateChanged() {
        this.editor.caretMoved();
        super.fireStateChanged();
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (this.persistentHighlight) {
            this.setSelectionVisible(true);
        }
    }

    public void setPersistentHighlight() {
        this.setSelectionVisible(true);
        this.persistentHighlight = true;
    }

    public void paintMatchingBracket() {
        int matchBracket = this.editor.getBracketMatch();
        this.removeBracket();
        if (matchBracket != -1) {
            try {
                this.matchingBracketHighlight = this.getComponent().getHighlighter().addHighlight(matchBracket, matchBracket + 1, bracketPainter);
            }
            catch (BadLocationException ble) {
                Debug.reportError((String)"bad location exception thrown");
                ble.printStackTrace();
            }
        }
    }

    public void removeBracket() {
        if (this.matchingBracketHighlight != null) {
            this.getComponent().getHighlighter().removeHighlight(this.matchingBracketHighlight);
            this.matchingBracketHighlight = null;
        }
    }
}

