/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeEditorManager;
import bluej.utility.BlueJFileReader;
import bluej.utility.DialogManager;
import bluej.utility.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class Info
extends JPanel
implements ActionListener {
    static final ImageIcon helpImage = Config.getImageAsIcon((String)"image.editor.help");
    public static Font infoFont = new Font("SansSerif", 1, 10);
    private JLabel line1;
    private JLabel line2;
    String originalMsg;
    boolean isClear;
    JButton helpButton;
    String helpGroup;

    public Info() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setFont(infoFont);
        JPanel body = new JPanel(new GridLayout(0, 1));
        body.setBackground(MoeEditor.infoColor);
        body.setBorder(new EmptyBorder(0, 6, 0, 4));
        this.line1 = new JLabel();
        this.line2 = new JLabel();
        body.add(this.line1);
        body.add(this.line2);
        this.add((Component)body, "Center");
        this.helpButton = new JButton(helpImage);
        if (!Config.isMacOS()) {
            this.helpButton.setMargin(new Insets(0, 0, 0, 0));
        } else {
            Utility.changeToMacButton((AbstractButton)this.helpButton);
        }
        this.helpButton.addActionListener(this);
        this.helpButton.setRequestFocusEnabled(false);
        this.add((Component)this.helpButton, "East");
        this.helpButton.setVisible(false);
        this.isClear = true;
        this.helpGroup = "";
    }

    public void message(String msg) {
        this.originalMsg = msg;
        int newline = msg.indexOf(10);
        if (newline == -1) {
            if (msg.length() <= 81) {
                this.message(msg, "");
            } else {
                this.message(msg.substring(0, 80), msg.substring(80));
            }
        } else {
            this.message(msg.substring(0, newline), msg.substring(newline + 1));
        }
    }

    public void message(String msg1, String msg2) {
        this.line1.setText(msg1);
        this.line2.setText(msg2.replace('\n', ' '));
        this.isClear = false;
        this.hideHelp();
    }

    public void warning(String msg) {
        this.message(msg);
        MoeEditorManager.editorManager.beep();
    }

    public void warning(String msg1, String msg2) {
        this.message(msg1, msg2);
        MoeEditorManager.editorManager.beep();
    }

    public void clear() {
        if (!this.isClear) {
            this.message(" ", " ");
            this.isClear = true;
        }
    }

    public void setHelp(String helpGroup) {
        this.helpGroup = helpGroup;
        this.helpButton.setVisible(true);
    }

    public void hideHelp() {
        this.helpButton.setVisible(false);
    }

    public void actionPerformed(ActionEvent evt) {
        this.displayHelp(this.helpGroup);
    }

    private void displayHelp(String helpGroup) {
        int i;
        String line;
        File fileName = Config.getLanguageFile((String)(helpGroup + ".help"));
        String helpText = BlueJFileReader.readHelpText((File)fileName, (String)(line = (i = this.originalMsg.indexOf(10)) < 0 ? this.originalMsg : this.originalMsg.substring(0, i)).trim(), (boolean)false);
        if (helpText == null) {
            DialogManager.showMessageWithText(null, (String)"no-help", (String)("\n" + this.originalMsg));
        } else {
            DialogManager.showText(null, (String)(this.originalMsg + "\n\n" + helpText));
        }
    }
}

