/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.JavaType;
import bluej.utility.JavaUtils;
import bluej.views.CallableView;
import bluej.views.View;
import java.lang.reflect.Constructor;
import java.util.List;

public final class ConstructorView
extends CallableView {
    protected Constructor cons;

    public ConstructorView(View view, Constructor cons) {
        super(view);
        this.cons = cons;
    }

    public String toString() {
        return this.cons.toString();
    }

    public int getModifiers() {
        return this.cons.getModifiers();
    }

    public boolean hasParameters() {
        return this.cons.getParameterTypes().length > 0;
    }

    public boolean isGeneric() {
        return !JavaUtils.getJavaUtils().getTypeParams(this.cons).isEmpty();
    }

    public boolean isConstructor() {
        return true;
    }

    public String getSignature() {
        return JavaUtils.getJavaUtils().getSignature(this.cons);
    }

    public String getShortDesc() {
        return JavaUtils.getJavaUtils().getShortDesc(this.cons, this.getParamNames());
    }

    public String getLongDesc() {
        return JavaUtils.getJavaUtils().getLongDesc(this.cons, this.getParamNames());
    }

    public Class[] getParameters() {
        return this.cons.getParameterTypes();
    }

    public String[] getParamTypeStrings() {
        return JavaUtils.getJavaUtils().getParameterTypes(this.cons);
    }

    public JavaType[] getParamTypes(boolean raw) {
        return JavaUtils.getJavaUtils().getParamGenTypes(this.cons);
    }

    public GenTypeDeclTpar[] getTypeParams() {
        JavaUtils jutils = JavaUtils.getJavaUtils();
        List tparams = jutils.getTypeParams(this.cons);
        return tparams.toArray(new GenTypeDeclTpar[0]);
    }

    public boolean isVarArgs() {
        return JavaUtils.getJavaUtils().isVarArgs(this.cons);
    }
}

