/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.JavaUtils;
import com.apple.eio.FileManager;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.border.Border;

public class Utility {
    private static Set<String> occurredEvents = new HashSet<String>();
    private static URLClassLoader classLoader;

    public static void drawThickRect(Graphics g, int x, int y, int width, int height, int thickness) {
        for (int i = 0; i < thickness; ++i) {
            g.drawRect(x + i, y + i, width - 2 * i, height - 2 * i);
        }
    }

    public static void stripeRect(Graphics g, int x, int y, int width, int height, int separation, int thickness) {
        for (int offset = 0; offset < width + height; offset += separation) {
            int i = 0;
            while (i < thickness) {
                int y2;
                int x2;
                int y1;
                int x1;
                if (offset < height) {
                    x1 = x;
                    y1 = y + offset;
                } else {
                    x1 = x + offset - height;
                    y1 = y + height;
                }
                if (offset < width) {
                    x2 = x + offset;
                    y2 = y;
                } else {
                    x2 = x + width;
                    y2 = y + offset - width;
                }
                g.drawLine(x1, y1, x2, y2);
                ++i;
                ++offset;
            }
        }
    }

    public static void drawCentredText(Graphics g, String str, int x, int y, int width, int height) {
        FontMetrics fm = g.getFontMetrics();
        Shape oldClip = g.getClip();
        g.clipRect(x, y, width, height);
        int xOffset = (width - fm.stringWidth(str)) / 2;
        if (xOffset < 0) {
            xOffset = 0;
        }
        int yOffset = (height + fm.getAscent()) / 2;
        g.drawString(str, x + xOffset, y + yOffset);
        g.setClip(oldClip);
    }

    public static void drawRightText(Graphics g, String str, int x, int y, int width, int height) {
        FontMetrics fm = g.getFontMetrics();
        Shape oldClip = g.getClip();
        g.clipRect(x, y, width, height);
        g.drawString(str, x + width - fm.stringWidth(str), y + (height + fm.getAscent()) / 2);
        g.setClip(oldClip);
    }

    public static String[] split(String str, String delimiter) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        int len = str.length();
        int dlen = delimiter.length();
        int offset = str.lastIndexOf(delimiter);
        if (dlen < 1) {
            return null;
        }
        if (offset < 0) {
            String[] result = new String[]{str};
            return result;
        }
        if (len > offset + dlen) {
            str = str + delimiter;
            len += dlen;
        }
        do {
            offset = str.indexOf(delimiter, start);
            strings.add(str.substring(start, offset));
        } while ((start = offset + dlen) < len && offset != -1);
        String[] result = new String[strings.size()];
        strings.toArray(result);
        return result;
    }

    public static String[] splitLines(String str) {
        return str == null ? null : Utility.split(str, "\n");
    }

    public static String quoteString(String src) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\r') {
                buf.append("\\r");
                continue;
            }
            if (c == '\t') {
                buf.append("\\g");
                continue;
            }
            if (c < ' ' || c > '\u0080') {
                String n = Integer.toHexString(c);
                n = "0000".substring(n.length()) + n;
                buf.append("\\u");
                buf.append(n);
                continue;
            }
            if (c == '\\' || c == '\"' || c == '\'') {
                buf.append('\\');
            }
            buf.append(src.charAt(i));
        }
        return buf.toString();
    }

    public static void showClassDocumentation(String classname, String suffix) {
        int lastSlash;
        classname = classname.replace('.', '/');
        String docURL = Config.getPropString("bluej.url.javaStdLib");
        if (docURL.endsWith(".html") && (lastSlash = docURL.lastIndexOf(47)) != -1) {
            docURL = docURL.substring(0, lastSlash + 1);
        }
        Utility.openWebBrowser(docURL + classname + ".html" + suffix);
    }

    public static boolean openWebBrowser(String url) {
        if (Config.isWinOS()) {
            String cmd = Config.osname.startsWith("Windows 9") || Config.osname.equals("Windows Me") ? "command.com" : "cmd.exe";
            try {
                if (Config.osname.startsWith("Windows 98") || Config.osname.equals("Windows Me")) {
                    Runtime.getRuntime().exec(new String[]{cmd, "/c", "start", '\"' + url + '\"'});
                }
                Runtime.getRuntime().exec(new String[]{cmd, "/c", "start", "\"\"", '\"' + url + '\"'});
            }
            catch (IOException e) {
                Debug.reportError("could not start web browser. exc: " + e);
                return false;
            }
        } else {
            try {
                return Utility.openWebBrowser(new URL(url));
            }
            catch (MalformedURLException mfue) {
                return Utility.openWebBrowser(new File(url));
            }
        }
        return true;
    }

    public static boolean openWebBrowser(URL url) {
        if (Config.isMacOS()) {
            try {
                FileManager.openURL((String)url.toString());
            }
            catch (IOException e) {
                Debug.reportError("could not start web browser. exc: " + e);
                return false;
            }
        }
        if (Config.isWinOS()) {
            return Utility.openWebBrowser(url.toString());
        }
        if (JavaUtils.getJavaUtils().openWebBrowser(url)) {
            return true;
        }
        String cmd = Utility.mergeStrings(Config.getPropString("browserCmd1"), url.toString());
        String cmd2 = Utility.mergeStrings(Config.getPropString("browserCmd2"), url.toString());
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            try {
                p = Runtime.getRuntime().exec(cmd2);
                cmd2 = null;
            }
            catch (IOException e2) {
                Debug.reportError("could not start web browser.  exc: " + e);
                return false;
            }
        }
        final String command2 = cmd2;
        final Process process = p;
        new Thread(){

            public void run() {
                Utility.runUnixWebBrowser(process, command2);
            }
        }.start();
        return true;
    }

    private static void runUnixWebBrowser(Process p, String cmd2) {
        try {
            int exitCode = p.waitFor();
            if (exitCode != 0 && cmd2 != null && cmd2.length() > 0) {
                p = Runtime.getRuntime().exec(cmd2);
            }
        }
        catch (InterruptedException ie) {
            Debug.reportError("cannot start web browser:");
            Debug.reportError("caught exc " + ie);
        }
        catch (IOException ioe) {
            Debug.reportError("cannot start web browser:");
            Debug.reportError("caught exc " + ioe);
        }
    }

    public static boolean openWebBrowser(File file) {
        if (Config.isWinOS()) {
            return Utility.openWebBrowser(file.toString());
        }
        try {
            return Utility.openWebBrowser(file.toURI().toURL());
        }
        catch (MalformedURLException mfue) {
            return false;
        }
    }

    private static File calculateBluejLibDir() {
        File bluejDir = null;
        String bootFullName = Utility.class.getResource("Utility.class").toString();
        try {
            if (!bootFullName.startsWith("jar:")) {
                File startingDir;
                for (startingDir = new File(new URI(bootFullName)).getParentFile(); startingDir != null && !new File(startingDir.getParentFile(), "lib").isDirectory(); startingDir = startingDir.getParentFile()) {
                }
                bluejDir = startingDir == null ? null : new File(startingDir.getParentFile(), "lib");
            } else {
                int classIndex = bootFullName.indexOf("!");
                String bootName = bootFullName.substring(4, classIndex);
                File finalFile = new File(new URI(bootName));
                bluejDir = finalFile.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return bluejDir;
    }

    public static void bringToFront(Window window) {
        if (!window.isShowing()) {
            return;
        }
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        int atIndex = pid.indexOf("@");
        if (atIndex != -1) {
            pid = pid.substring(0, atIndex);
        }
        if (Config.isWinOS()) {
            File libdir = Utility.calculateBluejLibDir();
            String[] command = new String[]{"cscript", "\"" + libdir.getAbsolutePath() + "\\windowtofront.js\"", pid};
            StringBuffer commandAsStr = new StringBuffer();
            for (int i = 0; i < command.length; ++i) {
                commandAsStr.append(command[i] + " ");
            }
            try {
                Process p = Runtime.getRuntime().exec(command);
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    StringBuffer extra = new StringBuffer();
                    char[] buf = new char[1024];
                    for (int i = 0; i < 5; ++i) {
                        int len;
                        Thread.sleep(200L);
                        if (!br.ready() || (len = br.read(buf)) == -1) break;
                        extra.append(buf, 0, len);
                    }
                    if (extra.length() != 0) {
                        Debug.message("When trying to launch cscript:" + extra);
                        Debug.message(" This error was recieved: " + commandAsStr);
                    }
                }
                catch (InterruptedException ie) {}
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!Config.isLinux()) {
            if (Config.isMacOS() && !Config.isJava16()) {
                try {
                    Class<?> nsapp = null;
                    try {
                        nsapp = Class.forName("com.apple.cocoa.application.NSApplication");
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    if (nsapp == null) {
                        nsapp = Class.forName("com.apple.cocoa.application.NSApplication", true, classLoader);
                    }
                    Method sharedApp = nsapp.getMethod("sharedApplication", null);
                    Object obj = sharedApp.invoke(null, (Object[])null);
                    Class[] param = new Class[]{Boolean.TYPE};
                    Method act = nsapp.getMethod("activateIgnoringOtherApps", param);
                    Object[] args = new Object[]{Boolean.TRUE};
                    act.invoke(obj, args);
                }
                catch (Exception exc) {
                    Debug.reportError("Bringing process to front failed (MacOS): " + exc);
                }
            } else if (Config.isMacOS()) {
                String[] command = new String[]{"osascript", "-e", "tell application \"System Events\"", "-e", "set frontmost of first process whose unix id is " + pid + " to true", "-e", "end tell"};
                StringBuffer commandAsStr = new StringBuffer();
                for (int i = 0; i < command.length; ++i) {
                    commandAsStr.append(command[i] + " ");
                }
                try {
                    Process p = Runtime.getRuntime().exec(command);
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    try {
                        br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        StringBuffer extra = new StringBuffer();
                        char[] buf = new char[1024];
                        for (int i = 0; i < 5; ++i) {
                            int len;
                            Thread.sleep(200L);
                            if (!br.ready() || (len = br.read(buf)) == -1) break;
                            extra.append(buf, 0, len);
                        }
                        if (extra.length() != 0) {
                            Debug.message("When trying to launch osascript:" + extra);
                            Debug.message(" This error was recieved: " + commandAsStr);
                        }
                    }
                    catch (InterruptedException ie) {}
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    public static String mergeStrings(String s1, String s2) {
        int pos = s1.indexOf(36);
        if (pos == -1) {
            return s1;
        }
        return s1.substring(0, pos) + s2 + s1.substring(pos + 1);
    }

    public static String mergeStrings(String s1, String[] s2) {
        for (int current = 0; current < s2.length; ++current) {
            s1 = Utility.mergeStrings(s1, s2[current]);
        }
        return s1;
    }

    public static String convertTabsToSpaces(String originalString, int tabSize) {
        if (originalString.indexOf(9) != -1) {
            StringBuffer buffer = new StringBuffer(originalString);
            for (int i = 0; i < buffer.length(); ++i) {
                if (buffer.charAt(i) != '\t') continue;
                buffer.deleteCharAt(i);
                int numberOfSpaces = tabSize - i % tabSize;
                for (int j = 0; j < numberOfSpaces; ++j) {
                    buffer.insert(i, ' ');
                }
            }
            return buffer.toString();
        }
        return originalString;
    }

    public static boolean firstTimeThisRun(String context) {
        if (occurredEvents.contains(context)) {
            return false;
        }
        occurredEvents.add(context);
        return true;
    }

    public static boolean firstTimeEver(String context) {
        boolean occurred = Config.getPropBoolean(context);
        if (occurred) {
            return false;
        }
        Config.putPropBoolean(context, true);
        return true;
    }

    public static void changeToMacButton(AbstractButton button) {
        if (!Config.isMacOS()) {
            return;
        }
        Border oldBorder = button.getBorder();
        button.putClientProperty("JButton.buttonType", "square");
        if (oldBorder == button.getBorder()) {
            button.putClientProperty("JButton.buttonType", "toolbar");
        } else {
            button.setMargin(new Insets(3, 1, 3, 1));
        }
    }

    public static boolean isDeadKey(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                return true;
            }
        }
        return false;
    }

    static {
        try {
            classLoader = new URLClassLoader(new URL[]{new File("/System/Library/Java/").toURI().toURL()});
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

