/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

public class MiksGridLayout
extends GridLayout {
    public MiksGridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public MiksGridLayout(int rows, int cols, int hgap, int vgap) {
        super(rows, cols, hgap, vgap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.getRows();
            int ncols = this.getColumns();
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int[] colWidth = new int[ncols];
            int[] rowHeight = new int[nrows];
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getPreferredSize();
                int row = i / ncols;
                int col = i % ncols;
                if (rowHeight[row] < d.height) {
                    rowHeight[row] = d.height;
                }
                if (colWidth[col] >= d.width) continue;
                colWidth[col] = d.width;
            }
            int allColWidth = 0;
            for (int col = 0; col < ncols; ++col) {
                allColWidth += colWidth[col];
            }
            int allRowHeight = 0;
            for (int row = 0; row < nrows; ++row) {
                allRowHeight += rowHeight[row];
            }
            return new Dimension(insets.left + insets.right + allColWidth + (ncols - 1) * this.getHgap(), insets.top + insets.bottom + allRowHeight + (nrows - 1) * this.getVgap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.getRows();
            int ncols = this.getColumns();
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int[] colWidth = new int[ncols];
            int[] rowHeight = new int[nrows];
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getMinimumSize();
                int row = i / ncols;
                int col = i % ncols;
                if (rowHeight[row] < d.height) {
                    rowHeight[row] = d.height;
                }
                if (colWidth[col] >= d.width) continue;
                colWidth[col] = d.width;
            }
            int allColWidth = 0;
            for (int col = 0; col < ncols; ++col) {
                allColWidth += colWidth[col];
            }
            int allRowHeight = 0;
            for (int row = 0; row < nrows; ++row) {
                allRowHeight += rowHeight[row];
            }
            return new Dimension(insets.left + insets.right + allColWidth + (ncols - 1) * this.getHgap(), insets.top + insets.bottom + allRowHeight + (nrows - 1) * this.getVgap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int row;
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.getRows();
            int ncols = this.getColumns();
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            boolean ltr = parent.getComponentOrientation().isLeftToRight();
            if (!ltr) {
                throw new IllegalArgumentException("Orientation oher than left-to-right not supported");
            }
            if (ncomponents == 0) {
                return;
            }
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int[] colWidth = new int[ncols];
            for (int col = 0; col < ncols; ++col) {
                int w = 0;
                for (int i = col; i < ncomponents; i += ncols) {
                    Component comp = parent.getComponent(i);
                    Dimension d = comp.getPreferredSize();
                    if (w >= d.width) continue;
                    w = d.width;
                }
                colWidth[col] = w;
            }
            int colSum = 0;
            for (int col = 0; col < ncols - 1; ++col) {
                colSum += colWidth[col];
            }
            int[] rowHeight = new int[nrows];
            int rowSum = 0;
            for (row = 0; row < nrows; ++row) {
                int h = 0;
                for (int i = row * ncols; i < (row + 1) * ncols && i < ncomponents; ++i) {
                    Component comp = parent.getComponent(i);
                    Dimension d = comp.getPreferredSize();
                    if (h >= d.height) continue;
                    h = d.height;
                }
                rowHeight[row] = h;
            }
            rowSum = 0;
            for (row = 0; row < nrows - 1; ++row) {
                rowSum += rowHeight[row];
            }
            int parentWidth = parent.getWidth() - (insets.left + insets.right);
            int parentHeight = parent.getHeight() - (insets.top + insets.bottom);
            colWidth[ncols - 1] = parentWidth - (ncols - 1) * hgap - colSum;
            if (colWidth[ncols - 1] < 0) {
                colWidth[ncols - 1] = 0;
            }
            rowHeight[nrows - 1] = parentHeight - (nrows - 1) * vgap - rowSum;
            if (rowHeight[nrows - 1] < 0) {
                rowHeight[nrows - 1] = 0;
            }
            int y = insets.top;
            for (int r = 0; r < nrows; ++r) {
                int x = insets.left;
                for (int c = 0; c < ncols; ++c) {
                    int i = r * ncols + c;
                    if (i < ncomponents) {
                        parent.getComponent(i).setBounds(x, y, colWidth[c], rowHeight[r]);
                    }
                    x += colWidth[c] + hgap;
                }
                y += rowHeight[r] + vgap;
            }
        }
    }
}

