/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeSuper;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.JavaType;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import bluej.utility.JavaUtils14;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JavaUtils15
extends JavaUtils {
    public String getSignature(Method method) {
        String name = JavaUtils15.getTypeParameters(method);
        name = name + JavaUtils15.getTypeName(method.getGenericReturnType()) + " " + method.getName();
        Type[] params = method.getGenericParameterTypes();
        return JavaUtils15.makeSignature(name, params, method.isVarArgs());
    }

    public String getSignature(Constructor cons) {
        String name = JavaUtils15.getTypeParameters(cons);
        name = name + JavaNames.getBase(cons.getName());
        Type[] params = cons.getGenericParameterTypes();
        return JavaUtils15.makeSignature(name, params, cons.isVarArgs());
    }

    private static String makeSignature(String name, Type[] params, boolean isVarArgs) {
        String[] typeStrings = JavaUtils15.typeArrayToStrings(params);
        return JavaUtils15.makeDescription(name, typeStrings, null, true, isVarArgs);
    }

    private static String[] typeArrayToStrings(Type[] types) {
        String[] rval = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            rval[i] = JavaUtils15.getTypeName(types[i]);
        }
        return rval;
    }

    public String getDescription(Method method, String[] paramnames, Map tparams, boolean longDesc) {
        if (tparams == null) {
            String name = JavaUtils14.getTypeName(method.getReturnType()) + " " + method.getName();
            Class[] params = method.getParameterTypes();
            String[] paramTypes = JavaUtils14.getParameterTypes(params);
            return JavaUtils15.makeDescription(name, paramTypes, paramnames, longDesc, false);
        }
        HashMap<String, GenTypeDeclTpar> newMap = new HashMap<String, GenTypeDeclTpar>(tparams);
        List myParams = this.getTypeParams(method);
        for (GenTypeDeclTpar tpar : myParams) {
            newMap.put(tpar.getTparName(), tpar);
        }
        String name = JavaUtils15.getTypeParameters(method);
        JavaType rtype = this.getReturnType(method);
        name = name + rtype.mapTparsToTypes(newMap).toString(true) + " " + method.getName();
        JavaType[] paramTypes = this.getParamGenTypes(method, false);
        String[] paramTypeNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypeNames[i] = paramTypes[i].mapTparsToTypes(newMap).toString(true);
        }
        return JavaUtils15.makeDescription(name, paramTypeNames, paramnames, longDesc, method.isVarArgs());
    }

    public String getShortDesc(Method method, String[] paramnames, Map tparams) {
        return this.getDescription(method, paramnames, tparams, false);
    }

    public String getLongDesc(Method method, String[] paramnames, Map tparams) {
        return this.getDescription(method, paramnames, tparams, true);
    }

    public String getShortDesc(Method method, String[] paramnames) {
        String name = JavaUtils15.getTypeParameters(method);
        name = name + JavaUtils15.getTypeName(method.getGenericReturnType()) + " " + method.getName();
        Type[] paramTypes = method.getGenericParameterTypes();
        String[] paramTypeNames = this.getParameterTypes(paramTypes, false);
        return JavaUtils15.makeDescription(name, paramTypeNames, paramnames, false, method.isVarArgs());
    }

    public String getLongDesc(Method method, String[] paramnames) {
        String name = JavaUtils15.getTypeParameters(method);
        name = name + JavaUtils15.getTypeName(method.getGenericReturnType()) + " " + method.getName();
        Type[] paramTypes = method.getGenericParameterTypes();
        String[] paramTypeNames = this.getParameterTypes(paramTypes, false);
        return JavaUtils15.makeDescription(name, paramTypeNames, paramnames, true, method.isVarArgs());
    }

    public String getDescription(Constructor constructor, String[] paramnames, boolean longDesc) {
        String name = JavaUtils15.getTypeParameters(constructor);
        name = name + constructor.getName();
        name = name + JavaUtils15.typeParamsToString(constructor.getDeclaringClass().getTypeParameters(), false);
        Type[] paramTypes = constructor.getGenericParameterTypes();
        String[] paramTypeNames = this.getParameterTypes(paramTypes, false);
        return JavaUtils15.makeDescription(name, paramTypeNames, paramnames, longDesc, constructor.isVarArgs());
    }

    public String getShortDesc(Constructor constructor, String[] paramnames) {
        return this.getDescription(constructor, paramnames, false);
    }

    public String getLongDesc(Constructor constructor, String[] paramnames) {
        return this.getDescription(constructor, paramnames, true);
    }

    public boolean isVarArgs(Constructor cons) {
        return cons.isVarArgs();
    }

    public boolean isVarArgs(Method method) {
        return method.isVarArgs();
    }

    public boolean isSynthetic(Method method) {
        return method.isSynthetic();
    }

    public boolean isEnum(Class cl) {
        return cl.isEnum();
    }

    public JavaType getReturnType(Method method) {
        Type rt = method.getGenericReturnType();
        return JavaUtils15.genTypeFromType(rt);
    }

    public JavaType getRawReturnType(Method method) {
        Class<?> c = method.getReturnType();
        return JavaUtils14.genTypeFromClass14(c);
    }

    public JavaType getFieldType(Field field) {
        return JavaUtils15.genTypeFromType(field.getGenericType());
    }

    public JavaType getRawFieldType(Field field) {
        Class<?> c = field.getType();
        return JavaUtils14.genTypeFromClass14(c);
    }

    public List getTypeParams(Method method) {
        return this.getTypeParams((GenericDeclaration)method);
    }

    public List getTypeParams(Constructor cons) {
        return this.getTypeParams((GenericDeclaration)cons);
    }

    public List getTypeParams(Class cl) {
        return this.getTypeParams((GenericDeclaration)cl);
    }

    public GenTypeClass getSuperclass(Class cl) {
        Type sc = cl.getGenericSuperclass();
        if (sc == null) {
            return null;
        }
        return (GenTypeClass)JavaUtils15.genTypeFromType(sc);
    }

    public GenTypeClass[] getInterfaces(Class cl) {
        Type[] classes = cl.getGenericInterfaces();
        GenTypeClass[] gentypes = new GenTypeClass[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            gentypes[i] = (GenTypeClass)JavaUtils15.genTypeFromType(classes[i]);
        }
        return gentypes;
    }

    public String[] getParameterTypes(Method method) {
        Type[] params = method.getGenericParameterTypes();
        boolean isVarArgs = this.isVarArgs(method);
        return this.getParameterTypes(params, isVarArgs);
    }

    public JavaType[] getParamGenTypes(Method method, boolean raw) {
        Type[] params = raw ? method.getParameterTypes() : method.getGenericParameterTypes();
        JavaType[] gentypes = new JavaType[params.length];
        for (int i = 0; i < params.length; ++i) {
            gentypes[i] = JavaUtils15.genTypeFromType(params[i]);
        }
        return gentypes;
    }

    public String[] getParameterTypes(Constructor constructor) {
        Type[] params = constructor.getGenericParameterTypes();
        boolean isVarArgs = this.isVarArgs(constructor);
        return this.getParameterTypes(params, isVarArgs);
    }

    public JavaType[] getParamGenTypes(Constructor constructor) {
        Type[] params = constructor.getGenericParameterTypes();
        JavaType[] gentypes = new JavaType[params.length];
        for (int i = 0; i < params.length; ++i) {
            gentypes[i] = JavaUtils15.genTypeFromType(params[i]);
        }
        return gentypes;
    }

    public JavaType genTypeFromClass(Class t) {
        return JavaUtils15.genTypeFromType(t);
    }

    private List getTypeParams(GenericDeclaration decl) {
        ArrayList<GenTypeDeclTpar> rlist = new ArrayList<GenTypeDeclTpar>();
        TypeVariable<?>[] tvars = decl.getTypeParameters();
        for (int i = 0; i < tvars.length; ++i) {
            Type[] bounds = tvars[i].getBounds();
            GenTypeSolid[] upperBounds = new GenTypeSolid[bounds.length];
            for (int j = 0; j < bounds.length; ++j) {
                upperBounds[j] = (GenTypeSolid)JavaUtils15.genTypeFromType(bounds[j]);
            }
            rlist.add(new GenTypeDeclTpar(tvars[i].getName(), upperBounds));
        }
        return rlist;
    }

    private String[] getParameterTypes(Type[] params, boolean isVarArgs) {
        String[] parameterTypes = new String[params.length];
        for (int j = 0; j < params.length; ++j) {
            String typeName = JavaUtils15.getTypeName(params[j]);
            if (isVarArgs && j == params.length - 1) {
                typeName = JavaUtils15.createVarArg(typeName);
            }
            parameterTypes[j] = typeName;
        }
        return parameterTypes;
    }

    private static String getTypeName(Type type) {
        StringBuffer sb = new StringBuffer();
        Type primtype = type;
        int dimensions = 0;
        while (primtype instanceof GenericArrayType) {
            ++dimensions;
            primtype = ((GenericArrayType)primtype).getGenericComponentType();
        }
        if (primtype == null) {
            Debug.message("type == null??");
        }
        if (primtype instanceof Class) {
            sb.append(JavaUtils14.getTypeName((Class)primtype));
        } else if (primtype instanceof ParameterizedType) {
            sb.append(JavaUtils15.getTypeName((ParameterizedType)primtype));
        } else if (primtype instanceof TypeVariable) {
            sb.append(((TypeVariable)primtype).getName());
        } else if (primtype instanceof WildcardType) {
            sb.append(JavaUtils15.getTypeName((WildcardType)primtype));
        } else {
            Debug.message("getTypeName: Unknown type: " + primtype.getClass().getName());
        }
        while (dimensions > 0) {
            sb.append("[]");
            --dimensions;
        }
        return sb.toString();
    }

    private static String getTypeName(ParameterizedType type) {
        StringBuffer sb = new StringBuffer();
        sb.append(JavaUtils15.getTypeName(type.getRawType()));
        sb.append('<');
        Type[] argTypes = type.getActualTypeArguments();
        for (int i = 0; i < argTypes.length; ++i) {
            sb.append(JavaUtils15.getTypeName(argTypes[i]));
            if (i == argTypes.length - 1) continue;
            sb.append(',');
        }
        sb.append('>');
        return sb.toString();
    }

    private static String getTypeName(WildcardType type) {
        StringBuffer sb = new StringBuffer();
        Type[] upperBounds = type.getUpperBounds();
        Type[] lowerBounds = type.getLowerBounds();
        if (lowerBounds.length == 0 || lowerBounds[0] == null) {
            if (upperBounds.length == 0 || upperBounds[0] == null || upperBounds[0].equals(Object.class)) {
                sb.append("?");
            } else {
                sb.append("? extends ");
                sb.append(JavaUtils15.getTypeName(upperBounds[0]));
                if (upperBounds.length != 1) {
                    Debug.message("getTypeName: multiple upper bounds for wildcard type?");
                }
            }
        } else {
            sb.append("? super ");
            if (lowerBounds[0] == null) {
                Debug.message("lower bound[0] is null??");
                sb.append("[null type]");
            } else {
                sb.append(JavaUtils15.getTypeName(lowerBounds[0]));
            }
            if (upperBounds.length != 0 && upperBounds[0] != null && upperBounds[0] != Object.class) {
                Debug.message("getTypeName: upper and lower bound?");
                Debug.message("upper bound is: " + upperBounds[0]);
            }
            if (lowerBounds.length != 1) {
                Debug.message("getTypeName: multiple lower bounds for wildcard type?");
            }
        }
        return sb.toString();
    }

    private static String createVarArg(String typeName) {
        String lastArrayStripped = typeName.substring(0, typeName.length() - 2);
        return lastArrayStripped + " ...";
    }

    private static String getTypeParameters(Method method) {
        return JavaUtils15.typeParamsToString(method.getTypeParameters(), true);
    }

    private static String getTypeParameters(Constructor cons) {
        return JavaUtils15.typeParamsToString(cons.getTypeParameters(), true);
    }

    private static String typeParamsToString(TypeVariable[] tparams, boolean extraSpace) {
        if (tparams.length != 0) {
            String name = "<";
            for (int i = 0; i < tparams.length; ++i) {
                TypeVariable type = tparams[i];
                name = name + type.getName();
                Type[] upperBounds = type.getBounds();
                if (upperBounds.length != 0 && upperBounds[0] != null && !upperBounds[0].equals(Object.class)) {
                    name = name + " extends " + JavaUtils15.getTypeName(upperBounds[0]);
                    for (int j = 1; j < upperBounds.length; ++j) {
                        name = name + " & " + JavaUtils15.getTypeName(upperBounds[j]);
                    }
                }
                if (i == tparams.length - 1) continue;
                name = name + ',';
            }
            name = name + ">";
            if (extraSpace) {
                name = name + " ";
            }
            return name;
        }
        return "";
    }

    private static JavaType genTypeFromType(Type t) {
        return JavaUtils15.genTypeFromType(t, new LinkedList());
    }

    private static JavaType genTypeFromType(Type t, List backTrace) {
        if (t instanceof Class) {
            return JavaUtils14.genTypeFromClass14((Class)t);
        }
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            if (backTrace.contains(t)) {
                return new GenTypeUnbounded();
            }
            Type[] bounds = tv.getBounds();
            GenTypeSolid[] gtBounds = new GenTypeSolid[bounds.length];
            backTrace.add(t);
            for (int i = 0; i < bounds.length; ++i) {
                gtBounds[i] = (GenTypeSolid)JavaUtils15.genTypeFromType(bounds[i], backTrace);
            }
            return new GenTypeDeclTpar(tv.getName(), gtBounds);
        }
        if (t instanceof WildcardType) {
            if (backTrace.contains(t)) {
                return new GenTypeUnbounded();
            }
            WildcardType wtype = (WildcardType)t;
            Type[] upperBounds = wtype.getUpperBounds();
            Type[] lowerBounds = wtype.getLowerBounds();
            backTrace.add(t);
            if (lowerBounds.length == 0 || lowerBounds[0] == null) {
                if (upperBounds.length == 0 || upperBounds[0] == null) {
                    return new GenTypeUnbounded();
                }
                GenTypeSolid gtp = (GenTypeSolid)JavaUtils15.genTypeFromType(upperBounds[0], backTrace);
                if (upperBounds.length != 1) {
                    Debug.message("GenTypeFromType: multiple upper bounds for wildcard type?");
                }
                return new GenTypeExtends(gtp);
            }
            if (lowerBounds[0] == null) {
                Debug.message("lower bound[0] is null??");
                return new GenTypeSuper(null);
            }
            if (upperBounds.length != 0 && upperBounds[0] != null && upperBounds[0] != Object.class) {
                Debug.message("getTypeName: upper and lower bound?");
            }
            if (lowerBounds.length != 1) {
                Debug.message("getTypeName: multiple lower bounds for wildcard type?");
            }
            GenTypeSolid lbound = (GenTypeSolid)JavaUtils15.genTypeFromType(lowerBounds[0], backTrace);
            return new GenTypeSuper(lbound);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            Class rawtype = (Class)pt.getRawType();
            Type[] argtypes = pt.getActualTypeArguments();
            ArrayList<JavaType> arggentypes = new ArrayList<JavaType>();
            for (int i = 0; i < argtypes.length; ++i) {
                arggentypes.add(JavaUtils15.genTypeFromType(argtypes[i], backTrace));
            }
            GenTypeClass outer = null;
            if (pt.getOwnerType() != null) {
                outer = (GenTypeClass)JavaUtils15.genTypeFromType(pt.getOwnerType());
            }
            return new GenTypeClass(new JavaReflective(rawtype), arggentypes, outer);
        }
        GenericArrayType gat = (GenericArrayType)t;
        JavaType componentType = JavaUtils15.genTypeFromType(gat.getGenericComponentType(), backTrace);
        JavaReflective reflective = new JavaReflective(JavaUtils15.getRclass(gat));
        return new GenTypeArray(componentType, reflective);
    }

    private static Class getRclass(Type t) {
        String rName;
        int arrnum = 0;
        while (!(t instanceof Class)) {
            if (t instanceof ParameterizedType) {
                t = ((ParameterizedType)t).getRawType();
            }
            if (t instanceof TypeVariable) {
                t = ((TypeVariable)t).getBounds()[0];
            }
            if (t instanceof WildcardType) {
                t = ((WildcardType)t).getUpperBounds()[0];
            }
            if (!(t instanceof GenericArrayType)) continue;
            ++arrnum;
            t = ((GenericArrayType)t).getGenericComponentType();
        }
        Class rClass = (Class)t;
        ClassLoader classLoader = rClass.getClassLoader();
        if (arrnum == 0) {
            rName = rClass.getName();
        } else {
            rName = JavaUtils15.genTypeFromType(t).arrayComponentName();
            while (arrnum > 0) {
                rName = "[" + rName;
                --arrnum;
            }
        }
        try {
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            return classLoader.loadClass(rName);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }
}

