/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.Reflective;
import bluej.utility.JavaUtils;
import java.util.ArrayList;
import java.util.List;

public class JavaReflective
extends Reflective {
    private Class c;

    public int hashCode() {
        return this.c.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof JavaReflective) {
            JavaReflective jrOther = (JavaReflective)other;
            return jrOther.c == this.c;
        }
        return false;
    }

    public JavaReflective(Class c) {
        this.c = c;
    }

    public String getName() {
        return this.c.getName();
    }

    public boolean isInterface() {
        return this.c.isInterface();
    }

    public boolean isStatic() {
        return (this.c.getModifiers() & 8) != 0;
    }

    public List getTypeParams() {
        return JavaUtils.getJavaUtils().getTypeParams(this.c);
    }

    public Reflective getArrayOf() {
        String rname = this.c.isArray() ? "[" + this.c.getName() : "[L" + this.c.getName() + ";";
        try {
            ClassLoader cloader = this.c.getClassLoader();
            if (cloader == null) {
                cloader = ClassLoader.getSystemClassLoader();
            }
            Class<?> arrClass = cloader.loadClass(rname);
            return new JavaReflective(arrClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Reflective getRelativeClass(String name) {
        try {
            ClassLoader cloader = this.c.getClassLoader();
            if (cloader == null) {
                cloader = ClassLoader.getSystemClassLoader();
            }
            Class<?> cr = cloader.loadClass(name);
            return new JavaReflective(cr);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public List getSuperTypesR() {
        Class superclass;
        ArrayList<Reflective> l = new ArrayList<Reflective>();
        if (this.c.isArray()) {
            Class<?> ct = this.c.getComponentType();
            JavaReflective ctR = new JavaReflective(ct);
            List componentSuperTypes = ctR.getSuperTypesR();
            for (JavaReflective componentSuperType : componentSuperTypes) {
                l.add(componentSuperType.getArrayOf());
            }
        }
        if ((superclass = this.c.getSuperclass()) != null) {
            l.add(new JavaReflective(superclass));
        }
        Class<?>[] interfaces = this.c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            l.add(new JavaReflective(interfaces[i]));
        }
        if (superclass == null && interfaces.length == 0 && this.c.isInterface()) {
            l.add(new JavaReflective(Object.class));
        }
        return l;
    }

    public List getSuperTypes() {
        GenTypeClass superclass;
        ArrayList<GenTypeClass> l = new ArrayList<GenTypeClass>();
        if (this.c.isArray()) {
            Class<?> ct = this.c.getComponentType();
            JavaReflective ctR = new JavaReflective(ct);
            List componentSuperTypes = ctR.getSuperTypes();
            for (GenTypeClass componentSuperType : componentSuperTypes) {
                l.add(new GenTypeArray(componentSuperType, componentSuperType.getReflective().getArrayOf()));
            }
        }
        if ((superclass = JavaUtils.getJavaUtils().getSuperclass(this.c)) != null) {
            l.add(superclass);
        }
        GenTypeClass[] interfaces = JavaUtils.getJavaUtils().getInterfaces(this.c);
        for (int i = 0; i < interfaces.length; ++i) {
            l.add(interfaces[i]);
        }
        if (superclass == null && interfaces.length == 0 && this.c.isInterface()) {
            l.add(new GenTypeClass(new JavaReflective(Object.class)));
        }
        return l;
    }

    public Class getUnderlyingClass() {
        return this.c;
    }

    public boolean isAssignableFrom(Reflective r) {
        if (r instanceof JavaReflective) {
            return this.c.isAssignableFrom(((JavaReflective)r).getUnderlyingClass());
        }
        return false;
    }
}

