/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.prefmgr.PrefMgr;
import bluej.utility.BlueJFileChooser;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.PackageChooser;
import bluej.utility.PackageChooserStrict;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileUtility {
    private static final String sourceSuffix = ".java";
    private static JFileChooser pkgChooser = null;
    private static JFileChooser pkgChooserNonBlueJ = null;
    private static JFileChooser fileChooser = null;
    private static JFileChooser directoryChooser = null;
    private static JFileChooser multiFileChooser = null;
    public static final int NO_ERROR = 0;
    public static final int DEST_EXISTS = 1;
    public static final int SRC_NOT_DIRECTORY = 2;
    public static final int COPY_ERROR = 3;

    public static File getPackageName(Component parent) {
        JFileChooser chooser = FileUtility.getPackageChooser();
        if (chooser.showOpenDialog(parent) != 0) {
            return null;
        }
        PrefMgr.setProjectDirectory(chooser.getSelectedFile().getParentFile().getPath());
        return chooser.getSelectedFile();
    }

    public static File getNonBlueJDirectoryName(Component parent) {
        JFileChooser chooser = FileUtility.getNonBlueJPackageChooser();
        if (chooser.showOpenDialog(parent) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public static File[] getMultipleFiles(Component parent, String title, String buttonLabel, FileFilter filter) {
        JFileChooser newMultiChooser = FileUtility.getMultipleFileChooser();
        newMultiChooser.setDialogTitle(title);
        if (filter == null) {
            filter = newMultiChooser.getAcceptAllFileFilter();
        }
        newMultiChooser.setFileFilter(filter);
        int result = newMultiChooser.showDialog(parent, buttonLabel);
        if (result == 0) {
            return newMultiChooser.getSelectedFiles();
        }
        if (result == 1) {
            return null;
        }
        DialogManager.showError(parent, "error-no-name");
        return null;
    }

    public static String getFileName(Component parent, String title, String buttonLabel, boolean directoryOnly, FileFilter filter, boolean rememberDir) {
        JFileChooser newChooser = FileUtility.getFileChooser(directoryOnly, filter);
        newChooser.setDialogTitle(title);
        int result = newChooser.showDialog(parent, buttonLabel);
        if (result == 0) {
            if (rememberDir) {
                PrefMgr.setProjectDirectory(newChooser.getSelectedFile().getParentFile().getPath());
            }
            return newChooser.getSelectedFile().getPath();
        }
        if (result == 1) {
            return null;
        }
        DialogManager.showError(parent, "error-no-name");
        return null;
    }

    public static FileFilter getJavaSourceFilter() {
        return new JavaSourceFilter();
    }

    private static JFileChooser getFileChooser(boolean directoriesOnly, FileFilter filter) {
        JFileChooser newChooser;
        if (directoriesOnly) {
            newChooser = FileUtility.getDirectoryChooser();
        } else {
            newChooser = FileUtility.getFileChooser();
            newChooser.setFileSelectionMode(2);
        }
        if (filter == null) {
            filter = newChooser.getAcceptAllFileFilter();
        }
        newChooser.setFileFilter(filter);
        return newChooser;
    }

    private static JFileChooser getPackageChooser() {
        if (pkgChooser == null) {
            pkgChooser = new PackageChooserStrict(new File(PrefMgr.getProjectDirectory()));
        }
        pkgChooser.setDialogTitle(Config.getString("pkgmgr.openPkg.title"));
        pkgChooser.setApproveButtonText(Config.getString("pkgmgr.openPkg.buttonLabel"));
        return pkgChooser;
    }

    private static JFileChooser getNonBlueJPackageChooser() {
        if (pkgChooserNonBlueJ == null) {
            pkgChooserNonBlueJ = new PackageChooser(new File(PrefMgr.getProjectDirectory()), true, true);
        }
        pkgChooserNonBlueJ.setDialogTitle(Config.getString("pkgmgr.openNonBlueJPkg.title"));
        pkgChooserNonBlueJ.setApproveButtonText(Config.getString("pkgmgr.openNonBlueJPkg.buttonLabel"));
        return pkgChooserNonBlueJ;
    }

    private static JFileChooser getDirectoryChooser() {
        if (directoryChooser == null) {
            directoryChooser = new PackageChooser(new File(PrefMgr.getProjectDirectory()), false, false);
        }
        return directoryChooser;
    }

    private static JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = new BlueJFileChooser(PrefMgr.getProjectDirectory());
        }
        return fileChooser;
    }

    private static JFileChooser getMultipleFileChooser() {
        if (multiFileChooser == null) {
            multiFileChooser = new BlueJFileChooser(PrefMgr.getProjectDirectory());
            multiFileChooser.setMultiSelectionEnabled(true);
        }
        return multiFileChooser;
    }

    public static void copyFile(String source, String dest) throws IOException {
        File srcFile = new File(source);
        File destFile = new File(dest);
        FileUtility.copyFile(srcFile, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File srcFile, File destFile) throws IOException {
        OutputStream out;
        block6: {
            if (srcFile.equals(destFile)) {
                return;
            }
            BufferedInputStream in = null;
            out = null;
            try {
                in = new BufferedInputStream(new FileInputStream(srcFile));
                out = new BufferedOutputStream(new FileOutputStream(destFile));
                FileUtility.copyStream(in, out);
                Object var5_4 = null;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            ((InputStream)in).close();
        }
        if (out != null) {
            out.close();
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int c;
        while ((c = in.read()) != -1) {
            out.write(c);
        }
    }

    public static int copyDirectory(File srcFile, File destFile) {
        if (!srcFile.isDirectory()) {
            return 2;
        }
        if (destFile.exists()) {
            return 1;
        }
        if (!destFile.mkdir()) {
            return 3;
        }
        String[] dir = srcFile.list();
        for (int i = 0; i < dir.length; ++i) {
            File file = new File(srcFile, dir[i]);
            if (file.isDirectory()) {
                if (FileUtility.copyDirectory(file, new File(destFile, dir[i])) == 0) continue;
                return 3;
            }
            File file2 = new File(destFile, dir[i]);
            try {
                FileUtility.copyFile(file, file2);
                continue;
            }
            catch (IOException ioe) {
                return 3;
            }
        }
        return 0;
    }

    public static File[] recursiveCopyFile(File srcDir, File destDir) {
        if (srcDir == null || destDir == null) {
            throw new IllegalArgumentException();
        }
        for (File parentDir = destDir.getParentFile(); parentDir != null; parentDir = parentDir.getParentFile()) {
            if (!parentDir.equals(srcDir)) continue;
            return new File[]{srcDir};
        }
        return FileUtility.actualRecursiveCopyFile(srcDir, destDir);
    }

    private static File[] actualRecursiveCopyFile(File srcDir, File destDir) {
        ArrayList<File> failed = new ArrayList<File>();
        if (srcDir.getAbsolutePath().equals(destDir.getAbsolutePath())) {
            return null;
        }
        if (!srcDir.isDirectory() || !destDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        File[] files = srcDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                File newDir = new File(destDir, files[i].getName());
                newDir.mkdir();
                if (newDir.isDirectory()) {
                    FileUtility.actualRecursiveCopyFile(files[i], newDir);
                    continue;
                }
                failed.add(files[i]);
                continue;
            }
            if (!files[i].isFile()) continue;
            File newFile = new File(destDir, files[i].getName());
            if (!newFile.exists()) {
                try {
                    FileUtility.copyFile(files[i], newFile);
                }
                catch (IOException ioe) {
                    failed.add(files[i]);
                }
                continue;
            }
            failed.add(files[i]);
        }
        if (failed.size() > 0) {
            return failed.toArray(new File[0]);
        }
        return null;
    }

    public static File findFile(File startDir, String suffix) {
        int i;
        File[] files = startDir.listFiles();
        for (i = 0; i < files.length; ++i) {
            if (!files[i].isFile() || !files[i].getName().endsWith(suffix)) continue;
            return files[i];
        }
        for (i = 0; i < files.length; ++i) {
            File found;
            if (!files[i].isDirectory() || (found = FileUtility.findFile(files[i], suffix)) == null) continue;
            return found;
        }
        return null;
    }

    public static boolean containsFile(File dir, String suffix) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile() || !files[i].getName().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static void deleteDir(File directory) {
        File[] fileList = directory.listFiles();
        if (fileList == null || Array.getLength(fileList) == 0) {
            try {
                directory.delete();
            }
            catch (SecurityException se) {
                Debug.message("Trouble deleting: " + directory + se);
            }
        } else {
            for (int i = 0; i < Array.getLength(fileList); ++i) {
                FileUtility.deleteDir(fileList[i]);
            }
            try {
                directory.delete();
            }
            catch (SecurityException se) {
                Debug.message("Trouble deleting: " + directory + se);
            }
        }
    }

    public static String makeRelativePath(File parent, File file) {
        String parentPath;
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(parentPath = parent.getAbsolutePath())) {
            filePath = filePath.substring(parentPath.length() + 1);
        }
        return filePath;
    }

    private static class JavaSourceFilter
    extends FileFilter {
        private JavaSourceFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(FileUtility.sourceSuffix);
        }

        public String getDescription() {
            return "Java Source";
        }
    }
}

