/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.SizeRequirements;

public class DBoxLayout
implements LayoutManager2 {
    public static int X_AXIS = 0;
    public static int Y_AXIS = 1;
    private static final SizeRequirements noSize = new SizeRequirements(0, 0, 0, 0.5f);
    private int axis;
    private int minComponentSpacing;
    private int componentSpacing;
    private SizeRequirements[] sizeReqsX;
    private SizeRequirements[] sizeReqsY;
    private SizeRequirements totalReqsX;
    private SizeRequirements totalReqsY;
    private int visibleCount;
    private int curPos;
    private boolean needSpaces;
    private int spacingNumerator;
    private int spacingDenom;
    private int spacingRemainder;
    private Insets insets;

    public DBoxLayout(int axis) {
        this.axis = axis;
    }

    public DBoxLayout(int axis, int minSpacing, int prefSpacing) {
        this.axis = axis;
        this.minComponentSpacing = minSpacing;
        this.componentSpacing = prefSpacing;
    }

    public boolean isXPrimaryAxis() {
        return this.axis == X_AXIS;
    }

    private void placeComponent(Component c, int space, int opposedPos, int opposedSize) {
        int advance = this.spacingNumerator / this.spacingDenom;
        this.spacingRemainder += this.spacingNumerator % this.spacingDenom;
        if (this.spacingRemainder > this.spacingDenom) {
            this.spacingRemainder -= this.spacingDenom;
            ++advance;
        }
        if (this.axis == X_AXIS) {
            c.setBounds(this.curPos + this.insets.left, opposedPos + this.insets.top, space, opposedSize);
            this.curPos += space + advance;
        } else {
            c.setBounds(opposedPos + this.insets.left, this.curPos + this.insets.top, opposedSize, space);
            this.curPos += space + advance;
        }
    }

    private void calcSizeReqs(Container target) {
        if (this.sizeReqsX == null || this.sizeReqsY == null) {
            Component[] components = target.getComponents();
            this.recalcSizeReqs(components);
        }
    }

    private void calcSizeReqs(Component[] components) {
        if (this.sizeReqsX == null || this.sizeReqsY == null) {
            this.recalcSizeReqs(components);
        }
    }

    private void recalcSizeReqs(Component[] components) {
        int i;
        int extra = this.componentSpacing != 0 && components.length != 0 ? 1 : 0;
        this.sizeReqsX = new SizeRequirements[components.length + extra];
        this.sizeReqsY = new SizeRequirements[components.length + extra];
        this.totalReqsX = new SizeRequirements(0, 0, 0, 0.5f);
        this.totalReqsY = new SizeRequirements(0, 0, 0, 0.5f);
        this.visibleCount = 0;
        for (i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component.isVisible()) {
                ++this.visibleCount;
                Dimension min = component.getMinimumSize();
                Dimension pref = component.getPreferredSize();
                Dimension max = component.getMaximumSize();
                this.sizeReqsX[i] = new SizeRequirements(min.width, pref.width, max.width, component.getAlignmentX());
                this.sizeReqsY[i] = new SizeRequirements(min.height, pref.height, max.height, component.getAlignmentY());
                if (this.isXPrimaryAxis()) {
                    this.addReqs(this.totalReqsX, this.sizeReqsX[i]);
                    this.maxReq(this.totalReqsY, this.sizeReqsY[i]);
                    continue;
                }
                this.addReqs(this.totalReqsY, this.sizeReqsY[i]);
                this.maxReq(this.totalReqsX, this.sizeReqsX[i]);
                continue;
            }
            this.sizeReqsX[i] = noSize;
            this.sizeReqsY[i] = noSize;
        }
        if (this.visibleCount > 1 && this.componentSpacing != 0) {
            this.needSpaces = true;
            this.sizeReqsX[i] = new SizeRequirements();
            this.sizeReqsY[i] = new SizeRequirements();
            int minSpacing = (this.visibleCount - 1) * this.minComponentSpacing;
            int spacing = (this.visibleCount - 1) * this.componentSpacing;
            if (this.isXPrimaryAxis()) {
                this.sizeReqsX[i].minimum = minSpacing;
                this.sizeReqsX[i].preferred = spacing;
                this.sizeReqsX[i].maximum = spacing;
                this.addReqs(this.totalReqsX, this.sizeReqsX[i]);
            } else {
                this.sizeReqsY[i].minimum = minSpacing;
                this.sizeReqsY[i].preferred = spacing;
                this.sizeReqsY[i].maximum = spacing;
                this.addReqs(this.totalReqsY, this.sizeReqsY[i]);
            }
        } else {
            this.needSpaces = false;
        }
    }

    private Dimension adjustSizeForInsets(Dimension d, Insets insets) {
        d.width = (int)Math.min((long)d.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        d.height = (int)Math.min((long)d.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return d;
    }

    private void addReqs(SizeRequirements a, SizeRequirements b) {
        a.minimum = this.restrictedAdd(a.minimum, b.minimum);
        a.preferred = this.restrictedAdd(a.preferred, b.preferred);
        a.maximum = this.restrictedAdd(a.maximum, b.maximum);
    }

    private int restrictedAdd(int a, int b) {
        return (int)Math.min((long)a + (long)b, Integer.MAX_VALUE);
    }

    private void maxReq(SizeRequirements a, SizeRequirements b) {
        a.minimum = Math.max(a.minimum, b.minimum);
        a.preferred = Math.max(a.preferred, b.preferred);
        a.maximum = Math.max(a.maximum, b.maximum);
    }

    private int getASize(Dimension d) {
        if (this.axis == X_AXIS) {
            return d.width;
        }
        return d.height;
    }

    private int getBSize(Dimension d) {
        if (this.axis == X_AXIS) {
            return d.height;
        }
        return d.width;
    }

    private float getOpposedAlignment(Component component) {
        if (this.axis == X_AXIS) {
            return component.getAlignmentY();
        }
        return component.getAlignmentX();
    }

    private SizeRequirements copySizeReqs(SizeRequirements src) {
        return new SizeRequirements(src.minimum, src.preferred, src.maximum, src.alignment);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
        this.sizeReqsX = null;
        this.sizeReqsY = null;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension minimumLayoutSize(Container parent) {
        this.calcSizeReqs(parent);
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(this.totalReqsX.minimum, this.totalReqsY.minimum);
        return this.adjustSizeForInsets(d, insets);
    }

    public Dimension preferredLayoutSize(Container parent) {
        this.calcSizeReqs(parent);
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(this.totalReqsX.preferred, this.totalReqsY.preferred);
        return this.adjustSizeForInsets(d, insets);
    }

    public Dimension maximumLayoutSize(Container parent) {
        this.calcSizeReqs(parent);
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(this.totalReqsX.maximum, this.totalReqsY.maximum);
        return this.adjustSizeForInsets(d, insets);
    }

    public void layoutContainer(Container parent) {
        int i;
        boolean needAnotherPass;
        SizeRequirements totalSizeReqs;
        SizeRequirements[] opposedReqs;
        SizeRequirements[] sizeReqs;
        Component[] components = parent.getComponents();
        if (components.length == 0) {
            return;
        }
        this.calcSizeReqs(components);
        this.insets = parent.getInsets();
        Dimension parentSize = parent.getSize();
        int availSize = this.getASize(parentSize);
        int opposedSize = this.getBSize(parentSize);
        if (this.isXPrimaryAxis()) {
            sizeReqs = this.sizeReqsX;
            opposedReqs = this.sizeReqsY;
            totalSizeReqs = this.copySizeReqs(this.totalReqsX);
            availSize -= this.insets.left + this.insets.right;
            opposedSize -= this.insets.top + this.insets.bottom;
        } else {
            sizeReqs = this.sizeReqsY;
            opposedReqs = this.sizeReqsX;
            totalSizeReqs = this.copySizeReqs(this.totalReqsY);
            availSize -= this.insets.top + this.insets.bottom;
            opposedSize -= this.insets.left + this.insets.right;
        }
        int numComponents = components.length + (this.needSpaces ? 1 : 0);
        int[] space = new int[numComponents];
        int[] diffs = new int[numComponents];
        boolean[] fixed = new boolean[numComponents];
        if (this.needSpaces) {
            int minSpace = this.minComponentSpacing * (this.visibleCount - 1);
            int prefSpace = this.componentSpacing * (this.visibleCount - 1);
            SizeRequirements spaceReqs = sizeReqs[numComponents - 1];
            totalSizeReqs.minimum += minSpace - spaceReqs.minimum;
            totalSizeReqs.preferred += prefSpace - spaceReqs.preferred;
            totalSizeReqs.maximum += prefSpace - spaceReqs.maximum;
            spaceReqs.minimum = minSpace;
            spaceReqs.preferred = prefSpace;
            spaceReqs.maximum = prefSpace;
        }
        if (totalSizeReqs.maximum < availSize) {
            this.curPos = (availSize - totalSizeReqs.maximum) / 2;
            availSize = totalSizeReqs.maximum;
        } else {
            this.curPos = 0;
        }
        block0: do {
            int i2;
            needAnotherPass = false;
            if (totalSizeReqs.minimum >= availSize) {
                for (i = 0; i < numComponents; ++i) {
                    space[i] = sizeReqs[i].minimum;
                }
            } else if (totalSizeReqs.preferred >= availSize) {
                if (this.needSpaces) {
                    SizeRequirements spaceReqs = sizeReqs[numComponents - 1];
                    int diff = spaceReqs.preferred - spaceReqs.minimum;
                    if (diff + availSize >= totalSizeReqs.preferred) {
                        spaceReqs.preferred -= totalSizeReqs.preferred - availSize;
                        totalSizeReqs.preferred = availSize;
                    } else {
                        spaceReqs.preferred = spaceReqs.minimum;
                        totalSizeReqs.preferred -= diff;
                    }
                }
                int totalDiffs = 0;
                int discrepancy = availSize - totalSizeReqs.minimum;
                for (i2 = 0; i2 < numComponents; ++i2) {
                    if (fixed[i2]) continue;
                    diffs[i2] = sizeReqs[i2].preferred - sizeReqs[i2].minimum;
                    totalDiffs += diffs[i2];
                }
                for (i2 = 0; i2 < numComponents; ++i2) {
                    if (fixed[i2]) continue;
                    if (diffs[i2] != 0) {
                        space[i2] = (int)((long)sizeReqs[i2].minimum + (long)diffs[i2] * (long)discrepancy / (long)totalDiffs);
                    } else {
                        space[i2] = sizeReqs[i2].minimum;
                        fixed[i2] = true;
                    }
                    if (space[i2] <= sizeReqs[i2].maximum) continue;
                    space[i2] = sizeReqs[i2].maximum;
                    totalSizeReqs.minimum -= sizeReqs[i2].minimum;
                    totalSizeReqs.preferred -= sizeReqs[i2].preferred;
                    totalSizeReqs.maximum -= sizeReqs[i2].maximum;
                    fixed[i2] = true;
                    availSize -= space[i2];
                    needAnotherPass = true;
                    continue block0;
                }
            } else if (totalSizeReqs.preferred == 0) {
                int numComponentsLeft = 0;
                int unassignedSpace = availSize;
                for (i2 = 0; i2 < numComponents; ++i2) {
                    if (fixed[i2]) continue;
                    ++numComponentsLeft;
                    unassignedSpace -= sizeReqs[i2].preferred;
                }
                for (i2 = 0; i2 < numComponents; ++i2) {
                    if (fixed[i2]) continue;
                    int toAssign = unassignedSpace / numComponentsLeft;
                    space[i2] = this.restrictedAdd(sizeReqs[i2].preferred, toAssign);
                    if (space[i2] <= sizeReqs[i2].maximum) continue;
                    space[i2] = sizeReqs[i2].maximum;
                    totalSizeReqs.minimum -= sizeReqs[i2].minimum;
                    totalSizeReqs.preferred -= sizeReqs[i2].preferred;
                    totalSizeReqs.maximum -= sizeReqs[i2].maximum;
                    fixed[i2] = true;
                    availSize -= space[i2];
                    needAnotherPass = true;
                    continue block0;
                }
            } else {
                for (i = 0; i < numComponents; ++i) {
                    if (fixed[i]) continue;
                    space[i] = (int)((long)sizeReqs[i].preferred * (long)availSize / (long)totalSizeReqs.preferred);
                    if (space[i] <= sizeReqs[i].maximum) continue;
                    space[i] = sizeReqs[i].maximum;
                    totalSizeReqs.minimum -= sizeReqs[i].minimum;
                    totalSizeReqs.preferred -= sizeReqs[i].preferred;
                    totalSizeReqs.maximum -= sizeReqs[i].maximum;
                    fixed[i] = true;
                    availSize -= space[i];
                    needAnotherPass = true;
                    continue block0;
                }
            }
        } while (needAnotherPass);
        if (this.needSpaces) {
            this.spacingNumerator = space[numComponents - 1];
            this.spacingDenom = this.visibleCount - 1;
        } else {
            this.spacingNumerator = 0;
            this.spacingDenom = 1;
        }
        this.spacingRemainder = 0;
        for (i = 0; i < components.length; ++i) {
            if (!components[i].isVisible()) continue;
            if (opposedReqs[i].maximum < opposedSize) {
                float alignment = this.getOpposedAlignment(components[i]);
                int offset = (int)((float)(opposedSize - opposedReqs[i].maximum) * alignment);
                this.placeComponent(components[i], space[i], offset, opposedReqs[i].maximum);
                continue;
            }
            this.placeComponent(components[i], space[i], 0, opposedSize);
        }
    }
}

