/*
 * Decompiled with CFR 0.152.
 */
package bluej.testmgr.record;

import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.testmgr.record.VoidMethodInvokerRecord;
import bluej.utility.JavaNames;

public class MethodInvokerRecord
extends VoidMethodInvokerRecord {
    private JavaType returnType;
    private String benchType;
    protected String benchName;
    private int usageCount;
    private boolean methodCallInited = false;
    private PkgMgrFrame pkgMgrFrame;

    public MethodInvokerRecord(JavaType returnType, String command, String[] argumentValues, PkgMgrFrame pkgMgrFrame) {
        super(command, argumentValues);
        this.returnType = returnType;
        this.benchType = returnType.toString(false);
        this.benchName = null;
        this.pkgMgrFrame = pkgMgrFrame;
    }

    public void setBenchName(String name, String type) {
        this.benchName = name;
        this.benchType = type;
    }

    public String toFixtureDeclaration() {
        if (this.benchName == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\tprivate ");
        sb.append(this.benchDeclaration());
        sb.append(this.benchName);
        sb.append(";\n");
        return sb.toString();
    }

    public String toFixtureSetup() {
        if (this.benchName == null) {
            return "\t\t" + this.command + ";\n";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\t\t");
        sb.append(this.benchAssignmentTypecast());
        sb.append(";\n");
        return sb.toString();
    }

    public String toTestMethod() {
        String resultRef = this.toExpression();
        if (this.getUsageCount() == 0) {
            return "\t\t" + resultRef + ";\n";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getAssertionCount(); ++i) {
            sb.append("\t\t");
            sb.append(MethodInvokerRecord.insertCommandIntoAssertionStatement(this.getAssertion(i), resultRef));
            sb.append(";\n");
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toTestMethodInit() {
        if (this.methodCallInited) {
            return "";
        }
        if (this.benchName == null) {
            if (this.getUsageCount() <= 1) return "";
            DebuggerObject result = this.getResultObject();
            assert (result != null);
            ObjectBench bench = this.pkgMgrFrame.getObjectBench();
            ObjectWrapper wrapper = ObjectWrapper.getWrapper(this.pkgMgrFrame, bench, result, result.getGenType(), "result");
            bench.addObject(wrapper);
            this.benchName = wrapper.getName();
        } else {
            this.incUsageCount();
        }
        assert (this.benchName != null);
        this.methodCallInited = true;
        return "\t\t" + this.benchDeclaration() + this.benchAssignmentTypecast() + ";\n";
    }

    public String toExpression() {
        assert (this.methodCallInited);
        if (this.benchName == null) {
            return this.command;
        }
        return this.benchName;
    }

    public String getExpressionGlue() {
        if (this.returnType instanceof GenTypeArray) {
            return "";
        }
        return ".";
    }

    private String benchDeclaration() {
        return JavaNames.typeName(this.benchType) + " ";
    }

    protected String benchAssignmentTypecast() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.benchName);
        sb.append(" = ");
        if (!this.benchType.equals(this.returnType.toString(false))) {
            sb.append("(");
            sb.append(this.benchType);
            sb.append(")");
        }
        sb.append(this.command);
        return sb.toString();
    }

    public void addAssertion(String assertion) {
        super.addAssertion(assertion);
        ++this.usageCount;
    }

    public void incUsageCount() {
        ++this.usageCount;
    }

    private int getUsageCount() {
        return this.usageCount;
    }
}

