/*
 * Decompiled with CFR 0.152.
 */
package bluej.testmgr;

import bluej.Config;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CounterPanel
extends JPanel {
    private JLabel fNumberOfErrors = this.createOutputField(5);
    private JLabel fNumberOfFailures = this.createOutputField(5);
    private JLabel fNumberOfRuns = this.createOutputField(9);
    static final Icon fFailureIcon = Config.getImageAsIcon("image.testmgr.failure");
    static final Icon fErrorIcon = Config.getImageAsIcon("image.testmgr.error");
    private int fTotal;

    public CounterPanel() {
        super(new GridBagLayout());
        this.addToGrid(new JLabel(Config.getString("testdisplay.counter.runs"), 0), 0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0));
        this.addToGrid(this.fNumberOfRuns, 1, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
        this.addToGrid(new JLabel(Config.getString("testdisplay.counter.errors"), fErrorIcon, 2), 2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToGrid(this.fNumberOfErrors, 3, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
        this.addToGrid(new JLabel(Config.getString("testdisplay.counter.failures"), fFailureIcon, 2), 4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToGrid(this.fNumberOfFailures, 5, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
        this.setMaximumSize(new Dimension(this.getMaximumSize().width, this.getPreferredSize().height));
    }

    private JLabel createOutputField(int width) {
        JLabel field = new JLabel("0");
        Dimension size = field.getMinimumSize();
        size.width *= width;
        field.setMinimumSize(size);
        return field;
    }

    public void addToGrid(Component comp, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.anchor = anchor;
        constraints.fill = fill;
        constraints.insets = insets;
        this.add(comp, constraints);
    }

    public void reset() {
        this.setLabelValue(this.fNumberOfErrors, 0);
        this.setLabelValue(this.fNumberOfFailures, 0);
        this.setLabelValue(this.fNumberOfRuns, 0);
        this.fTotal = 0;
    }

    public void setTotal(int value) {
        this.fTotal = value;
    }

    public void setRunValue(int value) {
        this.fNumberOfRuns.setText(Integer.toString(value) + "/" + this.fTotal);
    }

    public void setErrorValue(int value) {
        this.setLabelValue(this.fNumberOfErrors, value);
    }

    public void setFailureValue(int value) {
        this.setLabelValue(this.fNumberOfFailures, value);
    }

    private void setLabelValue(JLabel label, int value) {
        label.setText(Integer.toString(value));
    }
}

