/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.filefilter.DirectoryFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MiscPrefPanel
extends JPanel
implements PrefPanelListener,
ItemListener,
ActionListener {
    private static final String bluejJdkURL = "bluej.url.javaStdLib";
    private static final String greenfootJdkURL = "greenfoot.url.javaStdLib";
    private static final String toolkitDir = "bluej.javame.toolkit.dir";
    private JLabel toolkitDirLabel;
    private JButton toolkitBrowseButton;
    private JTextField jdkURLField;
    private JTextField toolkitDirField;
    private JCheckBox linkToLibBox;
    private JCheckBox showUncheckedBox;
    private JCheckBox showTestBox;
    private JCheckBox showTeamBox;
    private JCheckBox showJavaMEBox;
    private String jdkURLPropertyName = Config.isGreenfoot() ? "greenfoot.url.javaStdLib" : "bluej.url.javaStdLib";
    private JPanel toolkitPanel;

    public MiscPrefPanel() {
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        this.add(box);
        this.setBorder(BlueJTheme.generalBorder);
        box.add(Box.createVerticalGlue());
        JPanel docPanel = new JPanel();
        docPanel.setLayout(new BoxLayout(docPanel, 1));
        String docTitle = Config.getString("prefmgr.misc.documentation.title");
        docPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(docTitle), BlueJTheme.generalBorder));
        docPanel.setAlignmentX(0.0f);
        JPanel urlPanel = new JPanel(new BorderLayout(5, 0));
        urlPanel.add((Component)new JLabel(Config.getString("prefmgr.misc.jdkurlpath")), "West");
        this.jdkURLField = new JTextField(32);
        urlPanel.add((Component)this.jdkURLField, "Center");
        urlPanel.setAlignmentX(0.0f);
        docPanel.add(urlPanel);
        docPanel.add(Box.createVerticalStrut(5));
        this.linkToLibBox = new JCheckBox(Config.getString("prefmgr.misc.linkToLib"));
        this.linkToLibBox.setAlignmentX(0.0f);
        docPanel.add(this.linkToLibBox);
        docPanel.add(Box.createVerticalStrut(5));
        JLabel linkToLibNoteLine1 = new JLabel(Config.getString("prefmgr.misc.linkToLibNoteLine1"));
        Font smallFont = linkToLibNoteLine1.getFont().deriveFont(10);
        linkToLibNoteLine1.setFont(smallFont);
        linkToLibNoteLine1.setAlignmentX(0.0f);
        docPanel.add(linkToLibNoteLine1);
        JLabel linkToLibNoteLine2 = new JLabel(Config.getString("prefmgr.misc.linkToLibNoteLine2"));
        linkToLibNoteLine2.setFont(smallFont);
        linkToLibNoteLine2.setAlignmentX(0.0f);
        docPanel.add(linkToLibNoteLine2);
        box.add(docPanel);
        if (!Config.isGreenfoot()) {
            box.add(Box.createVerticalStrut(5));
            JPanel testPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            testPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("prefmgr.misc.tools.title")), BlueJTheme.generalBorder));
            testPanel.setAlignmentX(0.0f);
            this.showTestBox = new JCheckBox(Config.getString("prefmgr.misc.showTesting"));
            testPanel.add(this.showTestBox);
            this.showTeamBox = new JCheckBox(Config.getString("prefmgr.misc.showTeam"));
            testPanel.add(this.showTeamBox);
            this.showJavaMEBox = new JCheckBox(Config.getString("prefmgr.misc.showJavaME"));
            testPanel.add(this.showJavaMEBox);
            this.toolkitPanel = new JPanel(new BorderLayout(5, 0));
            this.toolkitDirLabel = new JLabel(Config.getString("prefmgr.misc.wtk.dir.label"));
            this.toolkitDirField = new JTextField();
            this.toolkitBrowseButton = new JButton(Config.getString("prefmgr.misc.wtk.button"));
            this.toolkitPanel.add((Component)this.toolkitDirLabel, "West");
            this.toolkitPanel.add((Component)this.toolkitDirField, "Center");
            this.toolkitPanel.add((Component)this.toolkitBrowseButton, "East");
            testPanel.add(this.toolkitPanel);
            box.add(testPanel);
            box.add(Box.createVerticalStrut(5));
            JPanel vmPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            vmPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("prefmgr.misc.vm.title")), BlueJTheme.generalBorder));
            vmPanel.setAlignmentX(0.0f);
            this.showUncheckedBox = new JCheckBox(Config.getString("prefmgr.misc.showUnchecked"));
            if (Config.isJava15()) {
                vmPanel.add(this.showUncheckedBox);
            }
            box.add(vmPanel);
        }
        box.add(Box.createVerticalStrut(5));
    }

    public void beginEditing() {
        this.linkToLibBox.setSelected(PrefMgr.getFlag("doctool.linkToStandardLib"));
        this.jdkURLField.setText(Config.getPropString(this.jdkURLPropertyName));
        if (!Config.isGreenfoot()) {
            this.showTestBox.setSelected(PrefMgr.getFlag("bluej.testing.showtools"));
            this.showTeamBox.setSelected(PrefMgr.getFlag("bluej.teamwork.showtools"));
            this.showJavaMEBox.setSelected(PrefMgr.getFlag("bluej.javame.showtools"));
            this.showUncheckedBox.setSelected(PrefMgr.getFlag("bluej.compiler.showunchecked"));
            if (this.showJavaMEBox.isSelected()) {
                this.toolkitDirField.setText(Config.getPropString(toolkitDir, ""));
                this.enableToolkitPanel(true);
            } else {
                this.toolkitDirField.setText("");
                this.enableToolkitPanel(false);
            }
            this.showJavaMEBox.addItemListener(this);
            this.toolkitBrowseButton.addActionListener(this);
        }
    }

    public void revertEditing() {
    }

    public void commitEditing() {
        PrefMgr.setFlag("doctool.linkToStandardLib", this.linkToLibBox.isSelected());
        if (!Config.isGreenfoot()) {
            PrefMgr.setFlag("bluej.testing.showtools", this.showTestBox.isSelected());
            PrefMgr.setFlag("bluej.teamwork.showtools", this.showTeamBox.isSelected());
            PrefMgr.setFlag("bluej.javame.showtools", this.showJavaMEBox.isSelected());
            PrefMgr.setFlag("bluej.compiler.showunchecked", this.showUncheckedBox.isSelected());
            PkgMgrFrame.updateTestingStatus();
            PkgMgrFrame.updateTeamStatus();
            PkgMgrFrame.updateJavaMEstatus();
        }
        String jdkURL = this.jdkURLField.getText();
        Config.putPropString(this.jdkURLPropertyName, jdkURL);
        String tkDir = this.toolkitDirField.getText();
        if (!tkDir.equals("")) {
            Config.putPropString(toolkitDir, tkDir);
        }
    }

    private void enableToolkitPanel(boolean b) {
        this.toolkitDirLabel.setEnabled(b);
        this.toolkitDirField.setEnabled(b);
        this.toolkitBrowseButton.setEnabled(b);
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.enableToolkitPanel(true);
            String toolkitDirectory = this.tryToFindToolkit();
            if (toolkitDirectory.equals("")) {
                this.letUserChooseToolkitDir();
            } else {
                this.toolkitDirField.setText(toolkitDirectory);
            }
        } else {
            this.enableToolkitPanel(false);
            this.toolkitDirField.setText("");
        }
    }

    private String tryToFindToolkit() {
        File[] roots = new File[]{new File(System.getProperty("user.home")), new File("/usr/local"), new File("/usr/lib")};
        if (Config.isWinOS()) {
            roots = File.listRoots();
        }
        for (int i = 0; i < roots.length; ++i) {
            File[] dirs = roots[i].listFiles(new DirectoryFilter());
            if (dirs == null) continue;
            for (int j = 0; j < dirs.length; ++j) {
                if (!this.isToolkitDirectory(dirs[j])) continue;
                return dirs[j].toString();
            }
        }
        return "";
    }

    private boolean isToolkitDirectory(File dirToCheck) {
        File file = new File(dirToCheck, "bin");
        if (file.isDirectory()) {
            File emulatorInLinux = new File(file, "emulator");
            File emulatorInWindows = new File(file, "emulator.exe");
            if (!emulatorInWindows.exists() && !emulatorInLinux.exists()) {
                return false;
            }
        } else {
            return false;
        }
        file = new File(dirToCheck, "lib");
        File anotherFile = new File(dirToCheck, "docs");
        return file.isDirectory() && anotherFile.isDirectory();
    }

    public void actionPerformed(ActionEvent e) {
        this.letUserChooseToolkitDir();
    }

    private void letUserChooseToolkitDir() {
        String s;
        String toolkitDirectory = "";
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(Config.getString("prefmgr.misc.filechooser.title"));
        int returnVal = chooser.showOpenDialog(this.getParent());
        if (returnVal == 0) {
            toolkitDirectory = chooser.getSelectedFile().toString();
            this.toolkitDirField.setText(toolkitDirectory);
        } else if (returnVal == 1 && (s = this.toolkitDirField.getText().trim()).equals("")) {
            this.showJavaMEBox.setSelected(false);
            this.enableToolkitPanel(false);
        }
    }
}

