/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.graphPainter;

import bluej.pkgmgr.graphPainter.GraphPainterStdImpl;
import bluej.pkgmgr.target.Target;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;

public class ReadmeTargetPainter {
    private static final int CORNER_SIZE = 11;

    public void paint(Graphics2D g, Target target, boolean hasFocus) {
        g.translate(target.getX(), target.getY());
        int width = target.getWidth();
        int height = target.getHeight();
        this.drawShadow(g, width, height);
        int[] xpoints = new int[]{1, width - 11, width, width, 1};
        int[] ypoints = new int[]{1, 1, 12, height, height};
        Polygon p = new Polygon(xpoints, ypoints, 5);
        boolean isSelected = target.isSelected() && hasFocus;
        int thickness = isSelected ? 2 : 1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(Color.WHITE);
        g.fill(p);
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(thickness));
        g.draw(p);
        g.drawLine(width - 11, 1, width - 11, 11);
        g.drawLine(width - 11, 11, width - 2, 11);
        g.setStroke(new BasicStroke(1.0f));
        for (int yPos = 21; yPos <= height - 10; yPos += 5) {
            g.drawLine(10, yPos, width - 10, yPos);
        }
        g.translate(-target.getX(), -target.getY());
    }

    private void drawShadow(Graphics2D g, int width, int height) {
        g.setColor(GraphPainterStdImpl.shadowColours[3]);
        g.drawLine(3, height, width, height);
        g.setColor(GraphPainterStdImpl.shadowColours[2]);
        g.drawLine(4, height + 1, width, height + 1);
        g.drawLine(width + 1, height + 2, width + 1, 14);
        g.setColor(GraphPainterStdImpl.shadowColours[1]);
        g.drawLine(5, height + 2, width + 1, height + 2);
        g.drawLine(width + 2, height + 3, width + 2, 15);
        g.setColor(GraphPainterStdImpl.shadowColours[0]);
        g.drawLine(6, height + 3, width + 2, height + 3);
        g.drawLine(width + 3, height + 3, width + 3, 16);
    }
}

