/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.Boot;
import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugmgr.ExecControls;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.inspector.ClassInspector;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.debugmgr.inspector.ObjectInspector;
import bluej.debugmgr.inspector.ResultInspector;
import bluej.editor.Editor;
import bluej.extensions.BProject;
import bluej.extensions.ExtensionBridge;
import bluej.extmgr.ExtensionsManager;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.actions.TeamActionGroup;
import bluej.groupwork.ui.CommitCommentsFrame;
import bluej.groupwork.ui.StatusFrame;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.groupwork.ui.UpdateFilesFrame;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.DocuGenerator;
import bluej.pkgmgr.MIDletDeployer;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PackageFile;
import bluej.pkgmgr.PackageFileFactory;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.terminal.Terminal;
import bluej.testmgr.record.ClassInspectInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.View;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JFrame;

public class Project
implements DebuggerListener,
InspectorManager {
    private static Map projects = new HashMap();
    public static final int NEW_PACKAGE_DONE = 0;
    public static final int NEW_PACKAGE_EXIST = 1;
    public static final int NEW_PACKAGE_BAD_NAME = 2;
    public static final int NEW_PACKAGE_NO_PARENT = 3;
    public static final String projectLibDirName = "+libs";
    private File projectDir;
    private Map<String, Package> packages;
    private Debugger debugger;
    private ExecControls execControls = null;
    private Terminal terminal = null;
    private DocuGenerator docuGenerator;
    private String initialPackageName = "";
    private Map inspectors;
    private boolean inTestMode = false;
    private BPClassLoader currentClassLoader;
    private TeamSettingsController teamSettingsController = null;
    private CommitCommentsFrame commitCommentsFrame = null;
    private UpdateFilesFrame updateFilesFrame = null;
    private StatusFrame statusFrame = null;
    private boolean isSharedProject;
    private TeamActionGroup teamActions;
    private boolean isJavaMEproject = false;
    private BProject singleBProject;

    private Project(File projectDir) {
        if (projectDir == null) {
            throw new NullPointerException();
        }
        Debug.log("Opening project: " + projectDir.toString());
        this.projectDir = projectDir;
        this.inspectors = new HashMap();
        this.packages = new TreeMap<String, Package>();
        try {
            this.packages.put("", new Package(this));
        }
        catch (IOException exc) {
            Debug.reportError("could not read package file (unnamed package)");
        }
        this.debugger = Debugger.getDebuggerImpl(this.getProjectDir(), this.getTerminal());
        this.debugger.newClassLoader(this.getClassLoader());
        this.debugger.addDebuggerListener(this);
        this.debugger.launch();
        this.docuGenerator = new DocuGenerator(this);
        File ccfFile = new File(projectDir.getAbsoluteFile(), "team.defs");
        this.isSharedProject = ccfFile.isFile();
        this.teamActions = new TeamActionGroup(this.isSharedProject);
    }

    public static boolean isProject(String projectPath) {
        File startingDir;
        try {
            startingDir = Project.pathIntoStartingDirectory(projectPath);
        }
        catch (IOException ioe) {
            return false;
        }
        if (startingDir == null) {
            return false;
        }
        return Package.isBlueJPackage(startingDir);
    }

    public static Project openProject(String projectPath) {
        File projectDir;
        String startingPackageName;
        File startingDir;
        try {
            startingDir = Project.pathIntoStartingDirectory(projectPath);
        }
        catch (IOException ioe) {
            Debug.message("could not resolve directory " + projectPath);
            return null;
        }
        if (startingDir == null) {
            return null;
        }
        if (Package.isBlueJPackage(startingDir)) {
            File lastDir = null;
            startingPackageName = "";
            for (File curDir = startingDir; curDir != null && Package.isBlueJPackage(curDir); curDir = curDir.getParentFile()) {
                if (lastDir != null) {
                    String lastdirName = lastDir.getName();
                    if (!JavaNames.isIdentifier(lastdirName)) break;
                    startingPackageName = "." + lastdirName + startingPackageName;
                }
                lastDir = curDir;
            }
            if (startingPackageName.length() > 0 && startingPackageName.charAt(0) == '.') {
                startingPackageName = startingPackageName.substring(1);
            }
            if ((projectDir = lastDir) == null) {
                projectDir = startingDir;
            }
        } else {
            return null;
        }
        Project proj = (Project)projects.get(projectDir);
        if (proj == null) {
            proj = new Project(projectDir);
            projects.put(projectDir, proj);
        }
        if (startingPackageName.equals("")) {
            Package sub;
            Package startingPackage = proj.getPackage("");
            while (startingPackage != null && (sub = startingPackage.getBoringSubPackage()) != null) {
                startingPackage = sub;
            }
            proj.initialPackageName = startingPackage.getQualifiedName();
        } else {
            proj.initialPackageName = startingPackageName;
        }
        ExtensionsManager.getInstance().projectOpening(proj);
        return proj;
    }

    public static void cleanUp(Project project) {
        if (project.hasExecControls()) {
            project.getExecControls().dispose();
        }
        if (project.terminal != null) {
            project.terminal.dispose();
        }
        project.removeAllInspectors();
        project.getDebugger().removeDebuggerListener(project);
        project.getDebugger().close(false);
        PrefMgr.addRecentProject(project.getProjectDir().getAbsolutePath());
        projects.remove(project.getProjectDir());
    }

    public static boolean createNewProject(String projectPath, boolean isJavaMEproj) {
        if (projectPath != null) {
            File dir = new File(projectPath);
            if (dir.exists()) {
                return false;
            }
            if (dir.mkdir()) {
                File iconsDirectory;
                File newreadmeFile = new File(dir, "README.TXT");
                if (isJavaMEproj && (iconsDirectory = new File(dir, MIDletDeployer.ICONS_DIR)).mkdirs()) {
                    File defaultMidletIconFile = new File(iconsDirectory, "default.gif");
                    File iconDefaultSource = new File(Config.getBlueJLibDir(), MIDletDeployer.DEFAULT_LIB_ME_ICON);
                    try {
                        FileUtility.copyFile(iconDefaultSource, defaultMidletIconFile);
                    }
                    catch (IOException ioe) {
                        Debug.reportError("Could not copy default icon file into Project directory.");
                    }
                }
                PackageFile pkgFile = PackageFileFactory.getPackageFile(dir);
                try {
                    if (pkgFile.create()) {
                        try {
                            FileUtility.copyFile(Config.getTemplateFile("readme"), newreadmeFile);
                            return true;
                        }
                        catch (IOException ioe) {
                            Debug.message("could not copy readme template");
                        }
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static int getOpenProjectCount() {
        return projects.size();
    }

    public static Collection getProjects() {
        return projects.values();
    }

    public static Project getProject(File projectKey) {
        return (Project)projects.get(projectKey);
    }

    public static boolean isBlueJProject(String projectPath) {
        File startingDir = null;
        try {
            startingDir = Project.pathIntoStartingDirectory(projectPath);
        }
        catch (IOException ioe) {
            return false;
        }
        if (startingDir == null) {
            return false;
        }
        return Package.isBlueJPackage(startingDir);
    }

    void setJavaMEproject(boolean isMicroEdition) {
        this.isJavaMEproject = isMicroEdition;
    }

    private static File pathIntoStartingDirectory(String projectPath) throws IOException {
        File startingDir = new File(projectPath).getCanonicalFile();
        if (startingDir.isDirectory()) {
            return startingDir;
        }
        if (startingDir.isFile() && BlueJPackageFile.isPackageFileName(startingDir.getName())) {
            return startingDir.getParentFile();
        }
        return null;
    }

    private void updateInspector(final Inspector inspector) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                inspector.update();
                inspector.updateLayout();
                inspector.setVisible(true);
                inspector.bringToFront();
            }
        });
    }

    public ObjectInspector getInspectorInstance(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, JFrame parent) {
        ObjectInspector inspector = (ObjectInspector)this.inspectors.get(obj);
        if (inspector == null) {
            inspector = new ObjectInspector(obj, this, name, pkg, ir, parent);
            this.inspectors.put(obj, inspector);
        }
        this.updateInspector(inspector);
        return inspector;
    }

    public Inspector getInspector(Object obj) {
        return (Inspector)this.inspectors.get(obj);
    }

    public void removeInspector(DebuggerObject obj) {
        this.inspectors.remove(obj);
    }

    public void removeInspector(DebuggerClass cls) {
        this.inspectors.remove(cls.getName());
    }

    public void removeInspectorInstance(Object obj) {
        Inspector inspect = this.getInspector(obj);
        if (inspect != null) {
            inspect.doClose(false);
        }
    }

    public void removeAllInspectors() {
        for (Inspector inspector : this.inspectors.values()) {
            inspector.setVisible(false);
            inspector.dispose();
        }
        this.inspectors.clear();
    }

    public ClassInspector getClassInspectorInstance(DebuggerClass clss, Package pkg, JFrame parent) {
        ClassInspector inspector = (ClassInspector)this.inspectors.get(clss.getName());
        if (inspector == null) {
            ClassInspectInvokerRecord ir = new ClassInspectInvokerRecord(clss.getName());
            inspector = new ClassInspector(clss, this, pkg, ir, parent);
            this.inspectors.put(clss.getName(), inspector);
        }
        this.updateInspector(inspector);
        return inspector;
    }

    public ResultInspector getResultInspectorInstance(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, ExpressionInformation info, JFrame parent) {
        ResultInspector inspector = new ResultInspector(obj, this, name, pkg, ir, info, parent);
        this.inspectors.put(obj, inspector);
        this.updateInspector(inspector);
        return inspector;
    }

    public void updateInspectors() {
        for (Inspector inspector : this.inspectors.values()) {
            inspector.update();
        }
    }

    public String getProjectName() {
        return this.projectDir.getName();
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public Repository getRepository() {
        if (this.isSharedProject) {
            return this.getTeamSettingsController().getRepository(true);
        }
        return null;
    }

    public boolean isReadOnly() {
        return !this.projectDir.canWrite();
    }

    public String getUniqueId() {
        return String.valueOf(new String("BJID" + this.getProjectDir().getPath()).hashCode());
    }

    public String getInitialPackageName() {
        return this.initialPackageName;
    }

    public Package getPackage(String qualifiedName) {
        Package existing = this.packages.get(qualifiedName);
        if (existing != null) {
            return existing;
        }
        if (qualifiedName.length() > 0) {
            Package pkg;
            try {
                Package parent = this.getPackage(JavaNames.getPrefix(qualifiedName));
                if (parent != null) {
                    pkg = new Package(this, JavaNames.getBase(qualifiedName), parent);
                    this.packages.put(qualifiedName, pkg);
                } else {
                    pkg = null;
                }
            }
            catch (IOException exc) {
                pkg = null;
            }
            return pkg;
        }
        throw new IllegalStateException("Project.getPackage()");
    }

    public final synchronized BProject getBProject() {
        if (this.singleBProject == null) {
            this.singleBProject = ExtensionBridge.newBProject((Project)this);
        }
        return this.singleBProject;
    }

    public Package getCachedPackage(String qualifiedName) {
        return this.packages.get(qualifiedName);
    }

    public void createPackageDirectory(String fullName) {
        StringTokenizer st = new StringTokenizer(fullName, ".");
        File newPkgDir = this.getProjectDir();
        while (st.hasMoreTokens()) {
            newPkgDir = new File(newPkgDir, st.nextToken());
        }
        if (newPkgDir.isDirectory() || newPkgDir.mkdirs()) {
            st = new StringTokenizer(fullName, ".");
            newPkgDir = this.getProjectDir();
            PackageFile pkgFile = PackageFileFactory.getPackageFile(newPkgDir);
            try {
                pkgFile.create();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            while (st.hasMoreTokens()) {
                newPkgDir = new File(newPkgDir, st.nextToken());
                this.prepareCreateDir(newPkgDir);
                pkgFile = PackageFileFactory.getPackageFile(newPkgDir);
                try {
                    pkgFile.create();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public int newPackage(String qualifiedName) {
        if (qualifiedName == null) {
            return 2;
        }
        Package existing = this.packages.get(qualifiedName);
        if (existing != null) {
            return 1;
        }
        if (qualifiedName.length() < 1) {
            return 2;
        }
        try {
            Package parent = this.getPackage(JavaNames.getPrefix(qualifiedName));
            if (parent == null) {
                return 3;
            }
            this.createPackageDirectory(qualifiedName);
            Package pkg = new Package(this, JavaNames.getBase(qualifiedName), parent);
            this.packages.put(qualifiedName, pkg);
        }
        catch (IOException exc) {
            return 2;
        }
        return 0;
    }

    private List getPackageNames(Package rootPackage) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(rootPackage.getQualifiedName());
        List children = rootPackage.getChildren(true);
        for (Package p : children) {
            l.addAll(this.getPackageNames(p));
        }
        return l;
    }

    public List getPackageNames() {
        return this.getPackageNames(this.getPackage(""));
    }

    public String generateDocumentation() {
        return this.docuGenerator.generateProjectDocu();
    }

    public String getDocumentationFile(String filename) {
        return this.docuGenerator.getDocuPath(filename);
    }

    public void generateDocumentation(String filename) {
        this.docuGenerator.generateClassDocu(filename);
    }

    public void saveAll() {
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(this);
        if (frames == null) {
            return;
        }
        for (int i = 0; i < frames.length; ++i) {
            frames[i].doSave();
        }
    }

    public void saveAllEditors() {
        for (Package pkg : this.packages.values()) {
            try {
                pkg.saveFilesInEditors();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void saveAllGraphLayout() {
        for (Package pkg : this.packages.values()) {
            pkg.save(null);
        }
    }

    public void reloadAll() {
        for (Package pkg : this.packages.values()) {
            pkg.reload();
        }
    }

    public void clearAllSelections() {
        for (Package pkg : this.packages.values()) {
            PackageEditor editor = pkg.getEditor();
            if (editor == null) continue;
            editor.clearSelection();
        }
    }

    public void selectTargetsInGraphs(List targets) {
        for (Target target : targets) {
            if (target == null) continue;
            PackageEditor packageEditor = target.getPackage().getEditor();
            packageEditor.addToSelection(target);
            packageEditor.repaint();
        }
    }

    public Target getTarget(String targetId) {
        Package p;
        String packageName = "";
        int index = targetId.lastIndexOf(46);
        if (index > 0) {
            packageName = targetId.substring(0, index);
            targetId = targetId.substring(index + 1);
        }
        if ((p = this.getPackage(packageName)) == null) {
            return null;
        }
        Target target = p.getTarget(targetId);
        return target;
    }

    public void openEditorsForSelectedTargets() {
        List selectedTargets = this.getSelectedTargets();
        for (Target target : selectedTargets) {
            ClassTarget classTarget;
            Editor editor;
            if (!(target instanceof ClassTarget) || (editor = (classTarget = (ClassTarget)target).getEditor()) == null) continue;
            editor.setVisible(true);
        }
    }

    private List getSelectedTargets() {
        LinkedList<Target> selectedTargets = new LinkedList<Target>();
        List packageNames = this.getPackageNames();
        for (String packageName : packageNames) {
            Package p = this.getPackage(packageName);
            selectedTargets.addAll(Arrays.asList(p.getSelectedTargets()));
        }
        return selectedTargets;
    }

    public void restartVM() {
        this.getDebugger().close(true);
        this.vmClosed();
        PkgMgrFrame.displayMessage(this, Config.getString("pkgmgr.creatingVM"));
    }

    private void vmReady() {
        BlueJEvent.raiseEvent(2, null);
        Package pkg2 = null;
        for (Package pkg2 : this.packages.values()) {
            pkg2.reInitBreakpoints();
        }
        PkgMgrFrame frame = PkgMgrFrame.getMostRecent();
        if (frame != null) {
            Utility.bringToFront(frame);
        }
    }

    private void vmClosed() {
        this.removeClassLoader();
        this.newRemoteClassLoader();
    }

    public void removeClassLoader() {
        if (this.currentClassLoader == null) {
            return;
        }
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(this);
        for (int i = 0; i < frames.length; ++i) {
            frames[i].getObjectBench().removeAllObjects(this.getUniqueId());
            frames[i].clearTextEval();
        }
        this.removeAllInspectors();
        View.removeAll(this.currentClassLoader);
        if (!Config.isGreenfoot()) {
            new Thread(){

                public void run() {
                    Project.this.getDebugger().disposeWindows();
                }
            }.start();
        }
        this.currentClassLoader = null;
    }

    public void newRemoteClassLoader() {
        this.getDebugger().newClassLoader(this.getClassLoader());
    }

    public void newRemoteClassLoaderLeavingBreakpoints() {
        this.getDebugger().newClassLoader(this.getClassLoader());
        for (Package pkg : this.packages.values()) {
            pkg.reInitBreakpoints();
        }
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public boolean hasExecControls() {
        return this.execControls != null;
    }

    public ExecControls getExecControls() {
        if (this.execControls == null) {
            this.execControls = new ExecControls(this, this.getDebugger());
        }
        return this.execControls;
    }

    public boolean hasTerminal() {
        return this.terminal != null;
    }

    public Terminal getTerminal() {
        if (this.terminal == null) {
            this.terminal = new Terminal(this);
        }
        return this.terminal;
    }

    public Class loadClass(String className) {
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (LinkageError le) {
            return null;
        }
    }

    public boolean inTestMode() {
        return this.inTestMode;
    }

    public void setTestMode(boolean mode) {
        this.inTestMode = mode;
    }

    protected List getJavaMELibraries(String type) {
        ArrayList<URL> risul = new ArrayList<URL>();
        String toolkitDir = Config.getPropString("bluej.javame.toolkit.dir", null);
        String libs = type.equals("core") ? Config.getPropString("bluej.javame.corelibraries", null) : (type.equals("optional") ? Config.getPropString("bluej.javame.optlibraries", null) : null);
        if (toolkitDir != null && libs != null) {
            String libDir = toolkitDir + File.separator + "lib" + File.separator;
            StringTokenizer st = new StringTokenizer(libs);
            while (st.hasMoreTokens()) {
                try {
                    File file = new File(libDir + st.nextToken());
                    risul.add(file.toURI().toURL());
                }
                catch (MalformedURLException mue) {
                    Debug.reportError(st.nextToken() + " is a Java ME malformed file.");
                }
            }
        }
        return risul;
    }

    protected ArrayList getPlusLibsContent() {
        ArrayList risul = new ArrayList();
        File libsDirectory = new File(this.projectDir, projectLibDirName);
        if (!libsDirectory.isDirectory() || !libsDirectory.canRead()) {
            return risul;
        }
        File[] libs = libsDirectory.listFiles();
        if (libs == null || libs.length < 1) {
            return risul;
        }
        for (int index = 0; index < libs.length; ++index) {
            Project.attemptAddLibrary(risul, libs[index]);
        }
        return risul;
    }

    private static final void attemptAddLibrary(ArrayList risul, File aFile) {
        if (aFile == null) {
            return;
        }
        if (!aFile.isFile() || !aFile.canRead()) {
            return;
        }
        String libname = aFile.getName().toLowerCase();
        if (!libname.endsWith(".jar") && !libname.endsWith(".zip")) {
            return;
        }
        try {
            risul.add(aFile.toURI().toURL());
        }
        catch (MalformedURLException mue) {
            Debug.reportError("Project.attemptAddLibrary() malformaed file=" + aFile);
        }
    }

    public static final ArrayList getUserlibContent() {
        File userLibDir;
        ArrayList risul = new ArrayList();
        String userLibSetting = Config.getPropString("bluej.userlibLocation", null);
        if (userLibSetting == null) {
            Boot.getInstance();
            userLibDir = new File(Boot.getBluejLibDir(), "userlib");
        } else {
            userLibDir = new File(userLibSetting);
        }
        File[] files = userLibDir.listFiles();
        if (files == null) {
            return risul;
        }
        for (int index = 0; index < files.length; ++index) {
            Project.attemptAddLibrary(risul, files[index]);
        }
        return risul;
    }

    private void addArrayToList(ArrayList list, URL[] urls) {
        for (int index = 0; index < urls.length; ++index) {
            list.add(urls[index]);
        }
    }

    public BPClassLoader getClassLoader() {
        if (this.currentClassLoader != null) {
            return this.currentClassLoader;
        }
        ArrayList<URL> pathList = new ArrayList<URL>();
        List coreLibs = new ArrayList();
        List optLibs = new ArrayList();
        try {
            this.addArrayToList(pathList, Boot.getInstance().getRuntimeUserClassPath());
            pathList.addAll(PrefMgrDialog.getInstance().getUserConfigLibPanel().getUserConfigContent());
            pathList.addAll(Project.getUserlibContent());
            pathList.addAll(this.getPlusLibsContent());
            pathList.add(this.getProjectDir().toURI().toURL());
            if (this.isJavaMEproject) {
                coreLibs = this.getJavaMELibraries("core");
                optLibs = this.getJavaMELibraries("optional");
                pathList.addAll(coreLibs);
                pathList.addAll(optLibs);
            }
        }
        catch (Exception exc) {
            Debug.reportError("Project.getClassLoader() exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        URL[] newUrls = pathList.toArray(new URL[pathList.size()]);
        this.currentClassLoader = new BPClassLoader(newUrls, Boot.getInstance().getBootClassLoader(), this.isJavaMEproject);
        this.currentClassLoader.setJavaMEcoreLibs(this.toStringList(coreLibs));
        this.currentClassLoader.setJavaMEoptLibs(this.toStringList(optLibs));
        return this.currentClassLoader;
    }

    private List toStringList(List urlList) {
        ArrayList<String> risul = new ArrayList<String>();
        for (URL u : urlList) {
            try {
                File f = new File(u.toURI());
                risul.add(f.toString());
            }
            catch (URISyntaxException e) {
                Debug.reportError("Bad syntax in URL " + u + ". Cannot do toURI().");
            }
        }
        return risul;
    }

    public String convertPathToPackageName(String pathname) {
        return JavaNames.convertFileToQualifiedName(this.getProjectDir(), new File(pathname));
    }

    public void removeStepMarks() {
        for (Package pkg : this.packages.values()) {
            pkg.removeStepMarks();
        }
    }

    public void debuggerEvent(final DebuggerEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (event.getID() == 1) {
                    PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(Project.this);
                    if (frames == null) {
                        return;
                    }
                    int newState = event.getNewState();
                    int oldState = event.getOldState();
                    for (int i = 0; i < frames.length; ++i) {
                        frames[i].setDebuggerState(newState);
                    }
                    if (oldState == 1 && newState == 2) {
                        Project.this.vmReady();
                    }
                    if (oldState == 2 && newState == 1) {
                        Project.this.vmClosed();
                    }
                    if (newState == 5) {
                        BlueJEvent.raiseEvent(1, null);
                    }
                    return;
                }
                if (event.getID() == 2) {
                    Project.this.removeStepMarks();
                    return;
                }
                DebuggerThread thr = event.getThread();
                String packageName = JavaNames.getPrefix(thr.getClass(0));
                Package pkg = Project.this.getPackage(packageName);
                if (pkg != null) {
                    switch (event.getID()) {
                        case 4: {
                            pkg.hitBreakpoint(thr);
                            break;
                        }
                        case 3: {
                            pkg.hitHalt(thr);
                            break;
                        }
                        case 6: {
                            pkg.showSourcePosition(thr);
                        }
                    }
                }
            }
        });
    }

    public String toString() {
        return "Project:" + this.getProjectName();
    }

    public void removePackage(String packageQualifiedName) {
        Package pkg = this.packages.get(packageQualifiedName);
        if (pkg != null) {
            List childPackages = pkg.getChildren(false);
            for (Package childPkg : childPackages) {
                this.removePackage(childPkg.getQualifiedName());
            }
            this.packages.remove(packageQualifiedName);
        }
    }

    public TeamActionGroup getTeamActions() {
        return this.teamActions;
    }

    public boolean isTeamProject() {
        return this.isSharedProject;
    }

    public Set getFilesInProject(boolean includePkgFiles, boolean includeDirs) {
        HashSet<File> files = new HashSet<File>();
        if (includeDirs) {
            files.add(this.projectDir);
        }
        this.traverseDirsForFiles(files, this.projectDir, includePkgFiles, includeDirs);
        return files;
    }

    public TeamSettingsController getTeamSettingsController() {
        if (this.teamSettingsController == null && this.isSharedProject) {
            this.teamSettingsController = new TeamSettingsController(this);
        }
        return this.teamSettingsController;
    }

    private void traverseDirsForFiles(Set allFiles, File dir, boolean includePkgFiles, boolean includeDirs) {
        File[] files = dir.listFiles(this.getTeamSettingsController().getFileFilter(includePkgFiles));
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                allFiles.add(files[i]);
                continue;
            }
            if (includeDirs) {
                allFiles.add(files[i]);
            }
            this.traverseDirsForFiles(allFiles, files[i], includePkgFiles, includeDirs);
        }
    }

    public TeamSettingsDialog getTeamSettingsDialog() {
        return this.getTeamSettingsController().getTeamSettingsDialog();
    }

    public CommitCommentsFrame getCommitCommentsDialog() {
        if (this.commitCommentsFrame == null) {
            this.commitCommentsFrame = new CommitCommentsFrame(this);
        }
        return this.commitCommentsFrame;
    }

    public UpdateFilesFrame getUpdateDialog() {
        if (this.updateFilesFrame == null) {
            this.updateFilesFrame = new UpdateFilesFrame(this);
        }
        return this.updateFilesFrame;
    }

    private void setProjectShared(boolean shared) {
        this.isSharedProject = shared;
        this.teamActions.setTeamMode(shared);
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(this);
        if (frames != null) {
            for (int i = 0; i < frames.length; ++i) {
                frames[i].updateSharedStatus(shared);
            }
        }
    }

    public String getPackageForFile(File f) {
        File projdir = this.getProjectDir();
        String packageName = "";
        File parentDir = f.getParentFile();
        while (!parentDir.equals(projdir)) {
            String parentName = parentDir.getName();
            if (!JavaNames.isIdentifier(parentName)) {
                return null;
            }
            packageName = packageName.equals("") ? parentName : parentName + "." + packageName;
            if ((parentDir = parentDir.getParentFile()) != null) continue;
            return null;
        }
        return packageName;
    }

    public void setTeamSettingsController(TeamSettingsController tsc) {
        this.teamSettingsController = tsc;
        if (tsc != null) {
            tsc.setProject(this);
            tsc.writeToProject();
        }
        this.setProjectShared(tsc != null);
    }

    public StatusFrame getStatusWindow(Window parent) {
        if (this.statusFrame == null) {
            this.statusFrame = new StatusFrame(this);
            this.statusFrame.setLocationRelativeTo(parent);
        }
        return this.statusFrame;
    }

    public boolean prepareDeleteDir(File dir) {
        TeamSettingsController tsc = this.getTeamSettingsController();
        if (tsc != null) {
            return tsc.prepareDeleteDir(dir);
        }
        return true;
    }

    public void prepareCreateDir(File dir) {
        TeamSettingsController tsc = this.getTeamSettingsController();
        if (tsc != null) {
            tsc.prepareCreateDir(dir);
        }
    }
}

