/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import bluej.utility.JavaNames;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class NewPackageDialog
extends EscapeDialog {
    private String newPackageName = "";
    private JTextField textFld;
    private boolean ok;

    public NewPackageDialog(JFrame parent) {
        super(parent, Config.getString("pkgmgr.newPackage.title"), true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent E) {
                NewPackageDialog.this.ok = false;
                NewPackageDialog.this.setVisible(false);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        JLabel newclassTag = new JLabel(Config.getString("pkgmgr.newPackage.label"));
        newclassTag.setAlignmentX(0.0f);
        this.textFld = new JTextField(24);
        this.textFld.setAlignmentX(0.0f);
        mainPanel.add(newclassTag);
        mainPanel.add(this.textFld);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(Box.createVerticalStrut(17));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewPackageDialog.this.doOK();
            }
        });
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewPackageDialog.this.doCancel();
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog(this);
    }

    public boolean display() {
        this.ok = false;
        this.textFld.requestFocus();
        this.setVisible(true);
        return this.ok;
    }

    public String getPackageName() {
        return this.newPackageName;
    }

    public void doOK() {
        this.newPackageName = this.textFld.getText().trim();
        if (JavaNames.isQualifiedIdentifier(this.newPackageName)) {
            this.ok = true;
            this.setVisible(false);
        } else {
            DialogManager.showError((JFrame)this.getParent(), "invalid-package-name");
            this.textFld.selectAll();
            this.textFld.requestFocus();
        }
    }

    public void doCancel() {
        this.ok = false;
        this.setVisible(false);
    }
}

