/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.pkgmgr.MIDletDeploymentDialog;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.role.MIDletClassRole;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

final class MIDletDeployer {
    static final String ICONS_DIR = "res" + File.separator + "icons";
    static final String DEFAULT_MIDLET_ICON = "default.gif";
    static final String DEFAULT_LIB_ME_ICON = "images" + File.separator + "me-default-icon.gif";
    private String toolkitBinDir;
    private File verified;
    private List args;
    private PkgMgrFrame frame;
    private Project proj;
    private List midlets;

    public MIDletDeployer(PkgMgrFrame pmf) {
        this.frame = pmf;
        this.proj = this.frame.getProject();
        this.verified = new File(this.proj.getProjectDir(), "+tmpclasses");
        this.toolkitBinDir = Config.getPropString("bluej.javame.toolkit.dir") + File.separator + "bin" + File.separator;
    }

    void deploy() {
        if (!this.buildPreverifyCommand()) {
            return;
        }
        FileUtility.deleteDir(this.verified);
        if (!this.verified.mkdir()) {
            Debug.reportError("Could not create preverify output directory");
        }
        this.startProcess();
        final MIDletDeploymentDialog dialog = new MIDletDeploymentDialog(this.frame, this.verified, this.midlets);
        if (dialog.runEmulator()) {
            new Thread(){

                public void run() {
                    MIDletDeployer.this.launchEmulator(dialog.getJadFile());
                }
            }.start();
        }
        this.frame.setStatus(Config.getString("pkgmgr.midlet.deployed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProcess() {
        this.frame.startProgress();
        boolean busyRunning = true;
        ProcessBuilder pb = new ProcessBuilder(this.args);
        pb.directory(this.proj.getProjectDir());
        pb.redirectErrorStream(true);
        try {
            try {
                String line;
                Process process = pb.start();
                InputStream is = process.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    if (busyRunning) {
                        this.frame.stopProgress();
                        busyRunning = false;
                    }
                    Debug.message(line);
                }
                Object var8_8 = null;
                if (busyRunning) {
                    this.frame.stopProgress();
                    busyRunning = false;
                }
            }
            catch (IOException ioe) {
                Debug.reportError("Had trouble invoking commmand" + pb.command());
                ioe.printStackTrace();
                Object var8_9 = null;
                if (busyRunning) {
                    this.frame.stopProgress();
                    busyRunning = false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (busyRunning) {
                this.frame.stopProgress();
                busyRunning = false;
            }
            throw throwable;
        }
    }

    private boolean buildPreverifyCommand() {
        this.args = new ArrayList();
        this.args.add(this.toolkitBinDir + "preverify");
        this.args.add("-classpath");
        this.args.add(this.proj.getClassLoader().getJavaMElibsAsPath());
        this.args.add("-d");
        this.args.add(this.verified.getAbsolutePath());
        this.getUserSpecifiedOptions("bluej.javame.preverify.options");
        return this.getAndCheckClassTargets();
    }

    private boolean getAndCheckClassTargets() {
        this.midlets = new ArrayList();
        List packageNames = this.proj.getPackageNames();
        String dot = "";
        for (Object pkgName : packageNames) {
            Package pkg = this.proj.getPackage((String)pkgName);
            ArrayList classTargets = pkg.getClassTargets();
            for (Object ct : classTargets) {
                ClassTarget target = (ClassTarget)ct;
                if (!target.upToDate()) {
                    DialogManager.showMessage(this.frame, "not-all-compiled");
                    return false;
                }
                if (!(target.getRole() instanceof MIDletClassRole)) continue;
                this.midlets.add((String)pkgName + dot + target);
            }
            dot = ".";
            this.getClassFiles(pkg);
        }
        return true;
    }

    private void getClassFiles(Package pkg) {
        String[] classFiles = pkg.getPath().list(new ClassFilesFilter());
        if (classFiles == null || classFiles.length == 0) {
            return;
        }
        String dot = "";
        String pkgName = pkg.getQualifiedName();
        if (!pkgName.equals("")) {
            dot = ".";
        }
        for (int i = 0; i < classFiles.length; ++i) {
            int index = classFiles[i].lastIndexOf(".class");
            String s = classFiles[i].substring(0, index);
            this.args.add(pkgName + dot + s);
        }
    }

    private void launchEmulator(File jadFile) {
        this.args = new ArrayList();
        this.args.add(this.toolkitBinDir + "emulator");
        this.args.add("-Xdescriptor:" + jadFile.getName());
        this.getUserSpecifiedOptions("bluej.javame.emulator.options");
        this.startProcess();
    }

    private void getUserSpecifiedOptions(String userOptions) {
        String options = Config.getPropString(userOptions, null);
        if (options != null) {
            StringTokenizer st = new StringTokenizer(options);
            while (st.hasMoreTokens()) {
                this.args.add(st.nextToken());
            }
        }
    }

    private class ClassFilesFilter
    implements FilenameFilter {
        private ClassFilesFilter() {
        }

        public boolean accept(File f, String name) {
            return name.toLowerCase().endsWith(".class");
        }
    }
}

