/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.parser.ClassParser;
import bluej.parser.symtab.ClassInfo;
import bluej.pkgmgr.ImportMismatchDialog;
import bluej.pkgmgr.PackageFileFactory;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;

public class Import {
    public static boolean convertNonBlueJ(JFrame parentWin, File path) {
        List interestingDirs = Import.findInterestingDirectories(path);
        if (interestingDirs.size() == 0) {
            DialogManager.showError(parentWin, "open-non-bluej-no-java");
            return false;
        }
        List javaFiles = Import.findJavaFiles(interestingDirs);
        ArrayList<File> mismatchFiles = new ArrayList<File>();
        ArrayList<String> mismatchPackagesOriginal = new ArrayList<String>();
        ArrayList<String> mismatchPackagesChanged = new ArrayList<String>();
        for (File f : javaFiles) {
            try {
                ClassInfo info = ClassParser.parse(f);
                String qf = JavaNames.convertFileToQualifiedName(path, f);
                if (JavaNames.getPrefix(qf).equals(info.getPackage())) continue;
                mismatchFiles.add(f);
                mismatchPackagesOriginal.add(info.getPackage());
                mismatchPackagesChanged.add(qf);
            }
            catch (Exception e) {}
        }
        if (mismatchFiles.size() > 0) {
            ImportMismatchDialog imd = new ImportMismatchDialog(parentWin, mismatchFiles, mismatchPackagesOriginal, mismatchPackagesChanged);
            imd.setVisible(true);
            if (!imd.getResult()) {
                return false;
            }
        }
        Import.convertDirectory(interestingDirs);
        return true;
    }

    public static List findInterestingDirectories(File dir) {
        LinkedList<File> interesting = new LinkedList<File>();
        File[] files = dir.listFiles();
        if (files == null) {
            return interesting;
        }
        boolean imInteresting = false;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                List subInteresting;
                if (!JavaNames.isIdentifier(files[i].getName()) || (subInteresting = Import.findInterestingDirectories(files[i])).size() <= 0) continue;
                interesting.addAll(subInteresting);
                imInteresting = true;
                continue;
            }
            if (!files[i].getName().endsWith(".java")) continue;
            imInteresting = true;
        }
        if (imInteresting) {
            interesting.add(dir);
        }
        return interesting;
    }

    public static List findJavaFiles(List dirs) {
        LinkedList<File> interesting = new LinkedList<File>();
        for (File dir : dirs) {
            File[] files = dir.listFiles();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().endsWith(".java")) continue;
                interesting.add(files[i]);
            }
        }
        return interesting;
    }

    public static void convertDirectory(List dirs) {
        for (File f : dirs) {
            try {
                PackageFileFactory.getPackageFile(f).create();
            }
            catch (IOException e) {
                Debug.reportError("Could not create package files in dir: " + f, e);
            }
        }
    }
}

