/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.pkgmgr.PackageFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class GreenfootProjectFile
implements PackageFile {
    private static final String pkgfileName = "project.greenfoot";
    private File dir;
    private File pkgFile;

    GreenfootProjectFile(File dir) {
        this.dir = dir;
        this.pkgFile = new File(dir, pkgfileName);
    }

    public String toString() {
        return this.dir.toString() + File.separator + pkgfileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(Properties p) throws IOException {
        FileInputStream input = null;
        try {
            if (!this.pkgFile.canRead()) {
                throw new IOException("Can't read from project file: " + this.pkgFile);
            }
            input = new FileInputStream(this.pkgFile);
            p.load(input);
            Object var4_3 = null;
            if (input == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (input == null) throw throwable;
            input.close();
            throw throwable;
        }
        input.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(Properties props) throws IOException {
        if (!this.pkgFile.canWrite()) {
            throw new IOException("Greenfoot project file not writable: " + this);
        }
        try {
            FileInputStream input = new FileInputStream(this.pkgFile);
            props.load(input);
        }
        catch (IOException e) {
            // empty catch block
        }
        FileOutputStream output = null;
        try {
            try {
                output = new FileOutputStream(this.pkgFile);
                String header = "Greenfoot project file";
                props.store(output, header);
            }
            catch (IOException e) {
                throw new IOException("Error when storing properties to Greenfoot project file: " + this);
            }
            Object var5_6 = null;
            if (output == null) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (output == null) throw throwable;
            output.close();
            throw throwable;
        }
        output.close();
    }

    public static boolean exists(File dir) {
        if (dir == null) {
            return false;
        }
        if (dir.getPath().endsWith(":\\")) {
            return false;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File packageFile = new File(dir, pkgfileName);
        return packageFile.exists();
    }

    public boolean create() throws IOException {
        File pkgFile = new File(this.dir, pkgfileName);
        if (pkgFile.exists()) {
            return false;
        }
        pkgFile.createNewFile();
        return true;
    }
}

