/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class FileTransferHandler
extends TransferHandler {
    private DataFlavor fileFlavour = DataFlavor.javaFileListFlavor;
    private PkgMgrFrame pmf;

    public FileTransferHandler(PkgMgrFrame pmf) {
        this.pmf = pmf;
    }

    public boolean importData(JComponent c, Transferable t) {
        try {
            if (!this.canImport(c, t.getTransferDataFlavors())) {
                return false;
            }
            List files = (List)t.getTransferData(this.fileFlavour);
            this.pmf.addFiles(files);
        }
        catch (UnsupportedFlavorException ex) {
            Debug.reportError("Cannot handle D&D transfer");
        }
        catch (IOException ex) {
            Debug.reportError("I/O exception during D&D import attempt");
        }
        return true;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavours) {
        return this.hasFileFlavor(flavours);
    }

    private boolean hasFileFlavor(DataFlavor[] flavours) {
        for (int i = 0; i < flavours.length; ++i) {
            if (!this.fileFlavour.equals(flavours[i])) continue;
            return true;
        }
        return false;
    }
}

