/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.pkgmgr.PackageFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class BlueJPackageFile
implements PackageFile {
    private static final String pkgfileName = "package.bluej";
    private static final String oldPkgfileName = "bluej.pkg";
    private File dir;
    private File pkgFile;
    private File oldPkgFile;

    BlueJPackageFile(File dir) {
        this.dir = dir;
        this.pkgFile = new File(dir, pkgfileName);
        this.oldPkgFile = new File(dir, oldPkgfileName);
    }

    public String toString() {
        return "BlueJ package file in: " + this.dir.toString();
    }

    public static boolean exists(File dir) {
        if (dir == null) {
            return false;
        }
        if (dir.getPath().endsWith(":\\")) {
            return false;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File packageFile = new File(dir, pkgfileName);
        if (packageFile.exists()) {
            return true;
        }
        File oldPackageFile = new File(dir, oldPkgfileName);
        return oldPackageFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(Properties p) throws IOException {
        FileInputStream input = null;
        try {
            if (this.oldPkgFile.canRead()) {
                input = new FileInputStream(this.oldPkgFile);
            } else {
                if (!this.pkgFile.canRead()) throw new IOException("Can't read from package file(s) in: " + this);
                input = new FileInputStream(this.pkgFile);
            }
            p.load(input);
            Object var4_3 = null;
            if (input == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (input == null) throw throwable;
            input.close();
            throw throwable;
        }
        input.close();
    }

    public void save(Properties props) throws IOException {
        try {
            this.oldPkgFile.createNewFile();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean oldPkgSaved = false;
        if (this.oldPkgFile.exists()) {
            if (!this.oldPkgFile.canWrite()) {
                throw new IOException("BlueJ package file not writable: " + this.oldPkgFile);
            }
            this.saveToFile(props, this.oldPkgFile);
            oldPkgSaved = true;
        }
        this.pkgFile.createNewFile();
        if (!this.pkgFile.canWrite()) {
            if (!oldPkgSaved) {
                throw new IOException("BlueJ package file not writable: " + this.pkgFile);
            }
            return;
        }
        this.saveToFile(props, this.pkgFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveToFile(Properties props, File file) throws IOException {
        FileOutputStream output = null;
        try {
            try {
                output = new FileOutputStream(file);
                String header = "BlueJ package file";
                props.store(output, header);
            }
            catch (IOException e) {
                throw new IOException("Error when storing properties to BlueJ package file: " + file);
            }
            Object var6_6 = null;
            if (output == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (output == null) throw throwable;
            output.close();
            throw throwable;
        }
        output.close();
    }

    public static boolean isPackageFileName(String name) {
        return name.equals(pkgfileName) || name.equals(oldPkgfileName);
    }

    public static boolean isOldPackageFileName(String name) {
        return name.equals(oldPkgfileName);
    }

    public boolean create() throws IOException {
        File pkgFile = new File(this.dir, pkgfileName);
        File oldPkgFile = new File(this.dir, oldPkgfileName);
        boolean created = false;
        if (pkgFile.exists() && !oldPkgFile.exists()) {
            return false;
        }
        if (!pkgFile.exists()) {
            pkgFile.createNewFile();
            created = true;
        }
        if (!oldPkgFile.exists()) {
            oldPkgFile.createNewFile();
            if (!created) {
                created = true;
            }
        }
        return created;
    }
}

