/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import bluej.Config;
import bluej.debugger.gentype.BadInheritanceChainException;
import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeSuper;
import bluej.debugger.gentype.GenTypeTpar;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.JavaPrimitiveType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ValueCollection;
import bluej.debugmgr.texteval.WildcardCapture;
import bluej.parser.ClassEntity;
import bluej.parser.EscapedUnicodeReader;
import bluej.parser.ImportsCollection;
import bluej.parser.JavaEntity;
import bluej.parser.JavaTokenFilter;
import bluej.parser.PackageOrClass;
import bluej.parser.SemanticException;
import bluej.parser.ast.LocatableAST;
import bluej.parser.ast.gen.JavaLexer;
import bluej.parser.ast.gen.JavaRecognizer;
import bluej.utility.Debug;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TextParser {
    private ClassLoader classLoader;
    private String packageScope;
    private ValueCollection objectBench;
    private static JavaUtils jutils = JavaUtils.getJavaUtils();
    private static boolean java15 = Config.isJava15();
    private List declVars;
    private String amendedCommand;
    private ImportsCollection imports;
    private String importCandidate;
    private JavaRecognizer parser;

    public TextParser(ClassLoader classLoader, String packageScope, ValueCollection ob) {
        this.classLoader = classLoader;
        this.packageScope = packageScope;
        this.objectBench = ob;
        this.imports = new ImportsCollection();
    }

    public void newClassLoader(ClassLoader newLoader) {
        this.classLoader = newLoader;
        this.imports.clear();
    }

    public String parseCommand(String command) {
        AST rootAST;
        this.importCandidate = "";
        this.amendedCommand = command;
        boolean parsedOk = false;
        this.declVars = Collections.EMPTY_LIST;
        if (this.parser == null) {
            this.parser = TextParser.getParser();
        }
        try {
            this.parser.setTokenBuffer(new TokenBuffer(TextParser.getTokenStream(command)));
            this.parser.getInputState().reset();
            this.parser.importDefinition();
            this.amendedCommand = "";
            this.importCandidate = command;
            return null;
        }
        catch (RecognitionException re) {
        }
        catch (TokenStreamException tse) {
            // empty catch block
        }
        try {
            this.parser.setTokenBuffer(new TokenBuffer(TextParser.getTokenStream("{" + command + "};;;;;")));
            this.parser.getInputState().reset();
            this.parser.compoundStatement();
            rootAST = this.parser.getAST();
            parsedOk = true;
            AST fcnode = rootAST.getFirstChild();
            this.checkVars((LocatableAST)fcnode, command);
        }
        catch (RecognitionException re) {
        }
        catch (TokenStreamException tse) {
            // empty catch block
        }
        if (!parsedOk) {
            this.parser.setTokenBuffer(new TokenBuffer(TextParser.getTokenStream(command + ";;;;;")));
            this.parser.getInputState().reset();
            try {
                JavaType t;
                this.parser.expression();
                rootAST = this.parser.getAST();
                parsedOk = true;
                ExprValue ev = this.getExpressionType(rootAST);
                JavaType javaType = t = ev != null ? ev.getType() : null;
                if (t == null) {
                    return "";
                }
                if (t.isVoid()) {
                    return null;
                }
                if (t instanceof GenTypeSolid) {
                    GenTypeSolid st = (GenTypeSolid)t;
                    GenTypeClass[] bounds = st.getReferenceSupertypes();
                    t = bounds[0];
                }
                t = t.mapTparsToTypes(null);
                return t.toString();
            }
            catch (RecognitionException re) {
            }
            catch (SemanticException se) {
            }
            catch (TokenStreamException tse) {
            }
            catch (Exception e) {
                Debug.reportError("TextParser: Unexpected error during parsing:");
                e.printStackTrace(System.out);
            }
            return "";
        }
        return null;
    }

    public void confirmCommand() {
        if (this.importCandidate.length() != 0) {
            try {
                this.addImportToCollection(this.parser.getAST());
            }
            catch (RecognitionException re) {
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
    }

    void addImportToCollection(AST importNode) throws SemanticException, RecognitionException {
        if (importNode.getType() == 30) {
            AST classNode = importNode.getFirstChild();
            AST fpNode = classNode.getFirstChild();
            AST className = fpNode.getNextSibling();
            if (className.getType() == 87) {
                PackageOrClass importEntity = this.getPackageOrType(fpNode, true);
                this.imports.addWildcardImport(importEntity);
            } else {
                PackageOrClass importEntity = this.getPackageOrType(classNode, true);
                if (importEntity.isClass()) {
                    this.imports.addNormalImport(className.getText(), importEntity);
                }
            }
        } else if (importNode.getType() == 45) {
            AST impNode = importNode.getFirstChild().getFirstChild();
            AST impNameNode = impNode.getNextSibling();
            if (impNameNode.getType() == 87) {
                ClassEntity importEntity = (ClassEntity)this.getPackageOrType(impNode, true);
                this.imports.addStaticWildcardImport(importEntity);
            } else {
                String impName = impNameNode.getText();
                ClassEntity importEntity = (ClassEntity)this.getPackageOrType(impNode, true);
                this.imports.addStaticImport(impName, importEntity);
            }
        }
    }

    private void checkVars(LocatableAST fcnode, String command) throws RecognitionException {
        try {
            this.declVars = new ArrayList();
            ArrayList<Integer> insPoint = new ArrayList<Integer>();
            ArrayList<String> insText = new ArrayList<String>();
            while (fcnode != null) {
                int ecol = fcnode.getEndColumn() - 2;
                if (fcnode.getType() == 10) {
                    boolean isFinal = false;
                    AST modnode = fcnode.getFirstChild();
                    AST firstMod = modnode.getFirstChild();
                    if (firstMod != null && firstMod.getType() == 39) {
                        isFinal = true;
                    }
                    AST typenode = modnode.getNextSibling();
                    JavaType declVarType = this.getTypeFromTypeNode(typenode);
                    AST namenode = typenode.getNextSibling();
                    String varName = namenode.getText();
                    boolean isVarInit = namenode.getNextSibling() != null;
                    this.declVars.add(new DeclaredVar(isVarInit, isFinal, declVarType, varName));
                    if (!isVarInit) {
                        insPoint.add(new Integer(ecol - 1));
                        String text = declVarType.isPrimitive() ? (declVarType.isNumeric() ? "= 0" : "= false") : "= null";
                        insText.add(text);
                    }
                }
                fcnode = (LocatableAST)fcnode.getNextSibling();
            }
            this.amendedCommand = command;
            int i = insPoint.size();
            while (i-- > 0) {
                int ipoint = (Integer)insPoint.get(i);
                String itext = (String)insText.get(i);
                this.amendedCommand = this.amendedCommand.substring(0, ipoint) + itext + this.amendedCommand.substring(ipoint);
            }
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    public List getDeclaredVars() {
        return this.declVars;
    }

    public String getAmendedCommand() {
        return this.amendedCommand;
    }

    public String getImportStatements() {
        return this.imports.toString() + this.importCandidate;
    }

    private JavaType questionOperator14(AST node) throws RecognitionException, SemanticException {
        JavaType falseAltType;
        AST trueAlt = node.getFirstChild().getNextSibling();
        AST falseAlt = trueAlt.getNextSibling();
        ExprValue trueAltEv = this.getExpressionType(trueAlt);
        ExprValue falseAltEv = this.getExpressionType(falseAlt);
        JavaType trueAltType = trueAltEv.getType();
        if (trueAltType.equals(falseAltType = falseAltEv.getType())) {
            return trueAltType;
        }
        if (trueAltType.isNumeric() && falseAltType.isNumeric()) {
            int fval;
            if (trueAltType.typeIs(JavaType.JT_SHORT) && falseAltType.typeIs(JavaType.JT_BYTE)) {
                return JavaPrimitiveType.getShort();
            }
            if (falseAltType.typeIs(JavaType.JT_SHORT) && trueAltType.typeIs(JavaType.JT_BYTE)) {
                return JavaPrimitiveType.getShort();
            }
            if (falseAltType.typeIs(JavaType.JT_INT) && falseAltEv.knownValue()) {
                fval = falseAltEv.intValue();
                if (TextParser.isMinorInteger(trueAltType) && trueAltType.couldHold(fval)) {
                    return trueAltType;
                }
            }
            if (trueAltType.typeIs(JavaType.JT_INT) && trueAltEv.knownValue()) {
                fval = trueAltEv.intValue();
                if (TextParser.isMinorInteger(falseAltType) && falseAltType.couldHold(fval)) {
                    return falseAltType;
                }
            }
            return this.binaryNumericPromotion(trueAltType, falseAltType);
        }
        if (trueAltType.isAssignableFrom(falseAltType)) {
            return trueAltType;
        }
        if (falseAltType.isAssignableFrom(trueAltType)) {
            return falseAltType;
        }
        throw new SemanticException();
    }

    private static boolean isMinorInteger(JavaType a) {
        return a.typeIs(JavaType.JT_BYTE) || a.typeIs(JavaType.JT_CHAR) || a.typeIs(JavaType.JT_SHORT);
    }

    private JavaType questionOperator15(AST node) throws RecognitionException, SemanticException {
        AST trueAlt = node.getFirstChild().getNextSibling();
        AST falseAlt = trueAlt.getNextSibling();
        ExprValue trueAltEv = this.getExpressionType(trueAlt);
        ExprValue falseAltEv = this.getExpressionType(falseAlt);
        JavaType trueAltType = trueAltEv.getType();
        JavaType falseAltType = falseAltEv.getType();
        if (trueAltType == null || falseAltType == null) {
            return null;
        }
        if (trueAltType.isVoid() || falseAltType.isVoid()) {
            throw new SemanticException();
        }
        if (trueAltType.equals(falseAltType)) {
            return trueAltType;
        }
        JavaType trueUnboxed = this.unBox(trueAltType);
        JavaType falseUnboxed = this.unBox(falseAltType);
        if (trueUnboxed.typeIs(JavaType.JT_BOOLEAN) && falseUnboxed.typeIs(JavaType.JT_BOOLEAN)) {
            return trueUnboxed;
        }
        if (trueAltType.typeIs(JavaType.JT_NULL)) {
            return this.boxType(falseAltType);
        }
        if (falseAltType.typeIs(JavaType.JT_NULL)) {
            return this.boxType(trueAltType);
        }
        if (trueUnboxed.isNumeric() && falseUnboxed.isNumeric()) {
            int kval;
            if (trueUnboxed.typeIs(JavaType.JT_BYTE) && falseUnboxed.typeIs(JavaType.JT_SHORT)) {
                return falseUnboxed;
            }
            if (falseUnboxed.typeIs(JavaType.JT_BYTE) && trueUnboxed.typeIs(JavaType.JT_SHORT)) {
                return trueUnboxed;
            }
            if (TextParser.isMinorInteger(trueUnboxed) && falseAltType.typeIs(JavaType.JT_INT) && falseAltEv.knownValue() && trueUnboxed.couldHold(kval = falseAltEv.intValue())) {
                return trueUnboxed;
            }
            if (TextParser.isMinorInteger(falseUnboxed) && trueAltType.typeIs(JavaType.JT_INT) && trueAltEv.knownValue() && falseUnboxed.couldHold(kval = trueAltEv.intValue())) {
                return falseUnboxed;
            }
            return this.binaryNumericPromotion(trueAltType, falseAltType);
        }
        trueAltType = this.boxType(trueAltType);
        falseAltType = this.boxType(falseAltType);
        if (trueAltType instanceof GenTypeSolid && falseAltType instanceof GenTypeSolid) {
            GenTypeSolid[] lubArgs = new GenTypeSolid[]{(GenTypeSolid)trueAltType, (GenTypeSolid)falseAltType};
            return this.captureConversion(GenTypeSolid.lub(lubArgs));
        }
        return null;
    }

    private JavaType captureConversion(JavaType o) {
        GenTypeClass c = o.asClass();
        if (c != null) {
            return this.captureConversion(c, new HashMap());
        }
        return o;
    }

    private GenTypeClass captureConversion(GenTypeClass c, Map tparMap) {
        GenTypeClass newOuter = null;
        GenTypeClass oldOuter = c.getOuterType();
        if (oldOuter != null) {
            newOuter = this.captureConversion(oldOuter, tparMap);
        }
        List oldArgs = c.getTypeParamList();
        ArrayList<GenTypeSolid> newArgs = new ArrayList<GenTypeSolid>(oldArgs.size());
        Iterator i = oldArgs.iterator();
        Iterator boundsIterator = c.getReflective().getTypeParams().iterator();
        while (i.hasNext()) {
            GenTypeSolid newArg;
            GenTypeParameterizable targ = (GenTypeParameterizable)i.next();
            GenTypeDeclTpar tpar = (GenTypeDeclTpar)boundsIterator.next();
            if (targ instanceof GenTypeWildcard) {
                GenTypeWildcard wc = (GenTypeWildcard)targ;
                GenTypeSolid[] ubounds = wc.getUpperBounds();
                GenTypeSolid lbound = wc.getLowerBound();
                GenTypeSolid[] tpbounds = tpar.upperBounds();
                for (int j = 0; j < tpbounds.length; ++j) {
                    tpbounds[j] = (GenTypeSolid)tpbounds[j].mapTparsToTypes(tparMap);
                }
                if (lbound != null) {
                    newArg = new WildcardCapture(tpbounds, lbound);
                } else {
                    GenTypeSolid[] newBounds = new GenTypeSolid[ubounds.length + tpbounds.length];
                    System.arraycopy(ubounds, 0, newBounds, 0, ubounds.length);
                    System.arraycopy(tpbounds, 0, newBounds, ubounds.length, tpbounds.length);
                    newArg = new WildcardCapture(newBounds);
                }
            } else {
                newArg = (GenTypeSolid)targ;
            }
            newArgs.add(newArg);
            tparMap.put(tpar.getTparName(), newArg);
        }
        return new GenTypeClass(c.getReflective(), newArgs, newOuter);
    }

    private JavaType binaryNumericPromotion(JavaType a, JavaType b) throws SemanticException {
        JavaType ua = this.unBox(a);
        JavaType ub = this.unBox(b);
        if (ua.typeIs(JavaType.JT_DOUBLE) || ub.typeIs(JavaType.JT_DOUBLE)) {
            return JavaPrimitiveType.getDouble();
        }
        if (ua.typeIs(JavaType.JT_FLOAT) || ub.typeIs(JavaType.JT_FLOAT)) {
            return JavaPrimitiveType.getFloat();
        }
        if (ua.typeIs(JavaType.JT_LONG) || ub.typeIs(JavaType.JT_LONG)) {
            return JavaPrimitiveType.getLong();
        }
        if (ua.isNumeric() && ub.isNumeric()) {
            return JavaPrimitiveType.getInt();
        }
        throw new SemanticException();
    }

    private ExprValue getCharLiteral(AST node) throws RecognitionException {
        String x = node.getText();
        x = x.substring(1, x.length() - 1);
        JavaPrimitiveType charType = JavaPrimitiveType.getChar();
        if (!x.startsWith("\\")) {
            if (x.length() != 1) {
                throw new RecognitionException();
            }
            return new NumValue(charType, new Integer(x.charAt(0)));
        }
        if (x.equals("\\b")) {
            return new NumValue(charType, new Integer(8));
        }
        if (x.equals("\\t")) {
            return new NumValue(charType, new Integer(9));
        }
        if (x.equals("\\n")) {
            return new NumValue(charType, new Integer(10));
        }
        if (x.equals("\\f")) {
            return new NumValue(charType, new Integer(12));
        }
        if (x.equals("\\r")) {
            return new NumValue(charType, new Integer(13));
        }
        if (x.equals("\\\"")) {
            return new NumValue(charType, new Integer(34));
        }
        if (x.equals("\\'")) {
            return new NumValue(charType, new Integer(39));
        }
        if (x.equals("\\\\")) {
            return new NumValue(charType, new Integer(92));
        }
        if (x.startsWith("\\u")) {
            if (x.length() != 6) {
                throw new RecognitionException();
            }
            int val = 0;
            for (int i = 0; i < 4; ++i) {
                char digit = x.charAt(i + 2);
                int digVal = Character.digit(digit, 16);
                if (digVal == -1) {
                    throw new RecognitionException();
                }
                val = (char)(val * 16 + digVal);
            }
            return new NumValue(charType, new Integer(val));
        }
        int xlen = x.length();
        if (xlen < 2 || xlen > 4) {
            throw new RecognitionException();
        }
        int val = 0;
        for (int i = 0; i < xlen - 1; ++i) {
            char digit = x.charAt(i + 1);
            int digVal = Character.digit(digit, 8);
            if (digVal == -1) {
                throw new RecognitionException();
            }
            val = (char)(val * 8 + digVal);
        }
        return new NumValue(charType, new Integer(val));
    }

    private ExprValue getIntLiteral(AST node, boolean negative) throws RecognitionException {
        String x = node.getText();
        if (negative) {
            x = "-" + x;
        }
        try {
            Integer val = Integer.decode(x);
            return new NumValue(JavaPrimitiveType.getInt(), val);
        }
        catch (NumberFormatException nfe) {
            throw new RecognitionException();
        }
    }

    private ExprValue getLongLiteral(AST node, boolean negative) throws RecognitionException {
        String x = node.getText();
        if (negative) {
            x = "-" + x;
        }
        try {
            Long val = Long.decode(x);
            return new NumValue(JavaPrimitiveType.getLong(), val);
        }
        catch (NumberFormatException nfe) {
            throw new RecognitionException();
        }
    }

    private ExprValue getFloatLiteral(AST node, boolean negative) throws RecognitionException {
        String x = node.getText();
        if (negative) {
            x = "-" + x;
        }
        try {
            Float val = Float.valueOf(x);
            return new NumValue(JavaPrimitiveType.getFloat(), val);
        }
        catch (NumberFormatException nfe) {
            throw new RecognitionException();
        }
    }

    private ExprValue getDoubleLiteral(AST node, boolean negative) throws RecognitionException {
        String x = node.getText();
        if (negative) {
            x = "-" + x;
        }
        try {
            Double val = Double.valueOf(x);
            return new NumValue(JavaPrimitiveType.getDouble(), val);
        }
        catch (NumberFormatException nfe) {
            throw new RecognitionException();
        }
    }

    private Class loadUnqualifiedClass(String className, boolean tryWildcardImports) throws ClassNotFoundException {
        ClassEntity imported = this.imports.getTypeImport(className);
        if (imported != null) {
            try {
                String cname = ((GenTypeClass)imported.getType()).rawName();
                return this.classLoader.loadClass(cname);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        try {
            if (this.packageScope.length() != 0) {
                return this.classLoader.loadClass(this.packageScope + "." + className);
            }
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            if (!tryWildcardImports) {
                throw new ClassNotFoundException(className);
            }
            imported = this.imports.getTypeImportWC(className);
            if (imported != null) {
                try {
                    String cname = ((GenTypeClass)imported.getType()).rawName();
                    return this.classLoader.loadClass(cname);
                }
                catch (ClassNotFoundException cnfe2) {
                    // empty catch block
                }
            }
            return this.classLoader.loadClass("java.lang." + className);
        }
    }

    private Class loadWildcardImportedType(String className) throws ClassNotFoundException {
        ClassEntity imported = this.imports.getTypeImportWC(className);
        if (imported != null) {
            try {
                String cname = ((GenTypeClass)imported.getType()).rawName();
                return this.classLoader.loadClass(cname);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.classLoader.loadClass("java.lang." + className);
    }

    private GenTypeSolid getType(AST node) throws RecognitionException, SemanticException {
        if (node.getType() == 69) {
            List params = this.getTypeArgs(node.getFirstChild());
            try {
                Class c = this.loadUnqualifiedClass(node.getText(), true);
                JavaReflective r = new JavaReflective(c);
                return new GenTypeClass((Reflective)r, params);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SemanticException();
            }
        }
        if (node.getType() == 68) {
            GenTypeClass nodeClass;
            AST packageNode = node.getFirstChild();
            PackageOrClass porc = this.getPackageOrType(packageNode);
            AST classNode = packageNode.getNextSibling();
            List params = this.getTypeArgs(classNode.getFirstChild());
            PackageOrClass nodePorC = porc.getPackageOrClassMember(classNode.getText());
            GenTypeClass outer = nodeClass = (GenTypeClass)nodePorC.getType();
            if (!nodeClass.isGeneric()) {
                outer = null;
            }
            return new GenTypeClass(nodeClass.getReflective(), params, outer);
        }
        throw new RecognitionException();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List getTypeArgs(AST node) throws RecognitionException, SemanticException {
        LinkedList<void> params = new LinkedList<void>();
        while (node != null && node.getType() == 55) {
            void var4_4;
            AST childNode = node.getFirstChild();
            if (childNode.getType() == 57) {
                AST boundNode = childNode.getFirstChild();
                if (boundNode != null) {
                    int boundType = boundNode.getType();
                    if (boundType == 58) {
                        GenTypeExtends genTypeExtends = new GenTypeExtends(this.getType(boundNode.getFirstChild()));
                    } else {
                        if (boundType != 59) throw new RecognitionException();
                        GenTypeSuper genTypeSuper = new GenTypeSuper(this.getType(boundNode.getFirstChild()));
                    }
                } else {
                    GenTypeUnbounded genTypeUnbounded = new GenTypeUnbounded();
                }
            } else {
                GenTypeSolid genTypeSolid = this.getType(node.getFirstChild());
            }
            params.add(var4_4);
            node = node.getNextSibling();
        }
        return params;
    }

    static String combineDotNames(AST node, char seperator) throws RecognitionException {
        if (node.getType() == 69) {
            return node.getText();
        }
        if (node.getType() == 68) {
            AST fchild = node.getFirstChild();
            AST nchild = fchild.getNextSibling();
            if (nchild.getType() != 69) {
                throw new RecognitionException();
            }
            return TextParser.combineDotNames(fchild, seperator) + seperator + nchild.getText();
        }
        throw new RecognitionException();
    }

    JavaType getInnerType(AST node, GenTypeClass outer) throws SemanticException, RecognitionException {
        if (node.getType() == 69) {
            List params = this.getTypeArgs(node.getFirstChild());
            String name = outer.rawName() + '$' + node.getText();
            try {
                Class<?> theClass = this.classLoader.loadClass(name);
                JavaReflective r = new JavaReflective(theClass);
                return new GenTypeClass(r, params, outer);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SemanticException();
            }
        }
        if (node.getType() == 68) {
            AST packageNode = node.getFirstChild();
            String dotnames = TextParser.combineDotNames(packageNode, '$');
            AST classNode = packageNode.getNextSibling();
            List params = this.getTypeArgs(classNode.getFirstChild());
            String name = outer.rawName() + '$' + dotnames + '$' + node.getText();
            try {
                Class<?> c = this.classLoader.loadClass(name);
                JavaReflective r = new JavaReflective(c);
                return new GenTypeClass((Reflective)r, params);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SemanticException();
            }
        }
        throw new RecognitionException();
    }

    JavaEntity getEntity(AST node) throws SemanticException, RecognitionException {
        AST firstChild;
        AST secondChild;
        if (node.getType() == 69) {
            String nodeText = node.getText();
            NamedValue nv = this.objectBench.getNamedValue(nodeText);
            if (nv != null) {
                return new ValueEntity(nv.getGenType());
            }
            List l = this.imports.getStaticImports(nodeText);
            if (l != null) {
                for (ClassEntity importEntity : l) {
                    try {
                        JavaEntity fieldEnt = importEntity.getStaticField(nodeText);
                        return fieldEnt;
                    }
                    catch (SemanticException se) {
                    }
                }
            }
            try {
                Class c = this.loadUnqualifiedClass(nodeText, false);
                return new TypeEntity(c);
            }
            catch (ClassNotFoundException cnfe) {
                l = this.imports.getStaticWildcardImports();
                for (ClassEntity importEntity : l) {
                    try {
                        JavaEntity fieldEnt = importEntity.getStaticField(nodeText);
                        return fieldEnt;
                    }
                    catch (SemanticException se) {
                    }
                }
                try {
                    Class c = this.loadWildcardImportedType(nodeText);
                    return new TypeEntity(c);
                }
                catch (ClassNotFoundException cnfe2) {
                    return new PackageEntity(nodeText);
                }
            }
        }
        if (node.getType() == 68 && (secondChild = (firstChild = node.getFirstChild()).getNextSibling()).getType() == 69) {
            JavaEntity firstpart = this.getEntity(firstChild);
            return firstpart.getSubentity(secondChild.getText());
        }
        JavaType exprType = this.getExpressionType(node).getType();
        return new ValueEntity(exprType);
    }

    private PackageOrClass getPackageOrType(AST node) throws SemanticException, RecognitionException {
        return this.getPackageOrType(node, false);
    }

    private PackageOrClass getPackageOrType(AST node, boolean fullyQualified) throws SemanticException, RecognitionException {
        AST firstChild;
        AST secondChild;
        if (node.getType() == 69) {
            String nodeText = node.getText();
            List tparams = this.getTypeArgs(node.getFirstChild());
            try {
                Class c = fullyQualified ? this.classLoader.loadClass(nodeText) : this.loadUnqualifiedClass(nodeText, true);
                TypeEntity r = new TypeEntity(c, tparams);
                return r;
            }
            catch (ClassNotFoundException cnfe) {
                if (!tparams.isEmpty()) {
                    throw new SemanticException();
                }
                return new PackageEntity(nodeText);
            }
        }
        if (node.getType() == 68 && (secondChild = (firstChild = node.getFirstChild()).getNextSibling()).getType() == 69) {
            List tparams = this.getTypeArgs(secondChild.getFirstChild());
            PackageOrClass firstpart = this.getPackageOrType(firstChild, fullyQualified);
            PackageOrClass entity = firstpart.getPackageOrClassMember(secondChild.getText());
            if (!tparams.isEmpty()) {
                if (entity.isClass()) {
                    entity = ((ClassEntity)entity).setTypeParams(tparams);
                } else {
                    throw new SemanticException();
                }
            }
            return entity;
        }
        throw new SemanticException();
    }

    private JavaType[] getExpressionList(AST node) throws SemanticException, RecognitionException {
        int num = node.getNumberOfChildren();
        JavaType[] r = new JavaType[num];
        AST child = node.getFirstChild();
        for (int i = 0; i < num; ++i) {
            r[i] = this.getExpressionType(child).getType();
            child = child.getNextSibling();
        }
        return r;
    }

    private MethodCallDesc isMethodApplicable(GenTypeClass targetType, List tpars, Method m, JavaType[] args) throws RecognitionException {
        boolean methodIsVarargs = JavaUtils.getJavaUtils().isVarArgs(m);
        MethodCallDesc rdesc = null;
        rdesc = this.isMethodApplicable(targetType, tpars, m, args, false);
        if (rdesc == null && methodIsVarargs) {
            rdesc = this.isMethodApplicable(targetType, tpars, m, args, true);
        }
        return rdesc;
    }

    private MethodCallDesc isMethodApplicable(GenTypeClass targetType, List tpars, Method m, JavaType[] args, boolean varargs) throws RecognitionException {
        boolean rawTarget = targetType.isRaw();
        boolean boxingRequired = false;
        JavaType[] mparams = JavaUtils.getJavaUtils().getParamGenTypes(m, rawTarget);
        if (varargs) {
            if (mparams.length > args.length + 1) {
                return null;
            }
            GenTypeArray lastArgType = (GenTypeArray)mparams[mparams.length - 1];
            JavaType vaType = lastArgType.getArrayComponent();
            JavaType[] expandedParams = new JavaType[args.length];
            System.arraycopy(mparams, 0, expandedParams, 0, mparams.length - 1);
            for (int i = mparams.length; i < args.length; ++i) {
                expandedParams[i] = vaType;
            }
            mparams = expandedParams;
        } else if (mparams.length != args.length) {
            return null;
        }
        List tparams = Collections.EMPTY_LIST;
        if (!rawTarget || Modifier.isStatic(m.getModifiers())) {
            tparams = JavaUtils.getJavaUtils().getTypeParams(m);
        }
        if (!tpars.isEmpty() && !tparams.isEmpty() && tpars.size() != tparams.size()) {
            return null;
        }
        HashMap<String, GenTypeSolid> tparMap = rawTarget ? new HashMap<String, GenTypeSolid>() : targetType.getMap();
        if (!tparams.isEmpty() && tpars.isEmpty()) {
            for (GenTypeDeclTpar tpar : tparams) {
                tparMap.put(tpar.getTparName(), tpar);
            }
            HashMap tlbConstraints = new HashMap();
            HashMap teqConstraints = new HashMap();
            for (int i = 0; i < mparams.length; ++i) {
                if (mparams[i].isPrimitive()) continue;
                GenTypeSolid mparam = (GenTypeSolid)mparams[i];
                mparam = (GenTypeSolid)mparam.mapTparsToTypes(tparMap);
                this.processAtoFConstraint(args[i], mparam, tlbConstraints, teqConstraints);
            }
            tpars = new ArrayList<GenTypeSolid>();
            for (GenTypeDeclTpar fTpar : tparams) {
                String tparName = fTpar.getTparName();
                GenTypeSolid eqConstraint = (GenTypeSolid)teqConstraints.get(tparName);
                if (eqConstraint == null) {
                    Set lbConstraintSet = (Set)tlbConstraints.get(tparName);
                    if (lbConstraintSet != null) {
                        GenTypeSolid[] lbounds = lbConstraintSet.toArray(new GenTypeSolid[lbConstraintSet.size()]);
                        eqConstraint = GenTypeSolid.lub(lbounds);
                    } else {
                        eqConstraint = fTpar.getBound();
                    }
                }
                eqConstraint = (GenTypeSolid)eqConstraint.mapTparsToTypes(tparMap);
                tpars.add(eqConstraint);
                tparMap.put(tparName, eqConstraint);
            }
        } else {
            Iterator formalI = tparams.iterator();
            Iterator actualI = tpars.iterator();
            while (formalI.hasNext()) {
                GenTypeDeclTpar formalTpar = (GenTypeDeclTpar)formalI.next();
                GenTypeSolid argTpar = (GenTypeSolid)actualI.next();
                GenTypeSolid[] formalUbounds = formalTpar.upperBounds();
                for (int i = 0; i < formalUbounds.length; ++i) {
                    formalUbounds[i] = (GenTypeSolid)formalUbounds[i].mapTparsToTypes(tparMap);
                    if (formalUbounds[i].isAssignableFrom(argTpar)) break;
                    if (i != formalUbounds.length - 1) continue;
                    return null;
                }
                tparMap.put(formalTpar.getTparName(), argTpar);
            }
        }
        for (int i = 0; i < args.length; ++i) {
            JavaType formalArg = mparams[i];
            JavaType givenParam = args[i];
            if ((formalArg = formalArg.mapTparsToTypes(tparMap)).isAssignableFrom(givenParam)) continue;
            if (!formalArg.isAssignableFrom(this.boxType(givenParam)) && !formalArg.isAssignableFrom(this.unBox(givenParam))) {
                return null;
            }
            boxingRequired = true;
        }
        JavaType rType = jutils.getReturnType(m).mapTparsToTypes(tparMap);
        return new MethodCallDesc(m, Arrays.asList(mparams), varargs, boxingRequired, rType);
    }

    private void processAtoFConstraint(JavaType a, GenTypeSolid f, Map tlbConstraints, Map teqConstraints) {
        if ((a = this.boxType(a)).isPrimitive()) {
            return;
        }
        if (f instanceof GenTypeTpar) {
            GenTypeTpar t = (GenTypeTpar)f;
            HashSet<JavaType> constraintsSet = (HashSet<JavaType>)tlbConstraints.get(t.getTparName());
            if (constraintsSet == null) {
                constraintsSet = new HashSet<JavaType>();
                tlbConstraints.put(t.getTparName(), constraintsSet);
            }
            constraintsSet.add(a);
        } else if (f.getArrayComponent() != null) {
            if (a.getArrayComponent() != null && f.getArrayComponent() instanceof GenTypeSolid) {
                a = a.getArrayComponent();
                f = (GenTypeSolid)f.getArrayComponent();
                this.processAtoFConstraint(a, f, tlbConstraints, teqConstraints);
            }
        } else {
            GenTypeClass cf = (GenTypeClass)f;
            Map fMap = cf.getMap();
            if (fMap != null && a instanceof GenTypeSolid) {
                GenTypeClass[] asts = ((GenTypeSolid)a).getReferenceSupertypes();
                for (int i = 0; i < asts.length; ++i) {
                    try {
                        Map aMap;
                        GenTypeClass aMapped = asts[i].mapToSuper(cf.rawName());
                        if (!asts[i].rawName().equals(cf.rawName())) {
                            aMapped = (GenTypeClass)this.captureConversion(aMapped);
                        }
                        if ((aMap = aMapped.getMap()) == null) continue;
                        for (String tpName : fMap.keySet()) {
                            GenTypeParameterizable fPar = (GenTypeParameterizable)fMap.get(tpName);
                            GenTypeParameterizable aPar = (GenTypeParameterizable)aMap.get(tpName);
                            this.processAtoFtpar(aPar, fPar, tlbConstraints, teqConstraints);
                        }
                        continue;
                    }
                    catch (BadInheritanceChainException bice) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void processAtoFtpar(GenTypeParameterizable aPar, GenTypeParameterizable fPar, Map tlbConstraints, Map teqConstraints) {
        if (fPar instanceof GenTypeSolid) {
            if (aPar instanceof GenTypeSolid) {
                this.processAeqFConstraint((GenTypeSolid)aPar, (GenTypeSolid)fPar, tlbConstraints, teqConstraints);
            }
        } else {
            GenTypeSolid flbound = fPar.getLowerBound();
            if (flbound != null) {
                GenTypeSolid albound = aPar.getLowerBound();
                if (albound != null) {
                    this.processFtoAConstraint(albound, flbound, tlbConstraints, teqConstraints);
                }
            } else {
                GenTypeSolid[] fubounds = fPar.getUpperBounds();
                GenTypeSolid[] aubounds = aPar.getUpperBounds();
                if (fubounds.length > 0 && aubounds.length > 0) {
                    this.processAtoFConstraint(IntersectionType.getIntersection(aubounds), fubounds[0], tlbConstraints, teqConstraints);
                }
            }
        }
    }

    void processAeqFConstraint(GenTypeSolid a, GenTypeSolid f, Map tlbConstraints, Map teqConstraints) {
        block4: {
            block5: {
                block3: {
                    if (!(f instanceof GenTypeTpar)) break block3;
                    GenTypeTpar t = (GenTypeTpar)f;
                    teqConstraints.put(t.getTparName(), a);
                    break block4;
                }
                if (!(f.getArrayComponent() instanceof GenTypeSolid)) break block5;
                GenTypeSolid[] asts = a instanceof GenTypeDeclTpar ? ((GenTypeDeclTpar)a).upperBounds() : new GenTypeSolid[]{a};
                for (int i = 0; i < asts.length; ++i) {
                    JavaType act = asts[i].getArrayComponent();
                    if (!(act instanceof GenTypeSolid)) continue;
                    this.processAeqFConstraint((GenTypeSolid)act, (GenTypeSolid)f.getArrayComponent(), tlbConstraints, teqConstraints);
                }
                break block4;
            }
            GenTypeClass cf = f.asClass();
            GenTypeClass af = a.asClass();
            if (af == null || cf == null || !cf.rawName().equals(af.rawName())) break block4;
            Map fMap = cf.getMap();
            Map aMap = af.getMap();
            if (fMap != null && aMap != null) {
                for (String tpName : fMap.keySet()) {
                    GenTypeParameterizable fPar = (GenTypeParameterizable)fMap.get(tpName);
                    GenTypeParameterizable aPar = (GenTypeParameterizable)aMap.get(tpName);
                    this.processAeqFtpar(aPar, fPar, tlbConstraints, teqConstraints);
                }
            }
        }
    }

    private void processAeqFtpar(GenTypeParameterizable aPar, GenTypeParameterizable fPar, Map tlbConstraints, Map teqConstraints) {
        if (aPar instanceof GenTypeSolid && fPar instanceof GenTypeSolid) {
            this.processAeqFConstraint((GenTypeSolid)aPar, (GenTypeSolid)fPar, tlbConstraints, teqConstraints);
        } else if (aPar instanceof GenTypeWildcard && fPar instanceof GenTypeWildcard) {
            GenTypeSolid[] auBounds;
            GenTypeSolid flBound = fPar.getLowerBound();
            GenTypeSolid[] fuBounds = fPar.getUpperBounds();
            if (flBound != null) {
                GenTypeSolid alBound = aPar.getLowerBound();
                if (alBound != null) {
                    this.processAeqFConstraint(alBound, flBound, tlbConstraints, teqConstraints);
                }
            } else if (fuBounds.length != 0 && (auBounds = aPar.getUpperBounds()).length != 0) {
                this.processAeqFConstraint(IntersectionType.getIntersection(auBounds), fuBounds[0], tlbConstraints, teqConstraints);
            }
        }
    }

    private void processFtoAConstraint(GenTypeSolid a, GenTypeSolid f, Map tlbConstraints, Map teqConstraints) {
        block7: {
            block6: {
                if (!(f.getArrayComponent() instanceof GenTypeSolid)) break block6;
                GenTypeSolid[] asts = a instanceof GenTypeDeclTpar ? ((GenTypeDeclTpar)a).upperBounds() : new GenTypeSolid[]{a};
                for (int i = 0; i < asts.length; ++i) {
                    JavaType act = asts[i].getArrayComponent();
                    if (!(act instanceof GenTypeSolid)) continue;
                    this.processFtoAConstraint((GenTypeSolid)act, (GenTypeSolid)f.getArrayComponent(), tlbConstraints, teqConstraints);
                }
                break block7;
            }
            if (f.asClass() == null) break block7;
            GenTypeClass cf = f.asClass();
            if (!(a instanceof GenTypeTpar)) {
                GenTypeClass[] asts = a.getReferenceSupertypes();
                for (int i = 0; i < asts.length; ++i) {
                    try {
                        GenTypeClass fMapped = cf.mapToSuper(asts[i].rawName());
                        Map aMap = asts[i].getMap();
                        Map fMap = fMapped.getMap();
                        if (aMap == null || fMap == null) continue;
                        for (String tpName : fMap.keySet()) {
                            GenTypeParameterizable fPar = (GenTypeParameterizable)fMap.get(tpName);
                            GenTypeParameterizable aPar = (GenTypeParameterizable)aMap.get(tpName);
                            this.processFtoAtpar(aPar, fPar, tlbConstraints, teqConstraints);
                        }
                        continue;
                    }
                    catch (BadInheritanceChainException bice) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void processFtoAtpar(GenTypeParameterizable aPar, GenTypeParameterizable fPar, Map tlbConstraints, Map teqConstraints) {
        if (fPar instanceof GenTypeSolid) {
            if (aPar instanceof GenTypeSolid) {
                this.processAeqFConstraint((GenTypeSolid)aPar, (GenTypeSolid)fPar, tlbConstraints, teqConstraints);
            } else {
                GenTypeSolid alBound = aPar.getLowerBound();
                if (alBound != null) {
                    this.processAtoFConstraint(alBound, (GenTypeSolid)fPar, tlbConstraints, teqConstraints);
                } else {
                    GenTypeSolid[] auBounds = aPar.getUpperBounds();
                    if (auBounds.length != 0) {
                        this.processFtoAConstraint(auBounds[0], (GenTypeSolid)fPar, tlbConstraints, teqConstraints);
                    }
                }
            }
        } else {
            GenTypeSolid flBound = fPar.getLowerBound();
            if (flBound != null) {
                if (aPar instanceof GenTypeWildcard) {
                    GenTypeSolid alBound = aPar.getLowerBound();
                    if (alBound != null) {
                        this.processAtoFConstraint(alBound, flBound, tlbConstraints, teqConstraints);
                    }
                } else {
                    GenTypeSolid[] fuBounds = fPar.getUpperBounds();
                    GenTypeSolid[] auBounds = aPar.getUpperBounds();
                    if (auBounds.length != 0 && fuBounds.length != 0) {
                        this.processFtoAConstraint(auBounds[0], fuBounds[0], tlbConstraints, teqConstraints);
                    }
                }
            }
        }
    }

    private JavaType getMethodCallReturnType(AST node) throws RecognitionException, SemanticException {
        AST firstArg = node.getFirstChild();
        AST secondArg = firstArg.getNextSibling();
        if (secondArg.getType() != 34) {
            throw new RecognitionException();
        }
        if (firstArg.getType() == 69) {
            String mname = firstArg.getText();
            JavaType[] argumentTypes = this.getExpressionList(secondArg);
            List l = this.imports.getStaticImports(mname);
            MethodCallDesc candidate = this.findImportedMethod(l, mname, argumentTypes);
            if (candidate == null) {
                l = this.imports.getStaticWildcardImports();
                candidate = this.findImportedMethod(l, mname, argumentTypes);
            }
            if (candidate != null) {
                return this.captureConversion(candidate.retType);
            }
            throw new SemanticException();
        }
        if (firstArg.getType() == 68) {
            AST targetNode = firstArg.getFirstChild();
            JavaEntity callTarget = this.getEntity(targetNode);
            JavaType targetType = callTarget.getType();
            ArrayList<GenTypeSolid> typeArgs = new ArrayList<GenTypeSolid>(5);
            JavaType[] argumentTypes = this.getExpressionList(secondArg);
            String methodName = null;
            for (AST searchNode = targetNode.getNextSibling(); searchNode != null; searchNode = searchNode.getNextSibling()) {
                int nodeType = searchNode.getType();
                if (nodeType != 55) {
                    if (nodeType != 69) break;
                    methodName = searchNode.getText();
                    break;
                }
                GenTypeSolid taType = this.getType(searchNode.getFirstChild());
                typeArgs.add(taType);
            }
            if (methodName == null) {
                throw new RecognitionException();
            }
            if (targetType instanceof GenTypeParameterizable && methodName.equals("getClass") && argumentTypes.length == 0) {
                ArrayList<GenTypeExtends> paramsl = new ArrayList<GenTypeExtends>(1);
                paramsl.add(new GenTypeExtends((GenTypeSolid)targetType.getErasedType()));
                return new GenTypeClass((Reflective)new JavaReflective(Class.class), paramsl);
            }
            if (!((targetType = this.captureConversion(targetType)) instanceof GenTypeSolid)) {
                throw new SemanticException();
            }
            GenTypeSolid targetTypeS = (GenTypeSolid)targetType;
            GenTypeClass[] rsts = targetTypeS.getReferenceSupertypes();
            ArrayList suitableMethods = this.getSuitableMethods(methodName, rsts, argumentTypes, typeArgs);
            if (suitableMethods.size() != 0) {
                MethodCallDesc mcd = (MethodCallDesc)suitableMethods.get(0);
                return this.captureConversion(mcd.retType);
            }
            throw new SemanticException();
        }
        throw new RecognitionException();
    }

    private MethodCallDesc findImportedMethod(List imports, String mname, JavaType[] argumentTypes) throws RecognitionException {
        MethodCallDesc candidate = null;
        for (ClassEntity importEntity : imports) {
            List r = importEntity.getStaticMethods(mname);
            for (Method m : r) {
                MethodCallDesc mcd = this.isMethodApplicable(importEntity.getClassType(), Collections.EMPTY_LIST, m, argumentTypes);
                if (mcd == null) continue;
                if (candidate == null) {
                    candidate = mcd;
                    continue;
                }
                if (mcd.compareSpecificity(candidate) != 1) continue;
                candidate = mcd;
            }
        }
        return candidate;
    }

    private ArrayList getSuitableMethods(String methodName, GenTypeClass[] targetTypes, JavaType[] argumentTypes, List typeArgs) throws RecognitionException {
        ArrayList<MethodCallDesc> suitableMethods = new ArrayList<MethodCallDesc>();
        for (int k = 0; k < targetTypes.length; ++k) {
            GenTypeClass targetClass = targetTypes[k];
            try {
                Class<?> c = this.classLoader.loadClass(targetClass.rawName());
                Method[] methods = c.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    MethodCallDesc mcd;
                    if (jutils.isSynthetic(methods[i]) || !methods[i].getName().equals(methodName) || (mcd = this.isMethodApplicable(targetClass, typeArgs, methods[i], argumentTypes)) == null) continue;
                    boolean replaced = false;
                    for (int j = 0; j < suitableMethods.size(); ++j) {
                        MethodCallDesc mc = (MethodCallDesc)suitableMethods.get(j);
                        int compare = mcd.compareSpecificity(mc);
                        if (compare == 1) {
                            suitableMethods.remove(j);
                            --j;
                            continue;
                        }
                        if (compare != -1) continue;
                        replaced = true;
                        break;
                    }
                    if (replaced) continue;
                    suitableMethods.add(mcd);
                }
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
        return suitableMethods;
    }

    JavaType getTypeFromTypeNode(AST node) throws RecognitionException, SemanticException {
        JavaType baseType;
        AST firstChild = node.getFirstChild();
        switch (firstChild.getType()) {
            case 81: {
                baseType = JavaPrimitiveType.getChar();
                break;
            }
            case 80: {
                baseType = JavaPrimitiveType.getByte();
                break;
            }
            case 79: {
                baseType = JavaPrimitiveType.getBoolean();
                break;
            }
            case 82: {
                baseType = JavaPrimitiveType.getShort();
                break;
            }
            case 83: {
                baseType = JavaPrimitiveType.getInt();
                break;
            }
            case 85: {
                baseType = JavaPrimitiveType.getLong();
                break;
            }
            case 84: {
                baseType = JavaPrimitiveType.getFloat();
                break;
            }
            case 86: {
                baseType = JavaPrimitiveType.getDouble();
                break;
            }
            default: {
                baseType = this.getType(firstChild);
            }
        }
        for (AST arrayNode = firstChild.getNextSibling(); arrayNode != null && arrayNode.getType() == 17; arrayNode = arrayNode.getFirstChild()) {
            String xName = "[" + baseType.arrayComponentName();
            try {
                Class<?> arrayClass = Class.forName(xName, false, this.classLoader);
                baseType = new GenTypeArray(baseType, new JavaReflective(arrayClass));
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        return baseType;
    }

    private JavaType unBox(JavaType b) {
        if (b instanceof GenTypeClass) {
            GenTypeClass c = (GenTypeClass)b;
            String cName = c.rawName();
            if (cName.equals("java.lang.Integer")) {
                return JavaPrimitiveType.getInt();
            }
            if (cName.equals("java.lang.Long")) {
                return JavaPrimitiveType.getLong();
            }
            if (cName.equals("java.lang.Short")) {
                return JavaPrimitiveType.getShort();
            }
            if (cName.equals("java.lang.Byte")) {
                return JavaPrimitiveType.getByte();
            }
            if (cName.equals("java.lang.Character")) {
                return JavaPrimitiveType.getChar();
            }
            if (cName.equals("java.lang.Float")) {
                return JavaPrimitiveType.getFloat();
            }
            if (cName.equals("java.lang.Double")) {
                return JavaPrimitiveType.getDouble();
            }
            if (cName.equals("java.lang.Boolean")) {
                return JavaPrimitiveType.getBoolean();
            }
            return b;
        }
        return b;
    }

    private JavaType boxType(JavaType u) {
        if (u instanceof JavaPrimitiveType) {
            if (u.typeIs(JavaType.JT_INT)) {
                return new GenTypeClass(new JavaReflective(Integer.class));
            }
            if (u.typeIs(JavaType.JT_LONG)) {
                return new GenTypeClass(new JavaReflective(Long.class));
            }
            if (u.typeIs(JavaType.JT_SHORT)) {
                return new GenTypeClass(new JavaReflective(Short.class));
            }
            if (u.typeIs(JavaType.JT_BYTE)) {
                return new GenTypeClass(new JavaReflective(Byte.class));
            }
            if (u.typeIs(JavaType.JT_CHAR)) {
                return new GenTypeClass(new JavaReflective(Character.class));
            }
            if (u.typeIs(JavaType.JT_FLOAT)) {
                return new GenTypeClass(new JavaReflective(Float.class));
            }
            if (u.typeIs(JavaType.JT_DOUBLE)) {
                return new GenTypeClass(new JavaReflective(Double.class));
            }
            if (u.typeIs(JavaType.JT_BOOLEAN)) {
                return new GenTypeClass(new JavaReflective(Boolean.class));
            }
            return u;
        }
        return u;
    }

    public static boolean isBoxedBoolean(JavaType t) {
        GenTypeClass ct = t.asClass();
        if (ct != null) {
            return ct.rawName().equals("java.lang.Boolean");
        }
        return false;
    }

    private JavaType maybeBox(JavaType u, boolean box) {
        if (box) {
            return this.boxType(u);
        }
        return u;
    }

    ExprValue getExpressionType(AST node) throws RecognitionException, SemanticException {
        AST fcNode = node.getType() == 28 ? node.getFirstChild() : node;
        switch (fcNode.getType()) {
            case 158: {
                return new ExprValue(this.getTypeFromTypeNode(fcNode));
            }
            case 68: {
                AST firstDotArg = fcNode.getFirstChild();
                AST secondDotArg = firstDotArg.getNextSibling();
                if (secondDotArg.getType() == 158) {
                    JavaType fpType = this.getExpressionType(firstDotArg).getType();
                    if (fpType.asClass() != null) {
                        JavaType type = this.getInnerType(secondDotArg.getFirstChild(), fpType.asClass());
                        return new ExprValue(type);
                    }
                    if (fpType == null) {
                        return null;
                    }
                    throw new SemanticException();
                }
                if (secondDotArg.getType() == 69) {
                    JavaEntity entity = this.getEntity(firstDotArg);
                    entity = entity.getSubentity(secondDotArg.getText());
                    return new ExprValue(entity.getType());
                }
                if (secondDotArg.getType() == 101) {
                    if (!java15) {
                        return new ExprValue(new GenTypeClass(new JavaReflective(Class.class)));
                    }
                    int fdType = firstDotArg.getType();
                    JavaReflective classReflective = new JavaReflective(Class.class);
                    ArrayList<JavaType> l = new ArrayList<JavaType>();
                    if (fdType == 78) {
                        l.add(new GenTypeClass(new JavaReflective(Void.class)));
                    } else {
                        l.add(this.boxType(this.getTypeFromTypeNode(fcNode)));
                    }
                    return new ExprValue(new GenTypeClass((Reflective)classReflective, l));
                }
            }
            case 27: {
                return new ExprValue(this.getMethodCallReturnType(fcNode));
            }
            case 69: {
                JavaEntity entity = this.getEntity(fcNode);
                return new ExprValue(entity.getType());
            }
            case 23: {
                return new ExprValue(this.getTypeFromTypeNode(fcNode.getFirstChild()));
            }
            case 24: {
                JavaType t = this.getExpressionType(fcNode.getFirstChild()).getType();
                JavaType componentType = t.getArrayComponent();
                if (componentType != null) {
                    return new ExprValue(componentType);
                }
                throw new SemanticException();
            }
            case 161: {
                return new ExprValue(new GenTypeClass(new JavaReflective(String.class)));
            }
            case 160: {
                return this.getCharLiteral(fcNode);
            }
            case 159: {
                return this.getIntLiteral(fcNode, false);
            }
            case 163: {
                return this.getLongLiteral(fcNode, false);
            }
            case 162: {
                return this.getFloatLiteral(fcNode, false);
            }
            case 164: {
                return this.getDoubleLiteral(fcNode, false);
            }
            case 155: {
                return BooleanValue.getBooleanValue(true);
            }
            case 156: {
                return BooleanValue.getBooleanValue(false);
            }
            case 145: {
                return new ExprValue(JavaPrimitiveType.getBoolean());
            }
            case 157: {
                return new ExprValue(JavaPrimitiveType.getNull());
            }
            case 32: {
                return this.getExpressionType(fcNode.getFirstChild());
            }
            case 31: {
                AST negExpr = fcNode.getFirstChild();
                switch (negExpr.getType()) {
                    case 159: {
                        return this.getIntLiteral(negExpr, true);
                    }
                    case 163: {
                        return this.getLongLiteral(negExpr, true);
                    }
                    case 162: {
                        return this.getFloatLiteral(negExpr, true);
                    }
                    case 164: {
                        return this.getFloatLiteral(negExpr, true);
                    }
                }
                return this.getExpressionType(negExpr);
            }
            case 73: 
            case 75: 
            case 137: 
            case 138: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 154: {
                return new ExprValue(JavaPrimitiveType.getBoolean());
            }
            case 76: 
            case 77: 
            case 146: {
                JavaType rtype = this.unBox(this.getExpressionType(fcNode.getFirstChild()).getType());
                if (TextParser.isMinorInteger(rtype)) {
                    rtype = JavaPrimitiveType.getInt();
                }
                return new ExprValue(rtype);
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                return this.getExpressionType(fcNode.getFirstChild());
            }
            case 87: 
            case 104: 
            case 139: 
            case 140: 
            case 148: 
            case 149: 
            case 150: {
                int ntype;
                AST leftNode = fcNode.getFirstChild();
                AST rightNode = leftNode.getNextSibling();
                JavaType leftType = this.unBox(this.getExpressionType(leftNode).getType());
                JavaType rightType = this.unBox(this.getExpressionType(rightNode).getType());
                if (leftType.typeIs(JavaType.JT_BOOLEAN) && rightType.typeIs(JavaType.JT_BOOLEAN) && ((ntype = fcNode.getType()) == 104 || ntype == 139 || ntype == 140)) {
                    return new ExprValue(JavaPrimitiveType.getBoolean());
                }
                return new ExprValue(this.binaryNumericPromotion(leftType, rightType));
            }
            case 147: {
                AST leftNode = fcNode.getFirstChild();
                AST rightNode = leftNode.getNextSibling();
                JavaType leftType = this.unBox(this.getExpressionType(leftNode).getType());
                JavaType rightType = this.unBox(this.getExpressionType(rightNode).getType());
                if (leftType == null || rightType == null) {
                    return null;
                }
                if (leftType.toString().equals("java.lang.String")) {
                    return new ExprValue(leftType);
                }
                if (rightType.toString().equals("java.lang.String")) {
                    return new ExprValue(rightType);
                }
                return new ExprValue(this.binaryNumericPromotion(leftType, rightType));
            }
            case 25: 
            case 26: 
            case 151: 
            case 152: {
                return new ExprValue(this.unBox(this.getExpressionType(fcNode.getFirstChild()).getType()));
            }
            case 153: {
                ExprValue oval = this.getExpressionType(fcNode.getFirstChild());
                JavaType ntype = this.unBox(oval.getType());
                if (!ntype.isIntegralType()) {
                    throw new SemanticException();
                }
                if (!oval.knownValue()) {
                    if (ntype.typeIs(JavaType.JT_LONG)) {
                        return new ExprValue(ntype);
                    }
                    return new ExprValue(JavaPrimitiveType.getInt());
                }
                if (ntype.typeIs(JavaType.JT_LONG)) {
                    long newval = oval.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
                    return new NumValue(ntype, new Long(newval));
                }
                int newval = ~oval.intValue();
                return new NumValue(JavaPrimitiveType.getInt(), new Integer(newval));
            }
            case 70: {
                if (Config.usingJava15()) {
                    return new ExprValue(this.questionOperator15(fcNode));
                }
                return new ExprValue(this.questionOperator14(fcNode));
            }
        }
        return null;
    }

    static JavaRecognizer getParser() {
        JavaRecognizer jr = new JavaRecognizer(new ParserSharedInputState());
        jr.setASTNodeClass("bluej.parser.ast.LocatableAST");
        return jr;
    }

    static TokenStream getTokenStream(String s) {
        StringReader r = new StringReader(s);
        EscapedUnicodeReader eur = new EscapedUnicodeReader(r);
        JavaLexer lexer = new JavaLexer(eur);
        lexer.setTokenObjectClass("bluej.parser.ast.LocatableToken");
        lexer.setTabSize(1);
        eur.setAttachedScanner(lexer);
        JavaTokenFilter filter = new JavaTokenFilter(lexer);
        return filter;
    }

    static boolean isAccessible(Class declaringClass, int mods, String pkg) {
        if (Modifier.isPrivate(mods)) {
            return false;
        }
        if (Modifier.isPublic(mods)) {
            return true;
        }
        String className = declaringClass.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            lastDot = 0;
        }
        String classPkg = className.substring(0, lastDot);
        return classPkg.equals(pkg);
    }

    static Field getAccessibleField(Class c, String fieldName, String pkg, boolean searchSupertypes) throws NoSuchFieldException {
        String className = c.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            lastDot = 0;
        }
        String classPkg = className.substring(0, lastDot);
        boolean pprivateAccessible = classPkg.equals(pkg);
        try {
            Field[] cfields = c.getDeclaredFields();
            for (int i = 0; i < cfields.length; ++i) {
                int mods;
                if (!cfields[i].getName().equals(fieldName) || Modifier.isPrivate(mods = cfields[i].getModifiers()) || !pprivateAccessible && !Modifier.isPublic(mods)) continue;
                return cfields[i];
            }
            if (searchSupertypes) {
                Class<?>[] ifaces = c.getInterfaces();
                for (int i = 0; i < ifaces.length; ++i) {
                    try {
                        return TextParser.getAccessibleField(ifaces[i], fieldName, pkg, true);
                    }
                    catch (NoSuchFieldException nsfe) {
                        continue;
                    }
                }
                Class sclass = c.getSuperclass();
                if (sclass != null) {
                    return TextParser.getAccessibleField(sclass, fieldName, pkg, true);
                }
            }
        }
        catch (LinkageError le) {
            // empty catch block
        }
        throw new NoSuchFieldException();
    }

    static List getAccessibleStaticMethods(Class c, String methodName, String pkg) {
        String className = c.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            lastDot = 0;
        }
        String classPkg = className.substring(0, lastDot);
        boolean pprivateAccessible = classPkg.equals(pkg);
        try {
            ArrayList<Method> rlist = new ArrayList<Method>();
            Method[] cmethods = c.getDeclaredMethods();
            for (int i = 0; i < cmethods.length; ++i) {
                int mods;
                if (!cmethods[i].getName().equals(methodName) || Modifier.isPrivate(mods = cmethods[i].getModifiers()) || !Modifier.isStatic(mods) || !Modifier.isPublic(mods) && !pprivateAccessible || jutils.isSynthetic(cmethods[i])) continue;
                rlist.add(cmethods[i]);
            }
            return rlist;
        }
        catch (LinkageError le) {
            return Collections.EMPTY_LIST;
        }
    }

    public class DeclaredVar {
        private boolean isVarInit = false;
        private JavaType declVarType;
        private String varName;
        private boolean isFinal = false;

        public DeclaredVar(boolean isVarInit, boolean isFinal, JavaType varType, String varName) {
            this.isVarInit = isVarInit;
            this.declVarType = varType;
            this.varName = varName;
            this.isFinal = isFinal;
        }

        public boolean checkVarInit() {
            return this.isVarInit;
        }

        public JavaType getDeclaredVarType() {
            return this.declVarType;
        }

        public String getName() {
            return this.varName;
        }

        public boolean checkFinal() {
            return this.isFinal;
        }
    }

    class NumValue
    extends ExprValue {
        private Number val;

        NumValue(JavaType type, Number val) {
            super(type);
            this.val = val;
        }

        public boolean knownValue() {
            return true;
        }

        public int intValue() {
            return this.val.intValue();
        }

        public long longValue() {
            return this.val.longValue();
        }

        public float floatValue() {
            return this.val.floatValue();
        }

        public double doubleValue() {
            return this.val.doubleValue();
        }
    }

    static class BooleanValue
    extends ExprValue {
        boolean val;
        public static BooleanValue trueVal = null;
        public static BooleanValue falseVal = null;

        private BooleanValue(boolean val) {
            super(JavaPrimitiveType.getBoolean());
            this.val = val;
        }

        public static BooleanValue getBooleanValue(boolean val) {
            if (val) {
                if (trueVal == null) {
                    trueVal = new BooleanValue(true);
                }
                return trueVal;
            }
            if (falseVal == null) {
                falseVal = new BooleanValue(false);
            }
            return falseVal;
        }

        public boolean booleanValue() {
            return this.val;
        }
    }

    static class ExprValue {
        public JavaType type;

        public ExprValue(JavaType type) {
            this.type = type;
        }

        public JavaType getType() {
            return this.type;
        }

        public boolean knownValue() {
            return false;
        }

        public int intValue() {
            throw new UnsupportedOperationException();
        }

        public long longValue() {
            throw new UnsupportedOperationException();
        }

        public float floatValue() {
            throw new UnsupportedOperationException();
        }

        public double doubleValue() {
            throw new UnsupportedOperationException();
        }

        public boolean booleanValue() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueEntity
    extends JavaEntity {
        JavaType type;
        String name;

        ValueEntity(JavaType type) {
            this.type = type;
        }

        ValueEntity(JavaType type, String name) {
            this.type = type;
            this.name = name;
        }

        JavaType getType() {
            return this.type;
        }

        JavaEntity getSubentity(String name) throws SemanticException {
            Class<?> c;
            if (!(this.type instanceof GenTypeClass)) {
                throw new SemanticException();
            }
            GenTypeClass thisClass = (GenTypeClass)TextParser.this.captureConversion(this.type);
            Reflective r = thisClass.getReflective();
            try {
                c = TextParser.this.classLoader.loadClass(r.getName());
            }
            catch (ClassNotFoundException cnfe) {
                throw new SemanticException();
            }
            Field f = null;
            try {
                JavaType fieldType;
                f = TextParser.getAccessibleField(c, name, TextParser.this.packageScope, true);
                Class<?> declarer = f.getDeclaringClass();
                Map tparMap = thisClass.mapToSuper(declarer.getName()).getMap();
                if (tparMap != null || Modifier.isStatic(f.getModifiers())) {
                    fieldType = JavaUtils.getJavaUtils().getFieldType(f);
                    if (tparMap != null) {
                        fieldType = fieldType.mapTparsToTypes(tparMap);
                    }
                    fieldType = TextParser.this.captureConversion(fieldType);
                } else {
                    fieldType = JavaUtils.getJavaUtils().getRawFieldType(f);
                }
                if (name == null) {
                    return new ValueEntity(fieldType);
                }
                return new ValueEntity(fieldType, this.name + "." + name);
            }
            catch (NoSuchFieldException nsfe) {
                throw new SemanticException();
            }
        }

        String getName() {
            return this.name;
        }

        public boolean isClass() {
            return false;
        }
    }

    class TypeEntity
    extends ClassEntity {
        Class thisClass;
        List tparams;
        GenTypeClass outer;

        TypeEntity(Class c) {
            this.thisClass = c;
            this.tparams = Collections.EMPTY_LIST;
        }

        TypeEntity(Class c, List tparams) {
            this.thisClass = c;
            this.tparams = tparams;
        }

        TypeEntity(Class c, GenTypeClass outer) {
            this.thisClass = c;
            this.outer = outer;
            this.tparams = Collections.EMPTY_LIST;
        }

        TypeEntity(Class c, GenTypeClass outer, List tparams) {
            this.thisClass = c;
            this.outer = outer;
            this.tparams = tparams;
        }

        ClassEntity setTypeParams(List tparams) throws SemanticException {
            return new TypeEntity(this.thisClass, this.outer, tparams);
        }

        JavaType getType() {
            return this.getClassType();
        }

        GenTypeClass getClassType() {
            return new GenTypeClass(new JavaReflective(this.thisClass), this.tparams, this.outer);
        }

        JavaEntity getSubentity(String name) throws SemanticException {
            Field f = null;
            try {
                JavaType fieldType;
                f = TextParser.getAccessibleField(this.thisClass, name, TextParser.this.packageScope, true);
                Map tparmap = this.getClassType().getMap();
                if (tparmap == null && !Modifier.isStatic(f.getModifiers())) {
                    fieldType = JavaUtils.getJavaUtils().getRawFieldType(f);
                } else {
                    tparmap = TextParser.this.captureConversion(this.getClassType(), new HashMap()).getMap();
                    fieldType = JavaUtils.getJavaUtils().getFieldType(f);
                    if (tparmap != null) {
                        fieldType = fieldType.mapTparsToTypes(tparmap);
                    }
                    fieldType = TextParser.this.captureConversion(fieldType);
                }
                return new ValueEntity(fieldType, this.getName() + "." + name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return this.getPackageOrClassMember(name);
            }
        }

        PackageOrClass getPackageOrClassMember(String name) throws SemanticException {
            return new TypeEntity(this.getMemberClass(name), this.getClassType());
        }

        Class getMemberClass(String name) throws SemanticException {
            try {
                Class<?> c = TextParser.this.classLoader.loadClass(this.thisClass.getName() + '$' + name);
                return c;
            }
            catch (ClassNotFoundException cnfe) {
                throw new SemanticException();
            }
        }

        ClassEntity getStaticMemberClass(String name) throws SemanticException {
            Class c = this.getMemberClass(name);
            if (Modifier.isStatic(c.getModifiers())) {
                return new TypeEntity(c, (GenTypeClass)this.getType());
            }
            throw new SemanticException();
        }

        JavaEntity getStaticField(String name) throws SemanticException {
            Field f = null;
            try {
                f = TextParser.getAccessibleField(this.thisClass, name, TextParser.this.packageScope, false);
                if (Modifier.isStatic(f.getModifiers())) {
                    JavaType fieldType = JavaUtils.getJavaUtils().getFieldType(f);
                    fieldType = TextParser.this.captureConversion(fieldType);
                    return new ValueEntity(fieldType, this.getName() + "." + name);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            throw new SemanticException();
        }

        List getStaticMethods(String name) {
            return TextParser.getAccessibleStaticMethods(this.thisClass, name, TextParser.this.packageScope);
        }

        String getName() {
            return this.getType().toString();
        }

        public boolean isClass() {
            return true;
        }
    }

    class PackageEntity
    extends PackageOrClass {
        String packageName;

        PackageEntity(String pname) {
            this.packageName = pname;
        }

        JavaType getType() throws SemanticException {
            throw new SemanticException();
        }

        void setTypeParams(List tparams) throws SemanticException {
            throw new SemanticException();
        }

        JavaEntity getSubentity(String name) throws SemanticException {
            try {
                Class<?> c = TextParser.this.classLoader.loadClass(this.packageName + '.' + name);
                return new TypeEntity(c);
            }
            catch (ClassNotFoundException cnfe) {
                return new PackageEntity(this.packageName + '.' + name);
            }
        }

        PackageOrClass getPackageOrClassMember(String name) throws SemanticException {
            return (PackageOrClass)this.getSubentity(name);
        }

        public String getName() {
            return this.packageName;
        }

        public boolean isClass() {
            return false;
        }
    }

    private class MethodCallDesc {
        public Method method;
        public List argTypes;
        public boolean vararg;
        public boolean autoboxing;
        public JavaType retType;

        public MethodCallDesc(Method m, List argTypes, boolean vararg, boolean autoboxing, JavaType retType) {
            this.method = m;
            this.argTypes = argTypes;
            this.vararg = vararg;
            this.autoboxing = autoboxing;
            this.retType = retType;
        }

        public int compareSpecificity(MethodCallDesc other) {
            if (other.vararg && !this.vararg) {
                return 1;
            }
            if (!other.vararg && this.vararg) {
                return -1;
            }
            Iterator i = this.argTypes.iterator();
            Iterator j = other.argTypes.iterator();
            int upCount = 0;
            int downCount = 0;
            while (i.hasNext()) {
                JavaType otherArg;
                JavaType myArg = (JavaType)i.next();
                if (myArg.isAssignableFrom(otherArg = (JavaType)j.next())) {
                    if (otherArg.isAssignableFrom(myArg)) continue;
                    ++upCount;
                    continue;
                }
                if (!otherArg.isAssignableFrom(myArg)) continue;
                ++downCount;
            }
            if (upCount > 0 && downCount == 0) {
                return -1;
            }
            if (downCount > 0 && upCount == 0) {
                return 1;
            }
            this.method.getModifiers();
            boolean isAbstract = Modifier.isAbstract(this.method.getModifiers());
            boolean otherAbstract = Modifier.isAbstract(other.method.getModifiers());
            if (isAbstract && !otherAbstract) {
                return -1;
            }
            if (!isAbstract && otherAbstract) {
                return 1;
            }
            return 0;
        }
    }
}

