/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.Config;
import bluej.parser.ClassEntity;
import bluej.parser.JavaEntity;
import bluej.parser.PackageOrClass;
import bluej.parser.SemanticException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportsCollection {
    private Map normalImports = new HashMap();
    private List wildcardImports = new ArrayList();
    private List staticWildcardImports = new ArrayList();
    private Map staticImports = new HashMap();

    public void clear() {
        this.normalImports.clear();
        this.wildcardImports.clear();
    }

    public void addNormalImport(String name, JavaEntity importEntity) {
        this.normalImports.put(name, importEntity);
    }

    public void addWildcardImport(PackageOrClass importEntity) {
        this.wildcardImports.add(importEntity);
    }

    public void addStaticImport(String name, ClassEntity importEntity) {
        ArrayList<ClassEntity> l = (ArrayList<ClassEntity>)this.staticImports.get(name);
        if (l == null) {
            l = new ArrayList<ClassEntity>();
            this.staticImports.put(name, l);
        }
        l.add(importEntity);
    }

    public void addStaticWildcardImport(ClassEntity importEntity) {
        this.staticWildcardImports.add(importEntity);
    }

    public ClassEntity getTypeImport(String name) {
        ClassEntity r2 = (ClassEntity)this.normalImports.get(name);
        if (r2 != null) {
            return r2;
        }
        List l = (List)this.staticImports.get(name);
        if (l != null) {
            for (ClassEntity r2 : l) {
                try {
                    r2 = (ClassEntity)r2.getPackageOrClassMember(name);
                    return r2;
                }
                catch (SemanticException se) {
                }
            }
        }
        return null;
    }

    public List getStaticImports(String name) {
        List l = (List)this.staticImports.get(name);
        if (l == null) {
            l = Collections.EMPTY_LIST;
        }
        return l;
    }

    public List getStaticWildcardImports() {
        return this.staticWildcardImports;
    }

    public ClassEntity getTypeImportWC(String name) {
        PackageOrClass member;
        for (PackageOrClass importEntity : this.wildcardImports) {
            try {
                member = importEntity.getPackageOrClassMember(name);
                if (!member.isClass()) continue;
                return (ClassEntity)member;
            }
            catch (SemanticException se) {
            }
        }
        for (PackageOrClass importEntity : this.staticWildcardImports) {
            try {
                member = ((ClassEntity)importEntity).getStaticMemberClass(name);
                return member;
            }
            catch (SemanticException se) {
            }
        }
        return null;
    }

    public String toString() {
        String rr = "";
        for (JavaEntity importEntity : this.normalImports.values()) {
            rr = rr + "import ";
            rr = rr + importEntity.getName() + ";" + Config.nl;
        }
        for (JavaEntity importEntity : this.wildcardImports) {
            rr = rr + "import ";
            rr = rr + importEntity.getName() + ".*;" + Config.nl;
        }
        for (String importName : this.staticImports.keySet()) {
            List l = (List)this.staticImports.get(importName);
            for (ClassEntity importEntity : l) {
                rr = rr + "import static " + importEntity.getName();
                rr = rr + "." + importName + ";" + Config.nl;
            }
        }
        for (JavaEntity importEntity : this.staticWildcardImports) {
            rr = rr + "import static " + importEntity.getName();
            rr = rr + ".*;" + Config.nl;
        }
        return rr;
    }
}

