/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.groupwork.HistoryInfo;
import bluej.groupwork.ui.HistoryListModel;
import bluej.utility.DBox;
import bluej.utility.MultiWrapLabel;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class HistoryListRenderer
extends DBox
implements ListCellRenderer {
    private HistoryListModel model;
    private JLabel topLabel;
    private MultiWrapLabel commentArea;
    private JLabel spacerLabel;
    private JTextArea filesArea;
    private JScrollPane container;
    private int index;
    private Box filesBox;
    private Box commentBox;

    public HistoryListRenderer(HistoryListModel model) {
        super(DBox.Y_AXIS, 0.0f);
        this.model = model;
        this.topLabel = new JLabel();
        Font font = this.topLabel.getFont();
        this.topLabel.setAlignmentX(0.0f);
        this.topLabel.setFont(font.deriveFont(1));
        this.add(this.topLabel);
        this.filesBox = new Box(0);
        JLabel spaceLabel = new JLabel("    ");
        this.filesBox.add(spaceLabel);
        this.filesArea = new JTextArea();
        this.filesArea.setAlignmentX(0.0f);
        this.filesArea.setFont(font.deriveFont(0));
        this.filesBox.add(this.filesArea);
        this.filesBox.setAlignmentX(0.0f);
        this.add(this.filesBox);
        this.commentBox = new Box(0);
        this.spacerLabel = new JLabel("        ");
        this.commentBox.add(this.spacerLabel);
        this.commentArea = new MultiWrapLabel();
        this.commentArea.setAlignmentX(0.0f);
        this.commentArea.setFont(font.deriveFont(0));
        this.commentBox.add(this.commentArea);
        this.commentBox.setAlignmentX(0.0f);
        this.add(this.commentBox);
    }

    public void setWrapMode(JScrollPane container) {
        this.container = container;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        HistoryInfo info = (HistoryInfo)value;
        String topText = info.getDate() + " " + info.getRevision() + " " + info.getUser();
        String[] files = info.getFiles();
        String filesText = files[0];
        for (int i = 1; i < files.length; ++i) {
            filesText = filesText + "\n" + files[i];
        }
        this.filesArea.setText(filesText);
        this.filesArea.invalidate();
        this.filesBox.invalidate();
        this.topLabel.setText(topText);
        String commentText = info.getComment();
        this.commentArea.setText(commentText);
        this.commentBox.invalidate();
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            this.filesArea.setForeground(list.getSelectionForeground());
            this.filesArea.setBackground(list.getSelectionBackground());
            this.setOpaque(true);
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.filesArea.setForeground(list.getForeground());
            this.filesArea.setBackground(list.getBackground());
            this.setOpaque(false);
        }
        if (cellHasFocus) {
            this.setBorder(new LineBorder(list.getSelectionForeground(), 1));
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        if (this.container != null) {
            Rectangle bbounds = this.container.getViewportBorderBounds();
            int listWidth = bbounds.width;
            Insets containerInsets = this.container.getViewport().getInsets();
            listWidth -= containerInsets.left + containerInsets.right;
            listWidth -= this.spacerLabel.getPreferredSize().width;
            this.commentArea.setWrapWidth(listWidth -= this.getInsets().left + this.getInsets().right);
            this.commentArea.invalidate();
        }
        this.invalidate();
        this.validate();
        this.model.setCellHeight(index, this.getPreferredSize().height);
        this.index = index;
        return this;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.validate();
        if (this.getPreferredSize().getWidth() < (double)width) {
            this.model.changeChell(this.index);
        }
    }

    public boolean isValidateRoot() {
        return true;
    }
}

