/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.HistoryInfo;
import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.DateCompare;
import bluej.groupwork.ui.HistoryListModel;
import bluej.groupwork.ui.HistoryListRenderer;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.DBox;
import bluej.utility.DBoxLayout;
import bluej.utility.EscapeDialog;
import bluej.utility.SwingWorker;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HistoryFrame
extends EscapeDialog {
    Project project;
    ActivityIndicator activityBar;
    HistoryWorker worker;
    HistoryListModel listModel = new HistoryListModel();
    HistoryListRenderer renderer = new HistoryListRenderer(this.listModel);
    JList historyList;
    JScrollPane historyPane;
    List historyInfoList;
    JComboBox fileFilterCombo;
    JComboBox userFilterCombo;
    ActionListener filterActionListener;
    JLabel filterSpacer;

    public HistoryFrame(PkgMgrFrame pmf) {
        super((Frame)null, Config.getString("team.history.title"));
        this.project = pmf.getProject();
        this.buildUI();
        this.pack();
    }

    private void buildUI() {
        JPanel contentPane = new JPanel();
        DBoxLayout layout = new DBoxLayout(DBoxLayout.Y_AXIS, 0, 5);
        contentPane.setLayout(layout);
        contentPane.setBorder(BlueJTheme.dialogBorder);
        this.setContentPane(contentPane);
        this.historyList = new JList(this.listModel){

            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        this.historyList.setCellRenderer(this.renderer);
        this.historyPane = new JScrollPane(this.historyList);
        this.historyPane.setAlignmentX(0.0f);
        this.historyPane.setVerticalScrollBarPolicy(20);
        contentPane.add(this.historyPane);
        ArrayList<HistoryInfo> tempList = new ArrayList<HistoryInfo>(5);
        HistoryInfo tempInfo = new HistoryInfo(new String[]{"somepath/abcdefg.java"}, "1.1", "2006/11/34 12:34:56", "abraham", "this is the expected comment length of comments");
        for (int i = 0; i < 8; ++i) {
            tempList.add(tempInfo);
        }
        this.listModel.setListData(tempList);
        Dimension size = this.historyList.getPreferredSize();
        this.listModel.setListData(Collections.EMPTY_LIST);
        this.historyList.setPreferredSize(size);
        contentPane.add(Box.createVerticalStrut(5));
        DBox filterBox = new DBox(DBox.X_AXIS, 0, 11, 0.5f);
        filterBox.setAxisBounded(DBox.Y_AXIS, true);
        filterBox.add(new JLabel(Config.getString("team.history.filefilter") + " "));
        this.fileFilterCombo = new JComboBox();
        this.fileFilterCombo.setEnabled(false);
        filterBox.add(this.fileFilterCombo);
        filterBox.add(new JLabel(Config.getString("team.history.userfilter") + " "));
        this.userFilterCombo = new JComboBox();
        this.userFilterCombo.setEnabled(false);
        filterBox.add(this.userFilterCombo);
        this.filterSpacer = new JLabel("                              ");
        this.userFilterCombo.addItem("         ");
        this.fileFilterCombo.addItem("               ");
        filterBox.add(this.filterSpacer);
        filterBox.setAlignmentX(0.0f);
        contentPane.add(filterBox);
        this.filterActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistoryFrame.this.refilter();
            }
        };
        contentPane.add(Box.createVerticalStrut(12));
        Box buttonBox = new Box(0);
        this.activityBar = new ActivityIndicator();
        buttonBox.add(this.activityBar);
        buttonBox.add(Box.createHorizontalGlue());
        JButton closeButton = new JButton(Config.getString("close"));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (HistoryFrame.this.worker != null) {
                    HistoryFrame.this.worker.cancel();
                }
                HistoryFrame.this.dispose();
            }
        });
        buttonBox.add(closeButton);
        buttonBox.setAlignmentX(0.0f);
        contentPane.add(buttonBox);
    }

    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis) {
            Repository repository = this.project.getRepository();
            if (repository != null) {
                this.worker = new HistoryWorker(repository);
                this.worker.start();
                this.activityBar.setRunning(true);
            }
        } else if (this.worker != null) {
            this.worker.cancel();
        }
    }

    private void refilter() {
        List<HistoryInfo> displayList;
        String user = null;
        int userIndex = this.userFilterCombo.getSelectedIndex();
        if (userIndex != 0) {
            user = (String)this.userFilterCombo.getItemAt(userIndex);
        }
        String file = null;
        int fileIndex = this.fileFilterCombo.getSelectedIndex();
        if (fileIndex != 0) {
            file = (String)this.fileFilterCombo.getItemAt(fileIndex);
        }
        if (user == null && file == null) {
            displayList = this.historyInfoList;
        } else {
            displayList = new ArrayList();
            for (HistoryInfo info : this.historyInfoList) {
                if (user != null && !info.getUser().equals(user) || file != null && !this.hinfoHasFile(info, file)) continue;
                displayList.add(info);
            }
        }
        this.listModel.setListData(displayList);
    }

    private boolean hinfoHasFile(HistoryInfo info, String file) {
        String[] files = info.getFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].equals(file)) continue;
            return true;
        }
        return false;
    }

    private void resetFilterBoxes() {
        HashSet<String> users = new HashSet<String>();
        HashSet<String> files = new HashSet<String>();
        for (HistoryInfo info : this.historyInfoList) {
            String[] infoFiles = info.getFiles();
            for (int j = 0; j < infoFiles.length; ++j) {
                files.add(infoFiles[j]);
            }
            users.add(info.getUser());
        }
        ArrayList usersList = new ArrayList(users);
        Collections.sort(usersList);
        ArrayList filesList = new ArrayList(files);
        Collections.sort(filesList);
        this.userFilterCombo.removeAllItems();
        this.userFilterCombo.addItem(Config.getString("team.history.allUsers"));
        Iterator i = usersList.iterator();
        while (i.hasNext()) {
            this.userFilterCombo.addItem(i.next());
        }
        this.userFilterCombo.addActionListener(this.filterActionListener);
        this.userFilterCombo.setEnabled(true);
        this.fileFilterCombo.removeAllItems();
        this.fileFilterCombo.addItem(Config.getString("team.history.allFiles"));
        i = filesList.iterator();
        while (i.hasNext()) {
            this.fileFilterCombo.addItem(i.next());
        }
        this.fileFilterCombo.addActionListener(this.filterActionListener);
        this.fileFilterCombo.setEnabled(true);
        this.filterSpacer.setVisible(false);
    }

    private class HistoryWorker
    extends SwingWorker
    implements LogHistoryListener {
        private List responseList = new ArrayList();
        private TeamworkCommand command;
        private TeamworkCommandResult response;

        public HistoryWorker(Repository repository) {
            this.command = repository.getLogHistory(this);
        }

        public Object construct() {
            this.response = this.command.getResult();
            return this.response;
        }

        public void logInfoAvailable(HistoryInfo hInfo) {
            this.responseList.add(hInfo);
        }

        public void finished() {
            if (this.command != null) {
                HistoryFrame.this.activityBar.setRunning(false);
                this.command = null;
                if (this.response.isError()) {
                    TeamUtils.handleServerResponse(this.response, HistoryFrame.this);
                    HistoryFrame.this.setVisible(false);
                } else {
                    Collections.sort(this.responseList, new DateCompare());
                    HistoryFrame.this.historyList.setPreferredSize(null);
                    HistoryFrame.this.renderer.setWrapMode(HistoryFrame.this.historyPane);
                    HistoryFrame.this.listModel.setListData(this.responseList);
                    HistoryFrame.this.historyInfoList = this.responseList;
                    HistoryFrame.this.resetFilterBoxes();
                }
            }
        }

        public void cancel() {
            if (this.command != null) {
                HistoryFrame.this.activityBar.setRunning(false);
                this.command.cancel();
                this.command = null;
            }
        }
    }
}

