/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.Project;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ConflictsDialog
extends JDialog {
    private JLabel heading;
    private List bluejConflicts;
    private List nonBluejConflicts;
    private Project project;

    public ConflictsDialog(Project project, List bluejConflicts, List nonBlueJConflicts) {
        this.project = project;
        this.bluejConflicts = bluejConflicts;
        this.nonBluejConflicts = nonBlueJConflicts;
        this.setTitle(Config.getString("team.conflicts.title"));
        this.makeWindow();
    }

    private void makeWindow() {
        JPanel mainPanel = new JPanel();
        JPanel bluejConflictsPanel = this.makeConflictsPanel(Config.getString("team.conflicts.classes"), this.bluejConflicts);
        JPanel nonBluejConflictsPanel = this.makeConflictsPanel(Config.getString("team.conflicts.classes"), this.nonBluejConflicts);
        JPanel buttonPanel = this.makeButtonPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.generalBorder);
        mainPanel.add(bluejConflictsPanel);
        if (this.nonBluejConflicts.size() > 0) {
            mainPanel.add(nonBluejConflictsPanel);
        }
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.teamwork.conflicts", ConflictsDialog.this.getLocation());
            }
        });
        this.setLocation(Config.getLocation("bluej.teamwork.conflicts"));
        this.pack();
    }

    private JPanel makeConflictsPanel(String headline, List conflicts) {
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        labelPanel.setBorder(BlueJTheme.dialogBorder);
        labelPanel.setAlignmentX(0.0f);
        this.heading = new JLabel(headline);
        Font smallFont = this.heading.getFont().deriveFont(1, 12.0f);
        this.heading.setFont(smallFont);
        labelPanel.add(this.heading);
        labelPanel.add(Box.createVerticalStrut(5));
        JPanel conflictsPanel = new JPanel();
        conflictsPanel.setLayout(new BoxLayout(conflictsPanel, 1));
        conflictsPanel.setAlignmentX(0.0f);
        for (String conflict : conflicts) {
            conflictsPanel.add(new JLabel(conflict));
        }
        JScrollPane scrollPane = new JScrollPane(conflictsPanel);
        labelPanel.add(scrollPane);
        return labelPanel;
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton closeButton = new JButton(Config.getString("close"));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConflictsDialog.this.setVisible(false);
            }
        });
        JButton resolveButton = new JButton(Config.getString("team.conflicts.show"));
        resolveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConflictsDialog.this.project.openEditorsForSelectedTargets();
                ConflictsDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(resolveButton);
        buttonPanel.add(resolveButton);
        buttonPanel.add(closeButton);
        resolveButton.setEnabled(this.bluejConflicts.size() > 0);
        return buttonPanel;
    }
}

