/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.utility.DBox;
import bluej.utility.EscapeDialog;
import bluej.utility.MultiWrapLabel;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class CheckConnectionDialog
extends EscapeDialog {
    private ActivityIndicator activityIndicator;
    private MultiWrapLabel connLabel;
    private JButton closeButton;
    private TeamSettings settings;
    private TeamworkProvider provider;

    public CheckConnectionDialog(Dialog owner, TeamworkProvider provider, TeamSettings settings) {
        super(owner, true);
        this.setTitle(Config.getString("team.settings.checkConnection"));
        this.provider = provider;
        this.settings = settings;
        this.buildUI();
        this.setLocationRelativeTo(owner);
    }

    private void buildUI() {
        DBox contentPane = new DBox(DBox.Y_AXIS, 0, 11, 0.0f);
        contentPane.setBorder(BlueJTheme.dialogBorder);
        this.setContentPane(contentPane);
        this.connLabel = new MultiWrapLabel(Config.getString("team.checkconn.checking"));
        contentPane.add(this.connLabel);
        this.activityIndicator = new ActivityIndicator();
        this.activityIndicator.setRunning(true);
        contentPane.add(this.activityIndicator);
        this.closeButton = BlueJTheme.getCancelButton();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CheckConnectionDialog.this.setVisible(false);
            }
        });
        contentPane.add(this.closeButton);
        this.pack();
    }

    public void setVisible(boolean vis) {
        if (vis) {
            new Thread(){

                public void run() {
                    final TeamworkCommandResult res = CheckConnectionDialog.this.validateConnection();
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (!res.isError()) {
                                CheckConnectionDialog.this.connLabel.setText(Config.getString("team.checkconn.ok"));
                            } else {
                                CheckConnectionDialog.this.connLabel.setText(Config.getString("team.checkconn.bad") + System.getProperty("line.separator") + System.getProperty("line.separator") + res.getErrorMessage());
                            }
                            CheckConnectionDialog.this.activityIndicator.setRunning(false);
                            CheckConnectionDialog.this.closeButton.setText(BlueJTheme.getCloseLabel());
                            CheckConnectionDialog.this.pack();
                        }
                    });
                }
            }.start();
        }
        super.setVisible(vis);
    }

    private TeamworkCommandResult validateConnection() {
        return this.provider.checkConnection(this.settings);
    }
}

