/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.UpdateListener;
import bluej.groupwork.UpdateResults;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnRepository;
import bluej.utility.Debug;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnUpdateToCommand
extends SvnCommand
implements UpdateResults {
    private long version;
    private Set<File> files;
    private Set<File> forceFiles;
    private UpdateListener listener;
    private List<File> conflicts = new ArrayList<File>();
    private Set<File> binaryConflicts = new HashSet<File>();

    public SvnUpdateToCommand(SvnRepository repository, UpdateListener listener, long version, Set<File> files, Set<File> forceFiles) {
        super(repository);
        this.version = version;
        this.files = files;
        this.forceFiles = forceFiles;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected TeamworkCommandResult doCommand() {
        block45: {
            SVNClientInterface client = this.getClient();
            final ArrayList addedList = new ArrayList();
            final ArrayList updatedList = new ArrayList();
            final ArrayList removedList = new ArrayList();
            final ArrayList removedDirs = new ArrayList();
            String[] paths = new String[this.forceFiles.size() + this.files.size()];
            int j = 0;
            for (File file : this.forceFiles) {
                paths[j++] = file.getAbsolutePath();
                file.delete();
            }
            for (File file : this.files) {
                paths[j++] = file.getAbsolutePath();
            }
            client.notification2(new Notify2(){

                public void onNotify(NotifyInformation ninfo) {
                    int action;
                    if (ninfo.getKind() == 1 || ninfo.getKind() == 0) {
                        int action2 = ninfo.getAction();
                        if (ninfo.getPath() != null) {
                            File file = new File(ninfo.getPath());
                            if (action2 == 9) {
                                addedList.add(file);
                            } else if (action2 == 10) {
                                updatedList.add(file);
                                if (ninfo.getContentState() == 7) {
                                    SvnUpdateToCommand.this.conflicts.add(file);
                                }
                            } else if (action2 == 8) {
                                removedList.add(file);
                            }
                        }
                    } else if (ninfo.getKind() == 2 && (action = ninfo.getAction()) == 8) {
                        removedDirs.add(new File(ninfo.getPath()));
                    }
                }
            });
            client.update(paths, Revision.getInstance((long)this.version), true, false);
            Object var11_12 = null;
            client.notification2(null);
            Iterator<Object> i = addedList.iterator();
            while (i.hasNext()) {
                this.listener.fileAdded((File)i.next());
            }
            i = updatedList.iterator();
            while (i.hasNext()) {
                this.listener.fileUpdated((File)i.next());
            }
            i = removedList.iterator();
            while (i.hasNext()) {
                this.listener.fileRemoved((File)i.next());
            }
            i = removedDirs.iterator();
            while (i.hasNext()) {
                this.listener.dirRemoved((File)i.next());
            }
            if (!this.conflicts.isEmpty()) {
                i = this.conflicts.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    try {
                        PropertyData pdata = client.propertyGet(file.getAbsolutePath(), "svn:mime-type");
                        if ("application/octet-stream".equals(pdata.getValue())) {
                            i.remove();
                            this.binaryConflicts.add(file);
                            continue;
                        }
                        client.resolved(file.getAbsolutePath(), false);
                    }
                    catch (ClientException ce2) {
                        Debug.message("Subversion client exception when resolving conflicts: " + ce2.getLocalizedMessage());
                        Debug.message("   (on file: " + file + ")");
                    }
                }
            }
            if (!this.conflicts.isEmpty() || !this.binaryConflicts.isEmpty()) {
                this.listener.handleConflicts(this);
            }
            break block45;
            {
                catch (ClientException ce) {
                    if (!this.isCancelled()) {
                        TeamworkCommandError teamworkCommandError = new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
                        Object var11_13 = null;
                        client.notification2(null);
                        i = addedList.iterator();
                        while (i.hasNext()) {
                            this.listener.fileAdded((File)i.next());
                        }
                        i = updatedList.iterator();
                        while (i.hasNext()) {
                            this.listener.fileUpdated((File)i.next());
                        }
                        i = removedList.iterator();
                        while (i.hasNext()) {
                            this.listener.fileRemoved((File)i.next());
                        }
                        i = removedDirs.iterator();
                        while (i.hasNext()) {
                            this.listener.dirRemoved((File)i.next());
                        }
                        if (!this.conflicts.isEmpty()) {
                            i = this.conflicts.iterator();
                            while (i.hasNext()) {
                                File file = (File)i.next();
                                try {
                                    PropertyData pdata = client.propertyGet(file.getAbsolutePath(), "svn:mime-type");
                                    if ("application/octet-stream".equals(pdata.getValue())) {
                                        i.remove();
                                        this.binaryConflicts.add(file);
                                        continue;
                                    }
                                    client.resolved(file.getAbsolutePath(), false);
                                }
                                catch (ClientException ce2) {
                                    Debug.message("Subversion client exception when resolving conflicts: " + ce2.getLocalizedMessage());
                                    Debug.message("   (on file: " + file + ")");
                                }
                            }
                        }
                        if (!this.conflicts.isEmpty() || !this.binaryConflicts.isEmpty()) {
                            this.listener.handleConflicts(this);
                        }
                        return teamworkCommandError;
                    }
                    try {
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        client.notification2(null);
                        i = addedList.iterator();
                        while (i.hasNext()) {
                            this.listener.fileAdded((File)i.next());
                        }
                        i = updatedList.iterator();
                        while (i.hasNext()) {
                            this.listener.fileUpdated((File)i.next());
                        }
                        i = removedList.iterator();
                        while (i.hasNext()) {
                            this.listener.fileRemoved((File)i.next());
                        }
                        i = removedDirs.iterator();
                        while (i.hasNext()) {
                            this.listener.dirRemoved((File)i.next());
                        }
                        if (!this.conflicts.isEmpty()) {
                            i = this.conflicts.iterator();
                            while (i.hasNext()) {
                                File file = (File)i.next();
                                try {
                                    PropertyData pdata = client.propertyGet(file.getAbsolutePath(), "svn:mime-type");
                                    if ("application/octet-stream".equals(pdata.getValue())) {
                                        i.remove();
                                        this.binaryConflicts.add(file);
                                        continue;
                                    }
                                    client.resolved(file.getAbsolutePath(), false);
                                }
                                catch (ClientException ce2) {
                                    Debug.message("Subversion client exception when resolving conflicts: " + ce2.getLocalizedMessage());
                                    Debug.message("   (on file: " + file + ")");
                                }
                            }
                        }
                        if (!this.conflicts.isEmpty() || !this.binaryConflicts.isEmpty()) {
                            this.listener.handleConflicts(this);
                        }
                        throw throwable;
                    }
                    client.notification2(null);
                    i = addedList.iterator();
                    while (i.hasNext()) {
                        this.listener.fileAdded((File)i.next());
                    }
                    i = updatedList.iterator();
                    while (i.hasNext()) {
                        this.listener.fileUpdated((File)i.next());
                    }
                    i = removedList.iterator();
                    while (i.hasNext()) {
                        this.listener.fileRemoved((File)i.next());
                    }
                    i = removedDirs.iterator();
                    while (i.hasNext()) {
                        this.listener.dirRemoved((File)i.next());
                    }
                    if (!this.conflicts.isEmpty()) {
                        i = this.conflicts.iterator();
                        while (i.hasNext()) {
                            File file = (File)i.next();
                            try {
                                PropertyData pdata = client.propertyGet(file.getAbsolutePath(), "svn:mime-type");
                                if ("application/octet-stream".equals(pdata.getValue())) {
                                    i.remove();
                                    this.binaryConflicts.add(file);
                                    continue;
                                }
                                client.resolved(file.getAbsolutePath(), false);
                            }
                            catch (ClientException ce2) {
                                Debug.message("Subversion client exception when resolving conflicts: " + ce2.getLocalizedMessage());
                                Debug.message("   (on file: " + file + ")");
                            }
                        }
                    }
                    if (!this.conflicts.isEmpty() || !this.binaryConflicts.isEmpty()) {
                        this.listener.handleConflicts(this);
                    }
                }
            }
        }
        return new TeamworkCommandAborted();
    }

    @Override
    public Set getBinaryConflicts() {
        return this.binaryConflicts;
    }

    @Override
    public List getConflicts() {
        return this.conflicts;
    }

    @Override
    public void overrideFiles(Set files) {
        SVNClientInterface client = this.getRepository().getClient();
        for (File file : this.binaryConflicts) {
            try {
                Status status = client.singleStatus(file.getAbsolutePath(), false);
                File working = new File(file.getParent(), status.getConflictWorking());
                File oldRev = new File(file.getParent(), status.getConflictOld());
                File newRev = new File(file.getParent(), status.getConflictNew());
                oldRev.delete();
                if (files.contains(file)) {
                    working.delete();
                    if (newRev.renameTo(file)) continue;
                    file.delete();
                    newRev.renameTo(file);
                    continue;
                }
                newRev.delete();
                working.delete();
            }
            catch (ClientException ce) {
                Debug.message("Subversion library exception trying to resolve binary conflict: " + ce.getLocalizedMessage());
                Debug.message("   (on file: " + file + ")");
            }
        }
    }
}

