/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.StatusHandle;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.UpdateListener;
import bluej.groupwork.svn.SvnCommitAllCommand;
import bluej.groupwork.svn.SvnCommitCommand;
import bluej.groupwork.svn.SvnRepository;
import bluej.groupwork.svn.SvnUpdateToCommand;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnStatusHandle
implements StatusHandle {
    private SvnRepository repository;
    private long version;

    public SvnStatusHandle(SvnRepository repository, long version) {
        this.repository = repository;
        this.version = version;
    }

    @Override
    public TeamworkCommand commitAll(Set<File> newFiles, Set<File> binaryNewFiles, Set<File> deletedFiles, Set<File> files, Set<TeamStatusInfo> forceFiles, String commitComment) {
        HashSet<File> forceFileSet = new HashSet<File>();
        Iterator<TeamStatusInfo> i = forceFiles.iterator();
        while (i.hasNext()) {
            forceFileSet.add(i.next().getFile());
        }
        if (this.version != -1L) {
            return new SvnCommitCommand(this.repository, newFiles, binaryNewFiles, deletedFiles, files, forceFileSet, this.version, commitComment);
        }
        return new SvnCommitAllCommand(this.repository, newFiles, binaryNewFiles, deletedFiles, files, commitComment);
    }

    @Override
    public TeamworkCommand updateTo(UpdateListener listener, Set<File> files, Set<File> forceFiles) {
        return new SvnUpdateToCommand(this.repository, listener, this.version, files, forceFiles);
    }
}

