/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnCheckoutCommand;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnCommitAllCommand;
import bluej.groupwork.svn.SvnHistoryCommand;
import bluej.groupwork.svn.SvnModulesCommand;
import bluej.groupwork.svn.SvnShareCommand;
import bluej.groupwork.svn.SvnStatusCommand;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.Set;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.Status;

public class SvnRepository
implements Repository {
    private File projectPath;
    private String reposUrl;
    private SVNClientInterface client;
    private Object clientLock = new Object();

    public SvnRepository(File projectPath, String reposUrl, SVNClientInterface client) {
        this.projectPath = projectPath;
        this.reposUrl = reposUrl;
        this.client = client;
    }

    public boolean versionsDirectories() {
        return true;
    }

    public void setPassword(TeamSettings newSettings) {
        this.client.password(newSettings.getPassword());
    }

    public TeamworkCommand checkout(File projectPath) {
        return new SvnCheckoutCommand(this, projectPath);
    }

    public TeamworkCommand commitAll(Set newFiles, Set binaryNewFiles, Set deletedFiles, Set files, String commitComment) {
        return new SvnCommitAllCommand(this, newFiles, binaryNewFiles, deletedFiles, files, commitComment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllLocallyDeletedFiles(Set files) {
        Object object = this.clientLock;
        synchronized (object) {
            try {
                Status[] status = this.client.status(this.projectPath.getAbsolutePath(), true, false, false);
                for (int i = 0; i < status.length; ++i) {
                    File file = new File(status[i].getPath());
                    if (file.exists()) continue;
                    files.add(file);
                }
            }
            catch (ClientException clientException) {
                // empty catch block
            }
        }
    }

    public TeamworkCommand getLogHistory(LogHistoryListener listener) {
        return new SvnHistoryCommand(this, listener);
    }

    public FileFilter getMetadataFilter() {
        return new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.getName().equals(".svn");
            }
        };
    }

    public TeamworkCommand getModules(List modules) {
        return new SvnModulesCommand(this, modules);
    }

    public TeamworkCommand getStatus(StatusListener listener, FileFilter filter, boolean includeRemote) {
        return new SvnStatusCommand(this, listener, filter, includeRemote);
    }

    public void prepareCreateDir(File dir) {
        try {
            Status stat = this.client.singleStatus(dir.getAbsolutePath(), false);
            if (!stat.isManaged()) {
                this.client.add(dir.getAbsolutePath(), false);
            }
        }
        catch (ClientException ce) {
            Debug.message("Exception while doing svn add on directory: " + ce.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareDeleteDir(File dir) {
        Object object = this.clientLock;
        synchronized (object) {
            try {
                this.client.remove(new String[]{dir.getAbsolutePath()}, "", true);
            }
            catch (ClientException ce) {
                Debug.message("Exception while doing svn remove on directory: " + ce.getLocalizedMessage());
            }
        }
        return false;
    }

    public TeamworkCommand shareProject() {
        return new SvnShareCommand(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeamworkCommandResult execCommand(SvnCommand command) {
        Object object = this.clientLock;
        synchronized (object) {
            return command.doCommand(this.client);
        }
    }

    public String getReposUrl() {
        return this.reposUrl;
    }

    public File getProjectPath() {
        return this.projectPath;
    }

    public SVNClientInterface getClient() {
        return this.client;
    }
}

