/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.HistoryInfo;
import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnRepository;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClientInterface;

public class SvnHistoryCommand
extends SvnCommand {
    private LogHistoryListener listener;

    public SvnHistoryCommand(SvnRepository repository, LogHistoryListener listener) {
        super(repository);
        this.listener = listener;
    }

    protected TeamworkCommandResult doCommand() {
        SVNClientInterface client = this.getClient();
        File projectPath = this.getRepository().getProjectPath();
        try {
            LogMessage[] messages = client.logMessages(projectPath.getAbsolutePath(), Revision.START, Revision.HEAD, false, true);
            for (int i = 0; i < messages.length; ++i) {
                String revision = "" + messages[i].getRevisionNumber();
                Date theDate = messages[i].getDate();
                String date = "";
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(theDate);
                date = date + SvnHistoryCommand.padInt(calendar.get(1), 4);
                date = date + "/" + SvnHistoryCommand.padInt(calendar.get(2), 2);
                date = date + "/" + SvnHistoryCommand.padInt(calendar.get(5), 2);
                date = date + " " + SvnHistoryCommand.padInt(calendar.get(11), 2);
                date = date + ":" + SvnHistoryCommand.padInt(calendar.get(12), 2);
                date = date + ":" + SvnHistoryCommand.padInt(calendar.get(13), 2);
                ChangePath[] paths = messages[i].getChangedPaths();
                String[] strPaths = new String[paths.length];
                for (int j = 0; j < paths.length; ++j) {
                    strPaths[j] = paths[j].getPath();
                    int index = strPaths[j].indexOf(File.separator, 1);
                    strPaths[j] = index != -1 ? strPaths[j].substring(index + 1) : strPaths[j].substring(1);
                }
                HistoryInfo info = new HistoryInfo(strPaths, revision, date, messages[i].getAuthor(), messages[i].getMessage());
                this.listener.logInfoAvailable(info);
            }
            return new TeamworkCommandResult();
        }
        catch (ClientException ce) {
            if (!this.isCancelled()) {
                return new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
            }
            return new TeamworkCommandAborted();
        }
    }

    private static String padInt(int number, int digits) {
        String result = Integer.toString(number);
        while (result.length() < digits) {
            result = "0" + result;
        }
        return result;
    }
}

