/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnCommitAllCommand;
import bluej.groupwork.svn.SvnRepository;
import bluej.utility.Debug;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClientInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnCommitCommand
extends SvnCommitAllCommand {
    private Set<File> forceFiles;
    private long revision;

    public SvnCommitCommand(SvnRepository repository, Set<File> newFiles, Set<File> binaryNewFiles, Set<File> deletedFiles, Set<File> files, Set<File> forceFiles, long revision, String commitComment) {
        super(repository, newFiles, binaryNewFiles, deletedFiles, files, commitComment);
        this.forceFiles = forceFiles;
        this.revision = revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TeamworkCommandResult doCommand() {
        TeamworkCommandResult teamworkCommandResult;
        SVNClientInterface client = this.getClient();
        HashSet<File> backupSet = new HashSet<File>();
        HashSet<File> deleteMeSet = new HashSet<File>();
        Map<File, File> bmap = null;
        for (File file : this.forceFiles) {
            if (file.exists() && !this.deletedFiles.contains(file)) {
                backupSet.add(file);
                continue;
            }
            deleteMeSet.add(file);
        }
        try {
            TeamworkCommandResult result;
            bmap = TeamUtils.backupFiles(backupSet);
            String[] paths = new String[this.forceFiles.size()];
            int j = 0;
            for (File file : this.forceFiles) {
                paths[j++] = file.getAbsolutePath();
                file.delete();
            }
            client.update(paths, Revision.getInstance((long)this.revision), true, false);
            TeamworkCommandResult teamworkCommandResult2 = result = super.doCommand();
            return teamworkCommandResult2;
        }
        catch (IOException ioe) {
            teamworkCommandResult = new TeamworkCommandError(ioe.getMessage(), "File I/O error: " + ioe.getLocalizedMessage());
            return teamworkCommandResult;
        }
        catch (ClientException ce) {
            if (!this.isCancelled()) {
                teamworkCommandResult = new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
                return teamworkCommandResult;
            }
            teamworkCommandResult = new TeamworkCommandAborted();
            return teamworkCommandResult;
        }
        finally {
            if (bmap != null) {
                try {
                    TeamUtils.restoreBackups(bmap);
                    Iterator i = deleteMeSet.iterator();
                    while (i.hasNext()) {
                        ((File)i.next()).delete();
                    }
                }
                catch (IOException ioe) {
                    Debug.message("Failed to restore file after forced commit: " + ioe.getLocalizedMessage());
                }
            }
        }
    }
}

