/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnRepository;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.Status;

public class SvnCommitAllCommand
extends SvnCommand {
    protected Set newFiles;
    protected Set binaryNewFiles;
    protected Set deletedFiles;
    protected Set files;
    protected String commitComment;

    public SvnCommitAllCommand(SvnRepository repository, Set newFiles, Set binaryNewFiles, Set deletedFiles, Set files, String commitComment) {
        super(repository);
        this.newFiles = newFiles;
        this.binaryNewFiles = binaryNewFiles;
        this.deletedFiles = deletedFiles;
        this.files = files;
        this.commitComment = commitComment;
    }

    protected TeamworkCommandResult doCommand() {
        block7: {
            SVNClientInterface client = this.getClient();
            try {
                Status status;
                for (File newFile : this.newFiles) {
                    status = client.singleStatus(newFile.getAbsolutePath(), false);
                    if (status.isManaged()) continue;
                    this.addDir(client, newFile.getParentFile(), this.files);
                    client.add(newFile.getAbsolutePath(), false);
                    if (newFile.isDirectory()) continue;
                    client.propertySet(newFile.getAbsolutePath(), "svn:eol-style", "native", false);
                }
                for (File newFile : this.binaryNewFiles) {
                    status = client.singleStatus(newFile.getAbsolutePath(), false);
                    if (status.isManaged()) continue;
                    this.addDir(client, newFile.getParentFile(), this.files);
                    client.add(newFile.getAbsolutePath(), false);
                    if (newFile.isDirectory()) continue;
                    client.propertySet(newFile.getAbsolutePath(), "svn:mime-type", "application/octet-stream", false);
                }
                for (File newFile : this.deletedFiles) {
                    client.remove(new String[]{newFile.getAbsolutePath()}, "", true);
                }
                String[] commitFiles = new String[this.files.size()];
                Iterator i = this.files.iterator();
                for (int j = 0; j < commitFiles.length; ++j) {
                    File file = (File)i.next();
                    commitFiles[j] = file.getAbsolutePath();
                }
                client.commit(commitFiles, this.commitComment, false);
                if (!this.isCancelled()) {
                    return new TeamworkCommandResult();
                }
            }
            catch (ClientException ce) {
                if (this.isCancelled()) break block7;
                return new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
            }
        }
        return new TeamworkCommandAborted();
    }

    protected boolean addDir(SVNClientInterface client, File dir, Set commitFiles) throws ClientException {
        boolean commit;
        File projectPath = this.getRepository().getProjectPath().getAbsoluteFile();
        if (dir.getAbsoluteFile().equals(projectPath)) {
            return false;
        }
        Status status = client.singleStatus(dir.getAbsolutePath(), false);
        int istatus = status.getNodeKind();
        boolean doAdd = istatus == 0 || istatus == 3;
        boolean bl = commit = istatus == 2 && status.getTextStatus() == 3;
        if (doAdd || commit) {
            File parent = dir.getParentFile();
            boolean parentAdded = this.addDir(client, parent, commitFiles);
            if (doAdd) {
                client.add(dir.getAbsolutePath(), false);
            }
            commitFiles.add(dir);
            return true;
        }
        return false;
    }
}

