/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.groupwork.UnableToParseInputException;
import bluej.groupwork.UpdateListener;
import bluej.groupwork.UpdateResults;
import bluej.groupwork.cvsnb.BasicServerResponse;
import bluej.groupwork.cvsnb.BlueJCvsClient;
import bluej.groupwork.cvsnb.CvsUpdateResult;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;

public class UpdateServerResponse
extends BasicServerResponse
implements UpdateResults {
    private final StringBuffer taggedLine = new StringBuffer();
    private List updateResults = new LinkedList();
    private List newDirectoryNames = new LinkedList();
    private UpdateListener listener;
    private Map conflictsMap;
    private BlueJCvsClient client;

    public UpdateServerResponse(UpdateListener listener, BlueJCvsClient client) {
        this.listener = listener;
        this.client = client;
    }

    public void messageSent(MessageEvent e) {
        String line;
        block9: {
            block7: {
                int n;
                int offset;
                block8: {
                    line = e.getMessage();
                    if (e.isTagged() && (line = MessageEvent.parseTaggedMessage((StringBuffer)this.taggedLine, (String)line)) == null) {
                        return;
                    }
                    if (!e.isError()) break block7;
                    offset = 27;
                    if (line.startsWith("cvs update: New directory") || line.startsWith("cvs server: New directory")) break block8;
                    offset = 29;
                    if (29 == 0 || !line.startsWith("cvs checkout: New directory")) break block9;
                }
                if ((n = line.lastIndexOf("-- ignored")) != -1) {
                    String dirName = line.substring(offset, n - 2);
                    this.newDirectoryNames.add(dirName);
                }
                break block9;
            }
            if (line.startsWith("Merging differences between ") && this.client != null) {
                this.client.nextConflictNonBinary();
            }
        }
        try {
            CvsUpdateResult updateResult = CvsUpdateResult.parse(line);
            this.updateResults.add(updateResult);
        }
        catch (UnableToParseInputException unableToParseInputException) {
            // empty catch block
        }
    }

    public void fileUpdated(FileUpdatedEvent arg0) {
        if (this.listener != null) {
            String filePath = arg0.getFilePath();
            this.listener.fileUpdated(new File(filePath));
        }
    }

    public void fileAdded(FileAddedEvent arg0) {
        if (this.listener != null) {
            String filePath = arg0.getFilePath();
            this.listener.fileAdded(new File(filePath));
        }
    }

    public void fileRemoved(FileRemovedEvent arg0) {
        if (this.listener != null) {
            String filePath = arg0.getFilePath();
            this.listener.fileRemoved(new File(filePath));
        }
    }

    private List getUpdateResultsOfType(char type) {
        LinkedList<CvsUpdateResult> results = new LinkedList<CvsUpdateResult>();
        for (CvsUpdateResult updateResult : this.updateResults) {
            if (updateResult.getStatusCode() != type) continue;
            results.add(updateResult);
        }
        return results;
    }

    public List getConflicts() {
        this.waitForExecutionToFinish();
        List curList = this.getUpdateResultsOfType('C');
        ArrayList<File> fileList = new ArrayList<File>(curList.size());
        for (CvsUpdateResult result : curList) {
            fileList.add(new File(this.client.getLocalPath(), result.getFilename()));
        }
        return fileList;
    }

    public List getUpdated() {
        this.waitForExecutionToFinish();
        return this.getUpdateResultsOfType('U');
    }

    public List getNewDirectoryNames() {
        return this.newDirectoryNames;
    }

    public void setConflictMap(Map m) {
        this.conflictsMap = m;
    }

    public Set getBinaryConflicts() {
        return this.conflictsMap.keySet();
    }

    public void overrideFiles(Set files) {
        for (File file : files) {
            File backupFile = (File)this.conflictsMap.remove(file);
            if (backupFile == null) continue;
            backupFile.delete();
        }
        for (Map.Entry entry : this.conflictsMap.entrySet()) {
            File f = (File)entry.getKey();
            File backupFile = (File)entry.getValue();
            f.delete();
            backupFile.renameTo(f);
        }
    }
}

