/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandAuthFailure;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.cvsnb.BasicServerResponse;
import bluej.groupwork.cvsnb.BlueJCvsClient;
import bluej.groupwork.cvsnb.CvsRepository;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public abstract class CvsCommand
implements TeamworkCommand {
    protected CvsRepository repository;
    private BlueJCvsClient client;
    private boolean cancelled;

    protected CvsCommand(CvsRepository repository) {
        this.repository = repository;
        this.cancelled = false;
    }

    protected synchronized BlueJCvsClient getClient() throws CommandAbortedException, AuthenticationException {
        if (this.cancelled) {
            throw new CommandAbortedException("", "");
        }
        this.client = this.repository.getClient();
        return this.client;
    }

    public synchronized void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            if (this.client != null) {
                this.client.abort();
            }
        }
    }

    public TeamworkCommandResult getResult() {
        try {
            BasicServerResponse response = this.doCommand();
            if (response.isError()) {
                return new TeamworkCommandError(response.getMessage(), null);
            }
            return new TeamworkCommandResult();
        }
        catch (CommandAbortedException cae) {
            return new TeamworkCommandAborted();
        }
        catch (CommandException ce) {
            return new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
        }
        catch (AuthenticationException ae) {
            return new TeamworkCommandAuthFailure();
        }
    }

    protected abstract BasicServerResponse doCommand() throws CommandAbortedException, CommandException, AuthenticationException;
}

