/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.TeamAction;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import java.awt.EventQueue;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ImportAction
extends TeamAction {
    public ImportAction() {
        super("team.import");
    }

    public void actionPerformed(PkgMgrFrame pmf) {
        Project project = pmf.getProject();
        if (project == null) {
            return;
        }
        this.doImport(pmf, project);
    }

    private void doImport(PkgMgrFrame pmf, final Project project) {
        final TeamSettingsController tsc = new TeamSettingsController(project.getProjectDir());
        final Repository repository = tsc.getRepository(true);
        if (repository == null) {
            return;
        }
        project.saveAllGraphLayout();
        this.setStatus(Config.getString("team.sharing"));
        this.startProgressBar();
        Thread thread = new Thread(){
            TeamworkCommandResult result = null;

            public void run() {
                TeamworkCommand command = repository.shareProject();
                this.result = command.getResult();
                if (!this.result.isError()) {
                    project.setTeamSettingsController(tsc);
                    Set files = tsc.getProjectFiles(true);
                    HashSet<File> newFiles = new HashSet<File>(files);
                    Set<File> binFiles = TeamUtils.extractBinaryFilesFromSet(newFiles);
                    command = repository.commitAll(newFiles, binFiles, Collections.EMPTY_SET, files, Config.getString("team.import.initialMessage"));
                    this.result = command.getResult();
                }
                ImportAction.this.stopProgressBar();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ImportAction.this.handleServerResponse(result);
                        if (!result.isError()) {
                            ImportAction.this.setStatus(Config.getString("team.shared"));
                        } else {
                            ImportAction.this.clearStatus();
                        }
                    }
                });
            }
        };
        thread.start();
    }
}

