/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.groupwork.TeamworkCommandResult;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TeamworkCommandError
extends TeamworkCommandResult {
    private String errMsg;
    private String localizedErrMsg;
    private static final Map<String, String> messageIdMap = new TreeMap<String, String>();

    public TeamworkCommandError(String errMsg, String localizedErrMsg) {
        this.errMsg = errMsg;
        this.localizedErrMsg = localizedErrMsg;
        Debug.message("Teamwork error message: " + errMsg);
    }

    public boolean isError() {
        return true;
    }

    public String getErrorMessage() {
        String betterMsg = this.getBetterMsg(this.errMsg);
        if (betterMsg != null) {
            return betterMsg;
        }
        if (this.localizedErrMsg != null) {
            return this.localizedErrMsg;
        }
        return this.errMsg;
    }

    private String getBetterMsg(String msg) {
        if (msg == null) {
            return null;
        }
        String betterMsg = null;
        String trimmedInput = msg.trim();
        if (trimmedInput.length() == 0) {
            betterMsg = "team-empty-message";
        } else {
            Set<Map.Entry<String, String>> entries = messageIdMap.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (!trimmedInput.startsWith(entry.getKey())) continue;
                betterMsg = entry.getValue();
                break;
            }
        }
        if (betterMsg != null) {
            betterMsg = DialogManager.getMessage(betterMsg);
        }
        return betterMsg;
    }

    static {
        messageIdMap.put("cvs server: Up-to-date check failed", "team-uptodate-failed");
        messageIdMap.put("cvs server: cannot find module", "team-cant-find-module");
        messageIdMap.put("svn: Cannot connect to", "team-cant-connect");
        messageIdMap.put("svn: No repository found in", "team-cant-find-repository");
        messageIdMap.put("svn: File not found:", "team-cant-find-path");
        messageIdMap.put("svn: URL ", "team-cant-find-path");
        messageIdMap.put("svn: Authentication required for", "team-authentication-problem");
        messageIdMap.put("svn: File already exists:", "team-project-exists");
    }
}

