/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.svn.SvnRepository;
import bluej.utility.Debug;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClientInterface;

public class SubversionProvider
implements TeamworkProvider {
    private SVNClientInterface getClient() {
        SVNClientInterface client = null;
        try {
            Class<?> clientImplClass = Class.forName("org.tmatesoft.svn.core.javahl.SVNClientImpl");
            Method newInstanceMethod = clientImplClass.getMethod("newInstance", new Class[0]);
            Object svnClient = newInstanceMethod.invoke(null, new Object[0]);
            if (svnClient instanceof SVNClientInterface) {
                client = (SVNClientInterface)svnClient;
            } else {
                Debug.message("Subversion client class does not implement SVNClientInterface");
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoSuchMethodException nsme) {
            Debug.message("No \"newInstance()\" method in SVNClientImpl class.");
            nsme.printStackTrace();
        }
        catch (LinkageError le) {
        }
        catch (InvocationTargetException ite) {
            Debug.message("Error while instantiating subversion client implementation.");
            ite.printStackTrace();
            if (ite.getCause() != null) {
                ite.getCause().printStackTrace();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return client;
    }

    public String getProviderName() {
        return "Subversion";
    }

    public TeamworkCommandResult checkConnection(TeamSettings settings) {
        SVNClientInterface client = this.getClient();
        client.username(settings.getUserName());
        client.password(settings.getPassword());
        try {
            client.info2(this.makeSvnUrl(settings), Revision.HEAD, Revision.HEAD, false);
            return new TeamworkCommandResult();
        }
        catch (ClientException ce) {
            return new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
        }
    }

    public String[] getProtocols() {
        return new String[]{"svn", "svn+ssh", "http"};
    }

    public String getProtocolKey(int protocol) {
        return this.getProtocols()[protocol];
    }

    public String getProtocolLabel(String protocolKey) {
        return protocolKey;
    }

    public Repository getRepository(File projectDir, TeamSettings settings) {
        SVNClientInterface client = this.getClient();
        client.username(settings.getUserName());
        client.password(settings.getPassword());
        return new SvnRepository(projectDir, this.makeSvnUrl(settings), client);
    }

    protected String makeSvnUrl(TeamSettings settings) {
        String protocol = settings.getProtocol();
        String userName = settings.getUserName();
        String server = settings.getServer();
        String prefix = settings.getPrefix();
        String group = settings.getGroup();
        String svnUrl = protocol + "://" + userName + "@" + server;
        if (prefix.length() != 0 && !prefix.startsWith("/")) {
            svnUrl = svnUrl + "/";
        }
        svnUrl = svnUrl + prefix;
        if (group != null && group.length() != 0) {
            if (!svnUrl.endsWith("/")) {
                svnUrl = svnUrl + "/";
            }
            svnUrl = svnUrl + group;
        } else if (svnUrl.endsWith("/")) {
            svnUrl = svnUrl.substring(0, svnUrl.length() - 1);
        }
        return svnUrl;
    }
}

