/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.cvsnb.BlueJAdminHandler;
import bluej.groupwork.cvsnb.CvsRepository;
import java.io.File;

public class CvsProvider
implements TeamworkProvider {
    static final String pserverLabel = Config.getString("team.settings.pserver");
    static final String extLabel = Config.getString("team.settings.ext");
    static final String[] protocols = new String[]{pserverLabel, extLabel};
    static final String[] protocolKeys = new String[]{"pserver", "ext"};

    public String getProviderName() {
        return "CVS";
    }

    public TeamworkCommandResult checkConnection(TeamSettings settings) {
        String cvsRoot = CvsProvider.makeCvsRoot(settings);
        return CvsRepository.validateConnection(cvsRoot);
    }

    public static String makeCvsRoot(TeamSettings settings) {
        String protocol = settings.getProtocol();
        String userName = settings.getUserName();
        String password = settings.getPassword();
        String server = settings.getServer();
        String prefix = settings.getPrefix();
        String group = settings.getGroup();
        String cvsRoot = ":" + protocol + ":" + userName + ":" + password + "@" + server + ":" + prefix;
        if (group != null && group.length() != 0) {
            if (!cvsRoot.endsWith("/")) {
                cvsRoot = cvsRoot + "/";
            }
            cvsRoot = cvsRoot + group;
        } else if (cvsRoot.endsWith("/")) {
            cvsRoot = cvsRoot.substring(0, cvsRoot.length() - 1);
        }
        return cvsRoot;
    }

    public String[] getProtocols() {
        return protocols;
    }

    public String getProtocolKey(int protocol) {
        return protocolKeys[protocol];
    }

    public String getProtocolLabel(String protocolKey) {
        int i = 0;
        while (!protocolKeys[i].equals(protocolKey)) {
            ++i;
        }
        return protocols[i];
    }

    public Repository getRepository(File projectDir, TeamSettings settings) {
        String cvsRoot = CvsProvider.makeCvsRoot(settings);
        BlueJAdminHandler adminHandler = new BlueJAdminHandler(projectDir);
        return new CvsRepository(projectDir, cvsRoot, adminHandler);
    }
}

