/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.graph.Graph;
import bluej.graph.SelectionSet;
import bluej.graph.Vertex;
import java.awt.Rectangle;
import java.util.Iterator;

public final class Marquee {
    private Graph graph;
    private int drag_start_x;
    private int drag_start_y;
    private Rectangle currentRect;
    private SelectionSet selected = null;

    public Marquee(Graph graph) {
        this.graph = graph;
    }

    public void start(int x, int y) {
        this.drag_start_x = x;
        this.drag_start_y = y;
        this.selected = new SelectionSet();
    }

    public void move(int drag_x, int drag_y) {
        int x = this.drag_start_x;
        int y = this.drag_start_y;
        int w = drag_x - this.drag_start_x;
        int h = drag_y - this.drag_start_y;
        if (w < 0) {
            x += w;
        }
        if (h < 0) {
            y += h;
        }
        w = Math.abs(w);
        h = Math.abs(h);
        this.currentRect = new Rectangle(x, y, w, h);
        this.findSelectedVertices(x, y, w, h);
    }

    private void findSelectedVertices(int x, int y, int w, int h) {
        this.selected.clear();
        Iterator it = this.graph.getVertices();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            if (!v.getRectangle().intersects(x, y, w, h)) continue;
            this.selected.add(v);
        }
    }

    public SelectionSet stop() {
        this.currentRect = null;
        SelectionSet tmp = this.selected;
        this.selected = null;
        return tmp;
    }

    public boolean isActive() {
        return this.selected != null;
    }

    public Rectangle getRectangle() {
        return this.currentRect;
    }
}

