/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.graph.Edge;
import bluej.graph.GraphElement;
import bluej.graph.GraphListener;
import bluej.graph.SelectableGraphElement;
import bluej.graph.Vertex;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Graph {
    private static final int RIGHT_PLACEMENT_MIN = 300;
    private static final int WHITESPACE_SIZE = 10;
    private List listeners = new ArrayList();

    public abstract Iterator getVertices();

    public abstract Iterator getEdges();

    public Dimension getMinimumSize() {
        int minWidth = 1;
        int minHeight = 1;
        Iterator it = this.getVertices();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            if (v.getX() + v.getWidth() > minWidth) {
                minWidth = v.getX() + v.getWidth();
            }
            if (v.getY() + v.getHeight() <= minHeight) continue;
            minHeight = v.getY() + v.getHeight();
        }
        return new Dimension(minWidth + 20, minHeight + 20);
    }

    public void findSpaceForVertex(Vertex t) {
        Area a = new Area();
        Iterator it = this.getVertices();
        while (it.hasNext()) {
            Vertex vertex = (Vertex)it.next();
            if (vertex == t) continue;
            Rectangle vr = new Rectangle(vertex.getX(), vertex.getY(), vertex.getWidth(), vertex.getHeight());
            a.add(new Area(vr));
        }
        Dimension min = this.getMinimumSize();
        if (300 > min.width) {
            min.width = 300;
        }
        Rectangle targetRect = new Rectangle(t.getWidth() + 20, t.getHeight() + 20);
        for (int y = 0; y < 2 * min.height; y += 10) {
            for (int x = 0; x < min.width - t.getWidth() - 20; x += 10) {
                targetRect.setLocation(x, y);
                if (a.intersects(targetRect)) continue;
                t.setPos(x + 10, y + 10);
                return;
            }
        }
        t.setPos(10, min.height + 10);
    }

    public SelectableGraphElement findGraphElement(int x, int y) {
        SelectableGraphElement element = this.findVertex(x, y);
        if (element == null) {
            element = this.findEdge(x, y);
        }
        return element;
    }

    private Edge findEdge(int x, int y) {
        GraphElement element = null;
        Iterator it = this.getEdges();
        while (it.hasNext()) {
            element = (GraphElement)it.next();
            if (!element.contains(x, y)) continue;
            return (Edge)element;
        }
        return null;
    }

    private Vertex findVertex(int x, int y) {
        GraphElement element = null;
        GraphElement topElement = null;
        Iterator it = this.getVertices();
        while (it.hasNext()) {
            element = (GraphElement)it.next();
            if (!element.contains(x, y)) continue;
            topElement = element;
        }
        return (Vertex)topElement;
    }

    public void addListener(GraphListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(GraphListener listener) {
        this.listeners.remove(listener);
    }

    protected void removedSelectableElement(SelectableGraphElement vertex) {
        for (GraphListener listener : this.listeners) {
            listener.selectableElementRemoved(vertex);
        }
    }

    protected void graphChanged() {
        for (GraphListener listener : this.listeners) {
            listener.graphChanged();
        }
    }
}

