/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.extmgr.ExtensionWrapper;
import bluej.extmgr.HelpDetailDialog;
import bluej.utility.EscapeDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class HelpDialog
implements ActionListener {
    private final String systemString = Config.getString("extmgr.systemExtensionShort");
    private final String projectString = Config.getString("extmgr.projectExtensionShort");
    private final ImageIcon infoIcon = Config.getImageAsIcon("image.extmgr.info");
    private JDialog mainFrame;
    private HelpDetailDialog detailDialog;
    private JButton closeButton;
    private JTable extensionsTable;
    private ExtensionsTableModel extensionsTableModel;
    private List extensionsList;

    HelpDialog(List i_extensionsList, JFrame parent) {
        this.extensionsList = i_extensionsList;
        this.extensionsTable = this.getExtensionTable();
        JScrollPane extensionsPane = new JScrollPane(this.extensionsTable);
        JPanel buttonPanel = new JPanel();
        this.closeButton = new JButton(Config.getString("close"));
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        this.mainFrame = new EscapeDialog(parent, Config.getString("extmgr.title"), true);
        JPanel rootPane = (JPanel)this.mainFrame.getContentPane();
        rootPane.setLayout(new BorderLayout());
        rootPane.setBorder(BlueJTheme.dialogBorder);
        rootPane.add((Component)extensionsPane, "Center");
        rootPane.add((Component)buttonPanel, "South");
        this.mainFrame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.extmgr.helpdialog", HelpDialog.this.mainFrame.getLocation());
            }
        });
        this.mainFrame.setLocation(Config.getLocation("bluej.extmgr.helpdialog"));
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        this.mainFrame.dispose();
    }

    private void showDetails() {
        int selectedColumn;
        if (this.detailDialog == null) {
            this.detailDialog = new HelpDetailDialog(this.mainFrame);
        }
        if ((selectedColumn = this.extensionsTable.getSelectedColumn()) != 0) {
            return;
        }
        ExtensionWrapper aWrapper = this.getWrapper(this.extensionsTable.getSelectedRow());
        if (aWrapper == null) {
            return;
        }
        this.detailDialog.updateInfo(aWrapper);
    }

    private JTable getExtensionTable() {
        this.extensionsTableModel = new ExtensionsTableModel();
        JTable aTable = new JTable(this.extensionsTableModel);
        aTable.setSelectionMode(0);
        aTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        TableColumnModel tcm = aTable.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(20);
        tcm.getColumn(2).setPreferredWidth(250);
        aTable.setRowHeight(18);
        aTable.setRowSelectionAllowed(false);
        aTable.addMouseListener(new myMouseAdapter());
        return aTable;
    }

    private ExtensionWrapper getWrapper(int index) {
        if (index > this.extensionsList.size()) {
            return null;
        }
        return (ExtensionWrapper)this.extensionsList.get(index);
    }

    class ExtensionsTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{" ", Config.getString("extmgr.statuscolumn"), Config.getString("extmgr.namecolumn"), Config.getString("extmgr.typecolumn")};

        ExtensionsTableModel() {
        }

        public int getRowCount() {
            return HelpDialog.this.extensionsList.size();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return HelpDialog.this.infoIcon;
            }
            ExtensionWrapper wrapper = HelpDialog.this.getWrapper(row);
            if (wrapper == null) {
                return "getValueAt: ERROR: no wrapper at row=" + row + " col=" + col;
            }
            if (col == 1) {
                return wrapper.getExtensionStatus();
            }
            if (col == 2) {
                return wrapper.safeGetExtensionName();
            }
            if (col == 3) {
                return wrapper.getProject() != null ? HelpDialog.this.projectString : HelpDialog.this.systemString;
            }
            return "getValueAt: ERROR at row=" + row + " col=" + col;
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return new ImageIcon().getClass();
            }
            return new String().getClass();
        }
    }

    private class myMouseAdapter
    extends MouseAdapter {
        private myMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1) {
                HelpDialog.this.showDetails();
            }
        }
    }
}

