/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.extmgr.ExtensionWrapper;
import bluej.utility.EscapeDialog;
import bluej.utility.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class HelpDetailDialog
extends EscapeDialog
implements ActionListener {
    private final String extensionsTag = Config.getString("extmgr.extensions");
    private final String detailsTag = Config.getString("extmgr.details");
    private final String systemString = Config.getString("extmgr.systemExtensionLong");
    private final String projectString = Config.getString("extmgr.projectExtensionLong");
    private final String locationTag = Config.getString("extmgr.details.location");
    private final String versionTag = Config.getString("extmgr.details.version");
    private final String urlTag = Config.getString("extmgr.details.url");
    private JLabel nameField;
    private JLabel locationField;
    private JLabel typeField;
    private JLabel urlField;
    private JTextArea descriptionField;
    private URL url;
    private JButton closeButton;

    HelpDetailDialog(Dialog owner) {
        super(owner);
        this.setTitle(this.detailsTag);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.nameField = new JLabel();
        this.typeField = new JLabel();
        this.locationField = new JLabel();
        this.urlField = new JLabel();
        this.urlField.setCursor(new Cursor(12));
        this.urlField.setForeground(Color.blue);
        this.urlField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                HelpDetailDialog.this.openURL();
            }
        });
        this.descriptionField = new JTextArea(4, 20);
        this.descriptionField.setLineWrap(true);
        this.descriptionField.setWrapStyleWord(true);
        this.descriptionField.setEnabled(false);
        this.descriptionField.setDisabledTextColor(Color.black);
        this.descriptionField.setBackground(this.urlField.getBackground());
        JScrollPane descriptionScroller = new JScrollPane(this.descriptionField);
        descriptionScroller.setBorder(null);
        descriptionScroller.setAlignmentX(0.0f);
        mainPanel.add(this.nameField);
        mainPanel.add(this.typeField);
        mainPanel.add(Box.createVerticalStrut(12));
        mainPanel.add(this.locationField);
        mainPanel.add(Box.createVerticalStrut(12));
        mainPanel.add(descriptionScroller);
        mainPanel.add(Box.createVerticalStrut(12));
        JPanel urlPanel = new JPanel();
        urlPanel.setAlignmentX(0.0f);
        urlPanel.add(new JLabel(this.urlTag));
        urlPanel.add(this.urlField);
        mainPanel.add(urlPanel);
        JPanel buttonPanel = new JPanel();
        this.closeButton = new JButton(Config.getString("close"));
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        JPanel rootPane = (JPanel)this.getContentPane();
        rootPane.setLayout(new BorderLayout());
        rootPane.setBorder(BlueJTheme.dialogBorder);
        rootPane.add((Component)mainPanel, "Center");
        rootPane.add((Component)buttonPanel, "South");
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.extmgr.helpdialog.details", HelpDetailDialog.this.getLocation());
            }
        });
        this.setLocation(Config.getLocation("bluej.extmgr.helpdialog.details"));
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == null) {
            return;
        }
        if (src == this.closeButton) {
            this.setVisible(false);
        }
    }

    void updateInfo(ExtensionWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        this.nameField.setText(wrapper.safeGetExtensionName() + " " + this.versionTag + " " + wrapper.safeGetExtensionVersion());
        this.typeField.setText(wrapper.getProject() != null ? this.projectString : this.systemString);
        this.locationField.setText(this.locationTag + " " + wrapper.getExtensionFileName() + " (" + wrapper.getExtensionStatus() + ')');
        this.url = wrapper.safeGetURL();
        if (this.url == null) {
            this.urlField.setText(null);
        } else {
            this.urlField.setText(this.url.toExternalForm());
        }
        this.descriptionField.setText(wrapper.safeGetExtensionDescription());
        this.descriptionField.setCaretPosition(0);
        this.validate();
        this.pack();
        this.setVisible(true);
    }

    private void openURL() {
        if (this.url == null) {
            return;
        }
        Utility.openWebBrowser(this.url.toExternalForm());
    }
}

