/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.debugmgr.ExecutionEvent;
import bluej.extensions.event.ExtensionEvent;
import bluej.extensions.event.InvocationEvent;
import bluej.extensions.event.PackageEvent;
import bluej.extmgr.ExtensionPrefManager;
import bluej.extmgr.ExtensionWrapper;
import bluej.extmgr.HelpDialog;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

public class ExtensionsManager
implements BlueJEventListener {
    private static ExtensionsManager instance;
    private List extensions = new ArrayList();
    private ExtensionPrefManager prefManager = null;

    public static synchronized ExtensionsManager getInstance() {
        if (instance == null) {
            instance = new ExtensionsManager();
            instance.loadExtensions();
        }
        return instance;
    }

    private ExtensionsManager() {
        BlueJEvent.addListener(this);
    }

    private void loadExtensions() {
        File systemDir = new File(Config.getBlueJLibDir(), "extensions");
        String dirPath = Config.getPropString("bluej.extensions.systempath", null);
        if (dirPath != null) {
            systemDir = new File(dirPath);
        }
        this.loadDirectoryExtensions(systemDir, null);
        this.loadDirectoryExtensions(Config.getUserConfigFile("extensions"), null);
    }

    public synchronized void unloadExtensions() {
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionWrapper aWrapper = (ExtensionWrapper)iter.next();
            aWrapper.terminate();
            iter.remove();
        }
    }

    private synchronized void loadDirectoryExtensions(File directory, Project project) {
        if (directory == null) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (int index = 0; index < files.length; ++index) {
            ExtensionWrapper aWrapper;
            File thisFile = files[index];
            if (thisFile.isDirectory() || !thisFile.getName().endsWith(".jar") || !(aWrapper = new ExtensionWrapper(this, this.getPrefManager(), thisFile)).isJarValid() || this.isWrapperAlreadyLoaded(aWrapper)) continue;
            this.extensions.add(aWrapper);
            aWrapper.newExtension(project);
            if (aWrapper.isValid()) continue;
            this.extensions.remove(aWrapper);
        }
    }

    private boolean isWrapperAlreadyLoaded(ExtensionWrapper thisWrapper) {
        if (thisWrapper == null) {
            return false;
        }
        if (!thisWrapper.isJarValid()) {
            return false;
        }
        String thisClassName = thisWrapper.getExtensionClassName();
        String thisJarName = thisWrapper.getExtensionFileName();
        for (ExtensionWrapper aWrapper : this.extensions) {
            String aClassName = aWrapper.getExtensionClassName();
            if (aClassName == null || !thisClassName.equals(aClassName)) continue;
            Debug.message("Extension is already loaded: " + thisClassName + " jarName=" + thisJarName);
            return true;
        }
        return false;
    }

    public ExtensionPrefManager getPrefManager() {
        if (this.prefManager == null) {
            this.prefManager = new ExtensionPrefManager(this.extensions);
        }
        return this.prefManager;
    }

    public void showHelp(JFrame parentFrame) {
        new HelpDialog(Collections.unmodifiableList(this.extensions), parentFrame);
    }

    public void projectOpening(Project project) {
        File exts = new File(project.getProjectDir(), "extensions");
        this.loadDirectoryExtensions(exts, project);
    }

    public void packageOpened(Package pkg) {
        this.delegateEvent((ExtensionEvent)new PackageEvent(1, pkg));
    }

    public synchronized void packageClosing(Package pkg) {
        this.delegateEvent((ExtensionEvent)new PackageEvent(2, pkg));
        boolean invalidateExtension = false;
        Project thisProject = pkg.getProject();
        if (thisProject == null) {
            return;
        }
        PkgMgrFrame[] frameArray = PkgMgrFrame.getAllProjectFrames(thisProject);
        if (frameArray == null) {
            invalidateExtension = true;
        } else {
            boolean bl = invalidateExtension = frameArray.length <= 1;
        }
        if (!invalidateExtension) {
            return;
        }
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            ExtensionWrapper aWrapper = (ExtensionWrapper)iter.next();
            if (thisProject != aWrapper.getProject()) continue;
            aWrapper.terminate();
            iter.remove();
        }
    }

    private boolean skipThisMenu(Project onThisProject, Project extensionProject) {
        if (onThisProject == null && extensionProject == null) {
            return false;
        }
        if (onThisProject == null && extensionProject != null) {
            return true;
        }
        if (onThisProject != null && extensionProject == null) {
            return false;
        }
        return onThisProject != extensionProject;
    }

    LinkedList getMenuItems(Object attachedObject, Project onThisProject) {
        LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
        for (ExtensionWrapper aWrapper : this.extensions) {
            JMenuItem anItem;
            if (!aWrapper.isValid() || this.skipThisMenu(onThisProject, aWrapper.getProject()) || (anItem = aWrapper.safeGetMenuItem(attachedObject)) == null) continue;
            anItem.putClientProperty("bluej.extmgr.ExtensionWrapper", aWrapper);
            menuItems.add(anItem);
        }
        return menuItems;
    }

    public void delegateEvent(ExtensionEvent event) {
        for (ExtensionWrapper wrapper : this.extensions) {
            wrapper.safeEventOccurred(event);
        }
    }

    public void blueJEvent(int eventId, Object arg) {
        if (eventId == 5) {
            ExecutionEvent exevent = (ExecutionEvent)arg;
            this.delegateEvent((ExtensionEvent)new InvocationEvent(exevent));
            return;
        }
    }
}

