/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.texteval;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.IndexHistory;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.ValueCollection;
import bluej.debugmgr.texteval.DragAndDropHelper;
import bluej.debugmgr.texteval.TextEvalCaret;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.MoeSyntaxEditorKit;
import bluej.parser.TextParser;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class TextEvalPane
extends JEditorPane
implements ValueCollection,
ResultWatcher,
MouseMotionListener {
    private static final Cursor defaultCursor = new Cursor(0);
    private static final Cursor objectCursor = new Cursor(12);
    private static final Cursor textCursor = new Cursor(2);
    private static final String nullLabel = Config.getString("debugger.null");
    private static final String uninitializedWarning = Config.getString("pkgmgr.codepad.uninitialized");
    private PkgMgrFrame frame;
    private MoeSyntaxDocument doc;
    private String currentCommand = "";
    private IndexHistory history;
    private Invoker invoker = null;
    private TextParser textParser = null;
    private boolean firstTry;
    private boolean wrappedResult;
    private boolean mouseInTag = false;
    private boolean mouseOverObject = false;
    private boolean busy = false;
    private Action softReturnAction;
    private List localVars = new ArrayList();
    private List newlyDeclareds;
    private List autoInitializedVars;

    public TextEvalPane(PkgMgrFrame frame) {
        this.frame = frame;
        this.setEditorKit((EditorKit)new MoeSyntaxEditorKit(true));
        this.doc = (MoeSyntaxDocument)this.getDocument();
        this.doc.setTokenMarker((TokenMarker)new JavaTokenMarker());
        this.defineKeymap();
        this.clear();
        this.history = new IndexHistory(20);
        this.addMouseMotionListener(this);
        this.setCaret(new TextEvalCaret());
        this.setAutoscrolls(false);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width += 22;
        return d;
    }

    public void scrollRectToVisible(Rectangle rect) {
        super.scrollRectToVisible(new Rectangle(rect.x - 18, rect.y, rect.width + 14 + 4, rect.height));
    }

    public void clear() {
        this.setText(" ");
        this.caretToEnd();
    }

    public void clearVars() {
        this.localVars.clear();
        if (this.textParser != null) {
            this.textParser.newClassLoader(this.frame.getProject().getClassLoader());
        }
    }

    public void paste() {
        this.ensureLegalCaretPosition();
        super.paste();
    }

    public void replaceSelection(String content) {
        this.ensureLegalCaretPosition();
        String[] lines = content.split("\n");
        super.replaceSelection(lines[0]);
        for (int i = 1; i < lines.length; ++i) {
            this.softReturnAction.actionPerformed(null);
            super.replaceSelection(lines[i]);
        }
    }

    public Iterator getValueIterator() {
        return this.localVars.iterator();
    }

    public NamedValue getNamedValue(String name) {
        NamedValue nv = this.getLocalVar(name);
        if (nv != null) {
            return nv;
        }
        return this.frame.getObjectBench().getNamedValue(name);
    }

    private NamedValue getLocalVar(String name) {
        for (NamedValue nv : this.localVars) {
            if (!nv.getName().equals(name)) continue;
            return nv;
        }
        return null;
    }

    public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
        boolean giveUninitializedWarning;
        this.currentCommand = "";
        this.frame.getObjectBench().addInteraction(ir);
        if (this.newlyDeclareds != null) {
            for (CodepadVar cpv : this.newlyDeclareds) {
                cpv.setInitialized();
            }
            this.newlyDeclareds = null;
        }
        this.append(" ");
        boolean bl = giveUninitializedWarning = this.autoInitializedVars != null && this.autoInitializedVars.size() != 0;
        if (giveUninitializedWarning && Utility.firstTimeThisRun("TextEvalPane.uninitializedWarning")) {
            String warning = uninitializedWarning;
            int findex = 0;
            while (findex < warning.length()) {
                int nindex = warning.indexOf(10, findex);
                if (nindex == -1) {
                    nindex = warning.length();
                }
                String warnLine = warning.substring(findex, nindex);
                this.append(warnLine);
                this.markAs("error", Boolean.TRUE);
                findex = nindex + 1;
            }
            this.autoInitializedVars.clear();
        }
        if (result != null) {
            String resultString = result.getFieldValueString(0);
            if (resultString.equals(nullLabel)) {
                this.output(resultString);
            } else {
                boolean isObject = result.instanceFieldIsObject(0);
                if (isObject) {
                    String resultType = result.getFieldObject(0).getStrippedGenClassName();
                    this.objectOutput(resultString + "   (" + resultType + ")", new ObjectInfo(result.getFieldObject(0), ir));
                } else {
                    String resultType = JavaNames.stripPrefix(result.getFieldValueTypeString(0));
                    this.output(resultString + "   (" + resultType + ")");
                }
            }
            BlueJEvent.raiseEvent(3, resultString);
        } else {
            BlueJEvent.raiseEvent(3, null);
        }
        this.textParser.confirmCommand();
        this.setEditable(true);
        this.busy = false;
    }

    public void putError(String message) {
        if (this.firstTry) {
            if (this.wrappedResult) {
                this.wrappedResult = false;
                this.invoker = new Invoker(this.frame, this, this.currentCommand, (ResultWatcher)this);
                this.invoker.setImports(this.textParser.getImportStatements());
                this.invoker.doFreeFormInvocation("");
            } else {
                this.firstTry = false;
                this.invoker.tryAgain();
            }
        } else {
            if (this.autoInitializedVars != null) {
                this.autoInitializedVars.clear();
            }
            this.removeNewlyDeclareds();
            this.showErrorMsg(message);
        }
    }

    public void putException(String message) {
        if (this.autoInitializedVars != null) {
            this.autoInitializedVars.clear();
        }
        this.removeNewlyDeclareds();
        this.showErrorMsg(message);
    }

    public void putVMTerminated() {
        if (this.autoInitializedVars != null) {
            this.autoInitializedVars.clear();
        }
        this.removeNewlyDeclareds();
        this.append(Config.getString("pkgmgr.codepad.vmTerminated"));
        this.markAs("error", Boolean.TRUE);
        this.completeExecution();
    }

    private void removeNewlyDeclareds() {
        if (this.newlyDeclareds != null) {
            Iterator i = this.newlyDeclareds.iterator();
            while (i.hasNext()) {
                this.localVars.remove(i.next());
            }
            this.newlyDeclareds = null;
        }
    }

    private void showErrorMsg(String message) {
        this.append(" ");
        this.error(message);
        this.completeExecution();
    }

    private void completeExecution() {
        this.currentCommand = "";
        this.setEditable(true);
        this.busy = false;
    }

    public void tagAreaClick(int pos, int clickCount) {
        ObjectInfo objInfo = this.objectAtPosition(pos);
        if (objInfo != null) {
            if (clickCount == 1) {
                DragAndDropHelper dnd = DragAndDropHelper.getInstance();
                dnd.startDrag(this, this.frame, objInfo.obj, objInfo.ir);
            } else if (clickCount == 2) {
                this.inspectObject(objInfo);
            }
        }
    }

    private void inspectObject(ObjectInfo objInfo) {
        final ObjectInfo oi = objInfo;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TextEvalPane.this.frame.getProject().getInspectorInstance(oi.obj, null, TextEvalPane.this.frame.getPackage(), oi.ir, TextEvalPane.this.frame);
            }
        });
    }

    private void output(String s) {
        try {
            this.doc.insertString(this.doc.getLength(), s, null);
            this.markAs("output", Boolean.TRUE);
        }
        catch (BadLocationException exc) {
            Debug.reportError("bad location in terminal operation");
        }
    }

    private void objectOutput(String s, ObjectInfo objInfo) {
        try {
            this.doc.insertString(this.doc.getLength(), s, null);
            this.markAs("object-ref", objInfo);
        }
        catch (BadLocationException exc) {
            Debug.reportError("bad location in terminal operation");
        }
    }

    private void error(String s) {
        try {
            this.doc.insertString(this.doc.getLength(), "Error: " + s, null);
            this.markAs("error", Boolean.TRUE);
        }
        catch (BadLocationException exc) {
            Debug.reportError("bad location in terminal operation");
        }
    }

    private void append(String s) {
        try {
            this.doc.insertString(this.doc.getLength(), s, null);
            this.caretToEnd();
        }
        catch (BadLocationException exc) {
            Debug.reportError("bad location in terminal operation");
        }
    }

    private void caretToEnd() {
        this.setCaretPosition(this.doc.getLength());
    }

    private void ensureLegalCaretPosition() {
        Caret caret = this.getCaret();
        boolean dotOK = this.isLastLine(caret.getDot());
        boolean markOK = this.isLastLine(caret.getMark());
        if (dotOK && markOK) {
            return;
        }
        if (!dotOK && !markOK) {
            this.setCaretPosition(this.getDocument().getLength());
        } else {
            caret.setDot(Math.max(caret.getDot(), caret.getMark()));
            caret.moveDot(this.startOfLastLine());
        }
    }

    private boolean isLastLine(int pos) {
        return pos >= this.startOfLastLine();
    }

    private int startOfLastLine() {
        AbstractDocument doc = (AbstractDocument)this.getDocument();
        Element line = doc.getParagraphElement(doc.getLength());
        return line.getStartOffset() + 1;
    }

    private String getCurrentLine() {
        Element line = this.doc.getParagraphElement(this.doc.getLength());
        int lineStart = line.getStartOffset() + 1;
        int lineEnd = line.getEndOffset() - 1;
        try {
            return this.doc.getText(lineStart, lineEnd - lineStart);
        }
        catch (BadLocationException exc) {
            Debug.reportError("bad location in text eval operation");
            return "";
        }
    }

    private int getCurrentColumn() {
        Caret caret = this.getCaret();
        int pos = Math.min(caret.getMark(), caret.getDot());
        return this.getColumnFromPosition(pos);
    }

    private int getColumnFromPosition(int pos) {
        int lineStart = this.doc.getParagraphElement(pos).getStartOffset();
        return pos - lineStart;
    }

    private void markAs(String flag, Object value) {
        this.append("\n ");
        SimpleAttributeSet a = new SimpleAttributeSet();
        a.addAttribute(flag, value);
        this.doc.setParagraphAttributes(this.doc.getLength() - 2, (AttributeSet)a);
        this.repaint();
    }

    private void markCurrentAs(String flag, Object value) {
        SimpleAttributeSet a = new SimpleAttributeSet();
        a.addAttribute(flag, value);
        this.doc.setParagraphAttributes(this.doc.getLength(), (AttributeSet)a);
    }

    private void replaceLine(String s) {
        Element line = this.doc.getParagraphElement(this.doc.getLength());
        int lineStart = line.getStartOffset() + 1;
        int lineEnd = line.getEndOffset() - 1;
        try {
            this.doc.replace(lineStart, lineEnd - lineStart, s, null);
        }
        catch (BadLocationException exc) {
            Debug.reportError("bad location in text eval operation");
        }
    }

    private ObjectInfo objectAtPosition(int pos) {
        Element line = this.getLineAt(pos);
        return (ObjectInfo)line.getAttributes().getAttribute("object-ref");
    }

    private Element getLineAt(int pos) {
        return this.doc.getParagraphElement(pos);
    }

    private boolean pointOverObjectIcon(int x, int y) {
        int pos = this.getUI().viewToModel(this, new Point(x, y));
        ObjectInfo objInfo = this.objectAtPosition(pos);
        return objInfo != null;
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (this.mouseInTag) {
            if (x > 14) {
                this.setCursor(textCursor);
                this.mouseInTag = false;
            } else {
                this.setTagAreaCursor(x, y);
            }
        } else if (x <= 14) {
            this.setCursor(defaultCursor);
            this.mouseOverObject = false;
            this.setTagAreaCursor(x, y);
            this.mouseInTag = true;
        }
    }

    private void setTagAreaCursor(int x, int y) {
        if (this.pointOverObjectIcon(x, y) != this.mouseOverObject) {
            boolean bl = this.mouseOverObject = !this.mouseOverObject;
            if (this.mouseOverObject) {
                this.setCursor(objectCursor);
            } else {
                this.setCursor(defaultCursor);
            }
        }
    }

    private void defineKeymap() {
        Keymap newmap = JTextComponent.addKeymap("texteval", this.getKeymap());
        AbstractAction action = new InsertCharacterAction();
        newmap.setDefaultAction(action);
        action = new ExecuteCommandAction();
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), action);
        this.softReturnAction = new ContinueCommandAction();
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), this.softReturnAction);
        action = new BackSpaceAction();
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(8, 0), action);
        action = new CursorLeftAction();
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, 0), action);
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(226, 0), action);
        action = new HistoryBackAction();
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(38, 0), action);
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(224, 0), action);
        action = new HistoryForwardAction();
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(40, 0), action);
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(225, 0), action);
        action = new TransferFocusAction(true);
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), action);
        action = new TransferFocusAction(false);
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 1), action);
        action = new CursorHomeAction();
        newmap.addActionForKeyStroke(KeyStroke.getKeyStroke(36, 0), action);
        this.setKeymap(newmap);
    }

    final class CodepadVar
    implements NamedValue {
        String name;
        boolean finalVar;
        boolean initialized = false;
        JavaType type;

        public CodepadVar(String name, JavaType type, boolean finalVar) {
            this.name = name;
            this.finalVar = finalVar;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public JavaType getGenType() {
            return this.type;
        }

        public boolean isFinal() {
            return this.finalVar;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public void setInitialized() {
            this.initialized = true;
        }
    }

    final class ObjectInfo {
        DebuggerObject obj;
        InvokerRecord ir;

        public ObjectInfo(DebuggerObject obj, InvokerRecord ir) {
            this.obj = obj;
            this.ir = ir;
        }
    }

    final class TransferFocusAction
    extends AbstractAction {
        private boolean forward;

        public TransferFocusAction(boolean forward) {
            super("TransferFocus");
            this.forward = forward;
        }

        public final void actionPerformed(ActionEvent event) {
            if (this.forward) {
                TextEvalPane.this.transferFocus();
            } else {
                TextEvalPane.this.transferFocusBackward();
            }
        }
    }

    final class HistoryForwardAction
    extends AbstractAction {
        public HistoryForwardAction() {
            super("HistoryForward");
        }

        public final void actionPerformed(ActionEvent event) {
            if (TextEvalPane.this.busy) {
                return;
            }
            String line = TextEvalPane.this.history.getNext();
            if (line != null) {
                TextEvalPane.this.replaceLine(line);
            }
        }
    }

    final class HistoryBackAction
    extends AbstractAction {
        public HistoryBackAction() {
            super("HistoryBack");
        }

        public final void actionPerformed(ActionEvent event) {
            if (TextEvalPane.this.busy) {
                return;
            }
            String line = TextEvalPane.this.history.getPrevious();
            if (line != null) {
                TextEvalPane.this.replaceLine(line);
            }
        }
    }

    final class CursorHomeAction
    extends AbstractAction {
        public CursorHomeAction() {
            super("CursorHome");
        }

        public void actionPerformed(ActionEvent event) {
            if (TextEvalPane.this.busy) {
                return;
            }
            Caret caret = TextEvalPane.this.getCaret();
            int curCol = TextEvalPane.this.getColumnFromPosition(caret.getDot());
            if (curCol != 1) {
                caret.setDot(caret.getDot() - curCol + 1);
            }
        }
    }

    final class CursorLeftAction
    extends AbstractAction {
        public CursorLeftAction() {
            super("CursorLeft");
        }

        public final void actionPerformed(ActionEvent event) {
            if (TextEvalPane.this.busy) {
                return;
            }
            if (TextEvalPane.this.getCurrentColumn() > 1) {
                Caret caret = TextEvalPane.this.getCaret();
                caret.setDot(caret.getDot() - 1);
            }
        }
    }

    final class BackSpaceAction
    extends AbstractAction {
        public BackSpaceAction() {
            super("BackSpace");
        }

        public final void actionPerformed(ActionEvent event) {
            if (TextEvalPane.this.busy) {
                return;
            }
            if (TextEvalPane.this.getCurrentColumn() > 1) {
                try {
                    if (TextEvalPane.this.getSelectionEnd() == TextEvalPane.this.getSelectionStart()) {
                        TextEvalPane.this.doc.remove(TextEvalPane.this.getCaretPosition() - 1, 1);
                    } else {
                        TextEvalPane.this.replaceSelection("");
                    }
                }
                catch (BadLocationException exc) {
                    Debug.reportError("bad location in text eval operation");
                }
            }
        }
    }

    final class ContinueCommandAction
    extends AbstractAction {
        public ContinueCommandAction() {
            super("ContinueCommand");
        }

        public final void actionPerformed(ActionEvent event) {
            if (TextEvalPane.this.busy) {
                return;
            }
            String line = TextEvalPane.this.getCurrentLine();
            TextEvalPane.this.currentCommand = TextEvalPane.this.currentCommand + (line + " ");
            TextEvalPane.this.history.add(line);
            TextEvalPane.this.markAs("continue", Boolean.TRUE);
        }
    }

    final class ExecuteCommandAction
    extends AbstractAction {
        public ExecuteCommandAction() {
            super("ExecuteCommand");
        }

        public final void actionPerformed(ActionEvent event) {
            if (TextEvalPane.this.busy) {
                return;
            }
            String line = TextEvalPane.this.getCurrentLine();
            TextEvalPane.this.currentCommand = (TextEvalPane.this.currentCommand + line).trim();
            if (TextEvalPane.this.currentCommand.length() != 0) {
                String retType;
                TextEvalPane.this.history.add(line);
                TextEvalPane.this.append("\n");
                TextEvalPane.this.markCurrentAs("output", Boolean.TRUE);
                TextEvalPane.this.firstTry = true;
                TextEvalPane.this.setEditable(false);
                TextEvalPane.this.busy = true;
                if (TextEvalPane.this.textParser == null) {
                    TextEvalPane.this.textParser = new TextParser(TextEvalPane.this.frame.getProject().getClassLoader(), TextEvalPane.this.frame.getPackage().getQualifiedName(), TextEvalPane.this);
                }
                TextEvalPane.this.wrappedResult = (retType = TextEvalPane.this.textParser.parseCommand(TextEvalPane.this.currentCommand)) != null && retType.length() != 0;
                if (retType == null) {
                    TextEvalPane.this.currentCommand = TextEvalPane.this.textParser.getAmendedCommand();
                    List declaredVars = TextEvalPane.this.textParser.getDeclaredVars();
                    if (declaredVars != null) {
                        Iterator i = TextEvalPane.this.textParser.getDeclaredVars().iterator();
                        while (i.hasNext()) {
                            TextParser.DeclaredVar dv;
                            String declaredName;
                            if (TextEvalPane.this.newlyDeclareds == null) {
                                TextEvalPane.this.newlyDeclareds = new ArrayList();
                            }
                            if (TextEvalPane.this.autoInitializedVars == null) {
                                TextEvalPane.this.autoInitializedVars = new ArrayList();
                            }
                            if (TextEvalPane.this.getLocalVar(declaredName = (dv = (TextParser.DeclaredVar)i.next()).getName()) != null) {
                                String errMsg = Config.getString("pkgmgr.codepad.redefinedVar");
                                errMsg = Utility.mergeStrings(errMsg, declaredName);
                                TextEvalPane.this.showErrorMsg(errMsg);
                                TextEvalPane.this.removeNewlyDeclareds();
                                return;
                            }
                            CodepadVar cpv = new CodepadVar(dv.getName(), dv.getDeclaredVarType(), dv.checkFinal());
                            TextEvalPane.this.newlyDeclareds.add(cpv);
                            TextEvalPane.this.localVars.add(cpv);
                            if (dv.checkVarInit()) continue;
                            TextEvalPane.this.autoInitializedVars.add(dv.getName());
                        }
                    }
                }
                TextEvalPane.this.invoker = new Invoker(TextEvalPane.this.frame, TextEvalPane.this, TextEvalPane.this.currentCommand, (ResultWatcher)TextEvalPane.this);
                TextEvalPane.this.invoker.setImports(TextEvalPane.this.textParser.getImportStatements());
                TextEvalPane.this.invoker.doFreeFormInvocation(retType);
            } else {
                TextEvalPane.this.markAs("output", Boolean.TRUE);
            }
        }
    }

    final class InsertCharacterAction
    extends AbstractAction {
        public InsertCharacterAction() {
            super("InsertCharacter");
        }

        public final void actionPerformed(ActionEvent event) {
            if (!TextEvalPane.this.isEditable()) {
                return;
            }
            String s = event.getActionCommand();
            if (s.charAt(0) != '\n') {
                TextEvalPane.this.replaceSelection(s);
            }
        }
    }
}

