/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.objectbench;

import bluej.Config;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ValueCollection;
import bluej.debugmgr.objectbench.ObjectBenchEvent;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.debugmgr.objectbench.ObjectBenchListener;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.testmgr.record.InvokerRecord;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectBench
extends JPanel
implements ValueCollection,
FocusListener,
KeyListener,
MouseListener,
ObjectBenchInterface {
    private static final Color BACKGROUND_COLOR = Config.getItemColour("colour.objectbench.background");
    private JScrollPane scroll;
    private ObjectBenchPanel obp;
    private List<ObjectWrapper> objects = new ArrayList<ObjectWrapper>();
    private ObjectWrapper selectedObject;
    private List<InvokerRecord> invokerRecords;

    public ObjectBench() {
        this.createComponent();
    }

    public void addObject(ObjectWrapper wrapper) {
        String newname = wrapper.getName();
        int count = 1;
        while (this.hasObject(newname)) {
            newname = wrapper.getName() + "_" + ++count;
        }
        wrapper.setName(newname);
        this.obp.add(wrapper);
        this.objects.add(wrapper);
        this.obp.revalidate();
        this.obp.repaint();
    }

    public List<ObjectWrapper> getObjects() {
        return Collections.unmodifiableList(this.objects);
    }

    @Override
    public Iterator<ObjectWrapper> getValueIterator() {
        return this.getObjects().iterator();
    }

    public ObjectWrapper getObject(String name) {
        for (ObjectWrapper wrapper : this.objects) {
            if (!wrapper.getName().equals(name)) continue;
            return wrapper;
        }
        return null;
    }

    @Override
    public NamedValue getNamedValue(String name) {
        return this.getObject(name);
    }

    @Override
    public boolean hasObject(String name) {
        return this.getObject(name) != null;
    }

    public int getObjectCount() {
        return this.objects.size();
    }

    public void removeAllObjects(String scopeId) {
        this.setSelectedObject(null);
        for (ObjectWrapper wrapper : this.objects) {
            wrapper.prepareRemove();
            wrapper.getPackage().getDebugger().removeObject(scopeId, wrapper.getName());
            this.obp.remove(wrapper);
        }
        this.objects.clear();
        this.resetRecordingInteractions();
        this.obp.revalidate();
        this.obp.repaint();
    }

    public void removeObject(ObjectWrapper wrapper, String scopeId) {
        if (wrapper == this.selectedObject) {
            this.setSelectedObject(null);
        }
        wrapper.prepareRemove();
        wrapper.getPackage().getDebugger().removeObject(scopeId, wrapper.getName());
        this.obp.remove(wrapper);
        this.objects.remove(wrapper);
        this.obp.revalidate();
        this.obp.repaint();
    }

    public void removeSelectedObject(String scopeId) {
        ObjectWrapper wrapper = this.getSelectedObject();
        if (wrapper != null) {
            this.removeObject(wrapper, scopeId);
        }
    }

    public void setSelectedObject(ObjectWrapper aWrapper) {
        if (this.selectedObject != null) {
            this.selectedObject.setSelected(false);
        }
        this.selectedObject = aWrapper;
        if (this.selectedObject != null) {
            this.selectedObject.setSelected(true);
            this.selectedObject.requestFocusInWindow();
        }
    }

    public ObjectWrapper getSelectedObject() {
        return this.selectedObject;
    }

    @Override
    public void addObjectBenchListener(ObjectBenchListener l) {
        this.listenerList.add(ObjectBenchListener.class, l);
    }

    @Override
    public void removeObjectBenchListener(ObjectBenchListener l) {
        this.listenerList.remove(ObjectBenchListener.class, l);
    }

    public void fireObjectEvent(ObjectWrapper wrapper) {
        this.setSelectedObject(wrapper);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ObjectBenchListener.class) continue;
            ((ObjectBenchListener)listeners[i + 1]).objectEvent(new ObjectBenchEvent(this, 1, wrapper));
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (!enable) {
            this.showFocusHiLight(false);
        }
    }

    public void showFocusHiLight(boolean hiLight) {
        if (hiLight) {
            this.scroll.setBorder(Config.focusBorder);
        } else {
            this.scroll.setBorder(Config.normalBorder);
        }
        this.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.showFocusHiLight(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.showFocusHiLight(false);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int selectedObjectIndex = this.selectedObject == null ? -1 : this.objects.indexOf(this.selectedObject);
        int key = e.getKeyCode();
        switch (key) {
            case 37: {
                selectedObjectIndex = selectedObjectIndex > 0 ? --selectedObjectIndex : 0;
                this.setSelectedObjectByIndex(selectedObjectIndex);
                break;
            }
            case 39: {
                if (selectedObjectIndex >= this.objects.size() - 1) break;
                this.setSelectedObjectByIndex(selectedObjectIndex + 1);
                break;
            }
            case 38: {
                if ((selectedObjectIndex -= this.obp.getNumberOfColumns()) < 0) break;
                this.setSelectedObjectByIndex(selectedObjectIndex);
                break;
            }
            case 40: {
                if ((selectedObjectIndex += this.obp.getNumberOfColumns()) >= this.objects.size()) break;
                this.setSelectedObjectByIndex(selectedObjectIndex);
                break;
            }
            case 10: {
                this.showPopupMenu();
                break;
            }
            case 32: {
                this.showPopupMenu();
                break;
            }
            case 27: {
                this.setSelectedObject(null);
                this.repaint();
            }
        }
    }

    private void setSelectedObjectByIndex(int i) {
        this.setSelectedObject(this.objects.get(i));
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setSelectedObject(null);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void showPopupMenu() {
        if (this.selectedObject != null) {
            this.selectedObject.showMenu();
        }
    }

    public void resetRecordingInteractions() {
        this.invokerRecords = new LinkedList<InvokerRecord>();
    }

    public void addInteraction(InvokerRecord ir) {
        if (this.invokerRecords == null) {
            this.resetRecordingInteractions();
        }
        this.invokerRecords.add(ir);
    }

    public String getFixtureDeclaration() {
        StringBuffer sb = new StringBuffer();
        for (InvokerRecord ir : this.invokerRecords) {
            if (ir.toFixtureDeclaration() == null) continue;
            sb.append(ir.toFixtureDeclaration());
        }
        return sb.toString();
    }

    public String getFixtureSetup() {
        StringBuffer sb = new StringBuffer();
        for (InvokerRecord ir : this.invokerRecords) {
            if (ir.toFixtureSetup() == null) continue;
            sb.append(ir.toFixtureSetup());
        }
        return sb.toString();
    }

    public String getTestMethod() {
        StringBuffer sb = new StringBuffer();
        for (InvokerRecord ir : this.invokerRecords) {
            sb.append(ir.toTestMethodInit());
            String testMethod = ir.toTestMethod();
            if (testMethod == null) continue;
            sb.append(testMethod);
        }
        return sb.toString();
    }

    private void createComponent() {
        this.setLayout(new BorderLayout());
        this.obp = new ObjectBenchPanel();
        this.obp.setBackground(BACKGROUND_COLOR);
        this.scroll = new JScrollPane(this.obp);
        this.scroll.setBorder(Config.normalBorder);
        Dimension sz = this.obp.getMinimumSize();
        Insets in = this.scroll.getInsets();
        sz.setSize(sz.getWidth() + (double)in.left + (double)in.right, sz.getHeight() + (double)in.top + (double)in.bottom);
        this.scroll.setMinimumSize(sz);
        this.scroll.setPreferredSize(sz);
        this.scroll.getVerticalScrollBar().setUnitIncrement(20);
        this.add((Component)this.scroll, "Center");
        this.resetRecordingInteractions();
        this.setFocusable(true);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.obp.addMouseListener(this);
    }

    private final class ObjectBenchPanel
    extends JPanel {
        public ObjectBenchPanel() {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setMinimumSize(new Dimension(95, 66));
        }

        public Component add(Component comp) {
            super.add(comp);
            return comp;
        }

        public Dimension getPreferredSize() {
            int rows = this.getNumberOfRows();
            return new Dimension(95, 66 * rows);
        }

        public int getNumberOfRows() {
            int objects = this.getComponentCount();
            if (objects == 0) {
                return 1;
            }
            int objectsPerRow = this.getWidth() / 95;
            return (objects + objectsPerRow - 1) / objectsPerRow;
        }

        public int getNumberOfColumns() {
            return this.getWidth() / 95;
        }
    }
}

