/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.inspector.AssertPanel;
import bluej.debugmgr.inspector.FieldList;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.GetInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.ObjectInspectInvokerRecord;
import bluej.utility.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class Inspector
extends JFrame
implements ListSelectionListener {
    protected static final String showClassLabel = Config.getString("debugger.inspector.showClass");
    protected static final String inspectLabel = Config.getString("debugger.inspector.inspect");
    protected static final String getLabel = Config.getString("debugger.inspector.get");
    protected static final String close = Config.getString("close");
    private static final Color valueFieldColor = Config.getItemColour("colour.inspector.value.bg");
    protected FieldList fieldList = null;
    protected JButton inspectButton;
    protected JButton getButton;
    protected AssertPanel assertPanel;
    protected DebuggerObject selectedField;
    protected String selectedFieldName;
    protected String selectedFieldType;
    protected InvokerRecord selectedInvokerRecord;
    protected Package pkg;
    protected InspectorManager inspectorManager;
    protected InvokerRecord ir;
    private static final int MIN_LIST_WIDTH = 150;
    private static final int MAX_LIST_WIDTH = 300;

    protected Inspector(InspectorManager inspectorManager, Package pkg, InvokerRecord ir) {
        this.setContentPane(new JPanel());
        if (inspectorManager == null) {
            throw new NullPointerException("An inspector must have an InspectorManager.");
        }
        this.setIconImage(BlueJTheme.getIconImage());
        if (pkg == null && ir != null) {
            ir = null;
        }
        this.inspectorManager = inspectorManager;
        this.pkg = pkg;
        this.ir = ir;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent E) {
                Inspector.this.doClose(true);
            }
        });
        this.initFieldList();
    }

    private void initFieldList() {
        this.fieldList = new FieldList(300, valueFieldColor);
        this.fieldList.setBackground(this.getBackground());
        this.fieldList.setOpaque(true);
        this.fieldList.setSelectionBackground(Config.getSelectionColour());
        this.fieldList.getSelectionModel().addListSelectionListener(this);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Inspector.this.doInspect();
                }
            }
        };
        this.fieldList.addMouseListener(mouseListener);
        this.fieldList.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                    Inspector.this.doClose(true);
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
    }

    protected boolean isGetEnabled() {
        return this.ir != null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fieldList.requestFocus();
        }
    }

    public void bringToFront() {
        this.setState(0);
        this.toFront();
    }

    protected abstract Object[] getListData();

    protected abstract void listElementSelected(int var1);

    protected abstract void showClass();

    protected abstract void prepareInspection();

    protected abstract void remove();

    protected abstract int getPreferredRows();

    public void update() {
        int slot;
        Object[] listData = this.getListData();
        this.fieldList.setData(listData);
        this.fieldList.setTableHeader(null);
        if (this.fieldList.getSelectedRow() == -1 && listData.length > 0) {
            this.fieldList.setRowSelectionInterval(0, 0);
        }
        if ((slot = this.fieldList.getSelectedRow()) != -1) {
            this.listElementSelected(slot);
        }
        this.repaint();
    }

    public void updateLayout() {
        int width;
        Object[] listData = this.getListData();
        double height = this.fieldList.getPreferredSize().getHeight();
        int rows = listData.length;
        if (rows > this.getPreferredRows()) {
            height = this.fieldList.getRowHeight() * this.getPreferredRows();
        }
        if ((width = (int)this.fieldList.getPreferredSize().getWidth()) < 150) {
            width = 150;
        }
        if (width > 300) {
            width = 300;
        }
        this.fieldList.setPreferredScrollableViewportSize(new Dimension(width, (int)height));
        this.pack();
        this.repaint();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int slot = this.fieldList.getSelectedRow();
        if (slot == -1) {
            return;
        }
        this.listElementSelected(slot);
    }

    protected void setCurrentObj(DebuggerObject object, String name, String type) {
        this.selectedField = object;
        this.selectedFieldName = name;
        this.selectedFieldType = type;
    }

    protected void setButtonsEnabled(boolean inspect, boolean get) {
        this.inspectButton.setEnabled(inspect);
        this.getButton.setEnabled(get && this.isGetEnabled());
    }

    protected void doInspect() {
        this.prepareInspection();
        if (this.selectedField != null) {
            boolean isPublic = this.getButton.isEnabled();
            ObjectInspectInvokerRecord newIr = new ObjectInspectInvokerRecord(this.selectedFieldName, this.selectedField.isArray(), this.ir);
            this.inspectorManager.getInspectorInstance(this.selectedField, this.selectedFieldName, this.pkg, isPublic ? newIr : null, this);
        }
    }

    protected void doGet() {
        if (this.selectedField != null) {
            GetInvokerRecord getIr = new GetInvokerRecord(this.selectedFieldType, this.selectedFieldName, this.ir);
            this.pkg.getEditor().raisePutOnBenchEvent(this, this.selectedField, this.selectedField.getGenType(), getIr);
        }
    }

    public void doClose(boolean handleAssertions) {
        boolean closeOk = true;
        if (handleAssertions) {
            closeOk = this.handleAssertions();
        }
        if (closeOk) {
            this.setVisible(false);
            this.remove();
            this.dispose();
        }
    }

    protected boolean handleAssertions() {
        if (this.assertPanel != null && this.assertPanel.isAssertEnabled()) {
            int choice;
            if (!this.assertPanel.isAssertComplete() && (choice = DialogManager.askQuestion(this, "empty-assertion-text")) == 0) {
                return false;
            }
            this.ir.addAssertion(this.assertPanel.getAssertStatement());
        }
        return true;
    }

    public void setBorder(Border border) {
        ((JPanel)this.getContentPane()).setBorder(border);
    }

    protected JButton createCloseButton() {
        JButton button = new JButton(close);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Inspector.this.doClose(true);
            }
        });
        return button;
    }

    protected JPanel createInspectAndGetButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.setLayout(new GridLayout(0, 1));
        buttonPanel.setOpaque(false);
        this.inspectButton = new JButton(inspectLabel);
        this.inspectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Inspector.this.doInspect();
            }
        });
        this.inspectButton.setEnabled(false);
        buttonPanel.add(this.inspectButton);
        this.getButton = new JButton(getLabel);
        this.getButton.setEnabled(false);
        this.getButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Inspector.this.doGet();
            }
        });
        buttonPanel.add(this.getButton);
        JPanel buttonFramePanel = new JPanel();
        buttonFramePanel.setOpaque(false);
        buttonFramePanel.setLayout(new BorderLayout(0, 0));
        buttonFramePanel.add((Component)buttonPanel, "North");
        return buttonFramePanel;
    }

    protected JScrollPane createFieldListScrollPane() {
        JScrollPane scrollPane = new JScrollPane(this.fieldList);
        scrollPane.setBorder(BlueJTheme.generalBorder);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        return scrollPane;
    }
}

