/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.Config;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FieldList
extends JTable {
    private int preferredWidth;

    public FieldList(int preferredWidth, Color valueFieldColor) {
        super(new ListTableModel());
        this.preferredWidth = preferredWidth;
        this.setShowGrid(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setIntercellSpacing(new Dimension());
        this.setDefaultRenderer(Object.class, new ListTableCellRenderer(valueFieldColor));
        this.setRowHeight(25);
        this.setAutoResizeMode(4);
        this.getTableHeader().setVisible(false);
    }

    public void addNotify() {
        super.addNotify();
        this.removeHeader();
    }

    public void setData(Object[] listData) {
        ((ListTableModel)this.getModel()).setDataVector(listData);
        this.setColumnWidths(listData);
        this.revalidate();
    }

    private void setColumnWidths(Object[] listData) {
        int colPrefWidth = this.preferredWidth / 2;
        for (int column = 0; column < 2; ++column) {
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            int contentsMaxWidth = this.getMaxWidth(listData, column);
            if (contentsMaxWidth < colPrefWidth) {
                tableColumn.setMinWidth(contentsMaxWidth);
            } else {
                tableColumn.setMinWidth(colPrefWidth);
            }
            tableColumn.setPreferredWidth(contentsMaxWidth);
        }
    }

    private int getMaxWidth(Object[] listData, int column) {
        TableCellRenderer ltcr = this.getDefaultRenderer(Object.class);
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        int contentsMaxWidth = tableColumn.getPreferredWidth();
        for (int row = 0; row < listData.length; ++row) {
            Component n = ltcr.getTableCellRendererComponent(this, this.dataModel.getValueAt(row, column), false, false, row, column);
            int labelWidth = n.getPreferredSize().width;
            if (labelWidth <= contentsMaxWidth) continue;
            contentsMaxWidth = labelWidth;
        }
        return contentsMaxWidth;
    }

    private void removeHeader() {
        this.unconfigureEnclosingScrollPane();
    }

    public static class ListTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final ImageIcon objectrefIcon = Config.getImageAsIcon("image.inspector.objectref");
        private static final Border valueBorder = BorderFactory.createLineBorder(Color.gray);
        private Color valueColor;

        public ListTableCellRenderer(Color valueColor) {
            this.valueColor = valueColor;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String valueString = (String)value;
            if (valueString.equals(" <object reference>")) {
                this.setIcon(objectrefIcon);
                this.setText("");
            } else {
                StringBuffer displayString = new StringBuffer(valueString);
                this.replaceAll(displayString, "\n", "\\n");
                this.replaceAll(displayString, "\t", "\\t");
                this.replaceAll(displayString, "\r", "\\r");
                this.setIcon(null);
                this.setText(displayString.toString());
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            Border b = BorderFactory.createLineBorder(this.getBackground(), 3);
            super.setBorder(b);
            TableColumn tableColumn = table.getColumnModel().getColumn(column);
            if (column == 1) {
                this.setBackground(this.valueColor);
                this.setHorizontalAlignment(0);
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.getBorder(), valueBorder);
                super.setBorder(compoundBorder);
            } else {
                this.setHorizontalAlignment(10);
            }
            return this;
        }

        private void replaceAll(StringBuffer sb, String orig, String replacement) {
            int location = sb.toString().indexOf(orig);
            while (location != -1) {
                sb.replace(location, location + orig.length(), replacement);
                location = sb.toString().indexOf(orig);
            }
        }
    }

    static class ListTableModel
    extends AbstractTableModel {
        private Object[][] cells;

        public Object getValueAt(int row, int col) {
            return this.cells[row][col];
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (this.cells != null) {
                return this.cells.length;
            }
            return 0;
        }

        public ListTableModel() {
        }

        public ListTableModel(Object[] rows) {
            this.setDataVector(rows);
        }

        public void setDataVector(Object[] rows) {
            this.cells = new Object[rows.length][2];
            for (int i = 0; i < rows.length; ++i) {
                String valueString;
                String descriptionString;
                String s = (String)rows[i];
                int delimiterIndex = s.indexOf(61);
                if (delimiterIndex >= 0) {
                    descriptionString = s.substring(0, delimiterIndex);
                    valueString = s.substring(delimiterIndex + 1);
                } else {
                    descriptionString = s;
                    valueString = "";
                }
                this.cells[i][0] = descriptionString;
                this.cells[i][1] = valueString;
            }
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

