/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.Config;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.SourceLocation;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.jdi.JdiClass;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiThreadNode;
import bluej.debugger.jdi.JdiThreadTreeModel;
import bluej.debugger.jdi.JdiUtils;
import bluej.debugger.jdi.VMReference;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

class JdiThread
extends DebuggerThread {
    static final String statusFinished = Config.getString("debugger.threadstatus.finished");
    static final String statusBreakpoint = Config.getString("debugger.threadstatus.breakpoint");
    static final String statusStopped = Config.getString("debugger.threadstatus.stopped");
    static final String statusMonitor = Config.getString("debugger.threadstatus.monitor");
    static final String statusNotStarted = Config.getString("debugger.threadstatus.notstarted");
    static final String statusRunning = Config.getString("debugger.threadstatus.running");
    static final String statusSleeping = Config.getString("debugger.threadstatus.sleeping");
    static final String statusUnknown = Config.getString("debugger.threadstatus.unknown");
    static final String statusWaiting = Config.getString("debugger.threadstatus.waiting");
    static final String statusZombie = Config.getString("debugger.threadstatus.zombie");
    private static List excludes;
    private ThreadReference rt;
    int selectedFrame;
    JdiThreadTreeModel jttm;
    EventRequestManager eventReqMgr;
    static final String MAIN_THREADGROUP = "main";

    private static List getExcludes() {
        if (excludes == null) {
            JdiThread.setExcludes("java.*, javax.*, sun.*, com.sun.*");
        }
        return excludes;
    }

    static void setExcludes(String excludeString) {
        StringTokenizer t = new StringTokenizer(excludeString, " ,;");
        ArrayList<String> list = new ArrayList<String>();
        while (t.hasMoreTokens()) {
            list.add(t.nextToken());
        }
        excludes = list;
    }

    static void addExcludesToRequest(StepRequest request) {
        for (String pattern : JdiThread.getExcludes()) {
            request.addClassExclusionFilter(pattern);
        }
    }

    public JdiThread(JdiThreadTreeModel jttm, ThreadReference rt) {
        this.jttm = jttm;
        this.rt = rt;
        this.selectedFrame = 0;
    }

    public String getName() {
        String name = null;
        try {
            name = this.rt.name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    ThreadReference getRemoteThread() {
        return this.rt;
    }

    public String getStatus() {
        try {
            if (this.rt.isAtBreakpoint()) {
                if (VMReference.isAtMainBreakpoint(this.rt)) {
                    return statusFinished;
                }
                return statusBreakpoint;
            }
            if (this.rt.isSuspended()) {
                return statusStopped;
            }
            int status = this.rt.status();
            switch (status) {
                case 3: {
                    return statusMonitor;
                }
                case 5: {
                    return statusNotStarted;
                }
                case 1: {
                    return statusRunning;
                }
                case 2: {
                    return statusSleeping;
                }
                case -1: {
                    return statusUnknown;
                }
                case 4: {
                    return statusWaiting;
                }
                case 0: {
                    return statusZombie;
                }
            }
        }
        catch (Exception e) {
            return "???";
        }
        return null;
    }

    public boolean isFinished() {
        return this.rt.isAtBreakpoint() && VMReference.isAtMainBreakpoint(this.rt);
    }

    public boolean isSuspended() {
        return this.rt.isSuspended();
    }

    public boolean isAtBreakpoint() {
        return this.rt.isAtBreakpoint();
    }

    public String getClass(int frameNo) {
        try {
            return this.rt.frame(frameNo).location().declaringType().name();
        }
        catch (Exception e) {
            return "<error finding type at frame " + frameNo + ">";
        }
    }

    public String getClassSourceName(int frameNo) {
        try {
            return this.rt.frame(frameNo).location().sourceName();
        }
        catch (Exception e) {
            return "<no source at frame no " + frameNo + ">";
        }
    }

    public int getLineNumber(int frameNo) {
        try {
            return this.rt.frame(frameNo).location().lineNumber();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public boolean isKnownSystemThread() {
        ThreadGroupReference tgr = this.rt.threadGroup();
        if (tgr == null || !tgr.name().equals(MAIN_THREADGROUP)) {
            return true;
        }
        String name = this.rt.name();
        return name.startsWith("AWT-") || name.equals("DestroyJavaVM") || name.equals("BlueJ worker thread") || name.equals("Timer Queue") || name.equals("Screen Updater") || name.startsWith("SunToolkit.") || name.startsWith("Native Carbon") || name.equals("Java2D Disposer");
    }

    public List getStack() {
        return JdiThread.getStack(this.rt);
    }

    public static List getStack(ThreadReference thr) {
        block6: {
            try {
                StackFrame f;
                Location loc;
                String className;
                if (!thr.isSuspended()) break block6;
                ArrayList<SourceLocation> stack = new ArrayList<SourceLocation>();
                List<StackFrame> frames = thr.frames();
                for (int i = 0; i < frames.size() && !(className = (loc = (f = frames.get(i)).location()).declaringType().name()).startsWith("bluej.runtime") && !JavaNames.getBase(className).startsWith("__SHELL"); ++i) {
                    String fileName = null;
                    try {
                        fileName = loc.sourceName();
                    }
                    catch (AbsentInformationException e) {
                        continue;
                    }
                    String methodName = loc.method().name();
                    int lineNumber = loc.lineNumber();
                    stack.add(new SourceLocation(className, fileName, methodName, lineNumber));
                }
                return stack;
            }
            catch (IncompatibleThreadStateException e) {
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                // empty catch block
            }
        }
        return new ArrayList();
    }

    public List getLocalVariables(int frameNo) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame frame = this.rt.frame(frameNo);
                List<LocalVariable> vars = frame.visibleVariables();
                ArrayList<String> localVars = new ArrayList<String>();
                for (int i = 0; i < vars.size(); ++i) {
                    LocalVariable var = vars.get(i);
                    JavaType vartype = JdiReflective.fromLocalVar(frame, var);
                    String val = JdiUtils.getJdiUtils().getValueString(frame.getValue(var));
                    localVars.add(vartype.toString(true) + " " + var.name() + " = " + val);
                }
                return localVars;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList();
    }

    public boolean varIsObject(int frameNo, int index) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame frame = this.rt.frame(frameNo);
                List<LocalVariable> vars = frame.visibleVariables();
                LocalVariable var = vars.get(index);
                Value val = frame.getValue(var);
                return val instanceof ObjectReference;
            }
            return false;
        }
        catch (Exception e) {
            Debug.reportError("could not get local variable info: " + e);
            return false;
        }
    }

    public DebuggerObject getStackObject(int frameNo, int index) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame frame = this.rt.frame(frameNo);
                List<LocalVariable> vars = frame.visibleVariables();
                LocalVariable var = vars.get(index);
                JavaType vartype = JdiReflective.fromLocalVar(frame, var);
                ObjectReference val = (ObjectReference)frame.getValue(var);
                return JdiObject.getDebuggerObject(val, vartype);
            }
            return null;
        }
        catch (Exception e) {
            Debug.reportError("could not get local variable info: " + e);
            return null;
        }
    }

    public DebuggerObject getCurrentObject(int frameNo) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame frame = this.rt.frame(frameNo);
                return JdiObject.getDebuggerObject(frame.thisObject());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public DebuggerClass getCurrentClass(int frameNo) {
        try {
            if (this.rt.isSuspended()) {
                StackFrame frame = this.rt.frame(frameNo);
                return new JdiClass(frame.location().declaringType());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setSelectedFrame(int frame) {
        this.selectedFrame = frame;
    }

    public int getSelectedFrame() {
        return this.selectedFrame;
    }

    public void halt() {
        this.rt.suspend();
        JdiThreadNode jtn = this.jttm.findThreadNode(this.rt);
        if (jtn != null) {
            this.jttm.nodeChanged(jtn);
        }
    }

    public void cont() {
        this.rt.resume();
        JdiThreadNode jtn = this.jttm.findThreadNode(this.rt);
        if (jtn != null) {
            this.jttm.nodeChanged(jtn);
        }
    }

    public void step() {
        this.doStep(2);
    }

    public void stepInto() {
        this.doStep(1);
    }

    private void doStep(int depth) {
        this.clearPreviousStep(this.rt);
        StepRequest request = this.eventReqMgr.createStepRequest(this.rt, -2, depth);
        JdiThread.addExcludesToRequest(request);
        request.addCountFilter(1);
        request.putProperty("dontResume", "yes");
        request.enable();
        this.rt.resume();
        JdiThreadNode jtn = this.jttm.findThreadNode(this.rt);
        if (jtn != null) {
            this.jttm.nodeChanged(jtn);
        }
    }

    private void clearPreviousStep(ThreadReference thread) {
        if (this.eventReqMgr == null) {
            this.getEventRequestManager();
        }
        List<StepRequest> requests = this.eventReqMgr.stepRequests();
        for (StepRequest request : requests) {
            if (request == null || request.thread() == null || !request.thread().equals(thread)) continue;
            this.eventReqMgr.deleteEventRequest(request);
            break;
        }
    }

    private void getEventRequestManager() {
        this.eventReqMgr = this.rt.virtualMachine().eventRequestManager();
    }

    public String toString() {
        try {
            return this.getName() + " (" + this.getStatus() + ")";
        }
        catch (ObjectCollectedException oce) {
            return "collected";
        }
    }
}

